/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.faces.FacesException;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import javax.faces.model.ResultSetDataModel;

public class ResultSetDataModel
extends DataModel {
    private int index = -1;
    private ResultSetMetaData metadata = null;
    private ResultSet resultSet = null;
    private boolean updated = false;

    public ResultSetDataModel() {
        this(null);
    }

    public ResultSetDataModel(ResultSet resultSet) {
        this.setWrappedData((Object)resultSet);
    }

    public boolean isRowAvailable() {
        if (this.resultSet == null) {
            return false;
        }
        if (this.index < 0) {
            return false;
        }
        try {
            return this.resultSet.absolute(this.index + 1);
        }
        catch (SQLException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public int getRowCount() {
        return -1;
    }

    public Object getRowData() {
        if (this.resultSet == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException();
        }
        try {
            this.getMetaData();
            return new ResultSetMap(this, String.CASE_INSENSITIVE_ORDER);
        }
        catch (SQLException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public int getRowIndex() {
        return this.index;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        if (this.updated && this.resultSet != null) {
            try {
                if (!this.resultSet.rowDeleted()) {
                    this.resultSet.updateRow();
                }
                this.updated = false;
            }
            catch (SQLException e) {
                throw new FacesException((Throwable)e);
            }
        }
        int old = this.index;
        this.index = rowIndex;
        if (this.resultSet == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (old != this.index && listeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent((DataModel)this, this.index, rowData);
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                if (null == listeners[i]) continue;
                listeners[i].rowSelected(event);
            }
        }
    }

    public Object getWrappedData() {
        return this.resultSet;
    }

    public void setWrappedData(Object data) {
        if (data == null) {
            this.metadata = null;
            this.resultSet = null;
            this.setRowIndex(-1);
        } else {
            this.metadata = null;
            this.resultSet = (ResultSet)data;
            this.index = -1;
            this.setRowIndex(0);
        }
    }

    private ResultSetMetaData getMetaData() {
        if (this.metadata == null) {
            try {
                this.metadata = this.resultSet.getMetaData();
            }
            catch (SQLException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return this.metadata;
    }

    private void updated() {
        this.updated = true;
    }

    static /* synthetic */ int access$000(ResultSetDataModel x0) {
        return x0.index;
    }

    static /* synthetic */ ResultSet access$100(ResultSetDataModel x0) {
        return x0.resultSet;
    }

    static /* synthetic */ ResultSetMetaData access$200(ResultSetDataModel x0) {
        return x0.metadata;
    }

    static /* synthetic */ void access$300(ResultSetDataModel x0) {
        x0.updated();
    }
}

