/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.ContextCallback;
import javax.faces.component.NamingContainer;
import javax.faces.component.StateHolderSaver;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.ValueBindingValueExpressionAdapter;
import javax.faces.component.ValueExpressionValueBindingAdapter;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.render.Renderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public abstract class UIComponentBase
extends UIComponent {
    private static Logger log = Logger.getLogger("javax.faces.component", "javax.faces.LogStrings");
    private static Map<Class<?>, Map<String, PropertyDescriptor>> descriptors = new WeakHashMap();
    private Map<String, PropertyDescriptor> pdMap = null;
    private static Object[] empty = new Object[0];
    private Map<String, Object> attributes = null;
    private String clientId = null;
    private String id = null;
    private UIComponent parent = null;
    private boolean rendered = true;
    private boolean renderedSet = false;
    private String rendererType = null;
    private List<UIComponent> children = null;
    private static final String SEPARATOR_STRING = ":";
    private Map<String, UIComponent> facets = null;
    private List<FacesListener> listeners;
    private static final int MY_STATE = 0;
    private static final int CHILD_STATE = 1;
    private boolean transientFlag = false;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final Iterator EMPTY_ITERATOR = new /* Unavailable Anonymous Inner Class!! */;

    public UIComponentBase() {
        this.populateDescriptorsMapIfNecessary();
    }

    private void populateDescriptorsMapIfNecessary() {
        Class<?> clazz = this.getClass();
        this.pdMap = (Map)descriptors.get(clazz);
        if (null != this.pdMap) {
            return;
        }
        PropertyDescriptor[] pd = this.getPropertyDescriptors();
        if (pd != null) {
            Map reCheckMap;
            this.pdMap = new WeakHashMap(pd.length);
            for (PropertyDescriptor aPd : pd) {
                this.pdMap.put(aPd.getName(), aPd);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "fine.component.populating_descriptor_map", new Object[]{clazz, Thread.currentThread().getName()});
            }
            if (null != (reCheckMap = (Map)descriptors.get(clazz))) {
                return;
            }
            descriptors.put(clazz, this.pdMap);
        }
    }

    private PropertyDescriptor getPropertyDescriptor(String name) {
        if (this.pdMap != null) {
            return (PropertyDescriptor)this.pdMap.get(name);
        }
        return null;
    }

    private PropertyDescriptor[] getPropertyDescriptors() {
        PropertyDescriptor[] pd = null;
        try {
            pd = Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new FacesException((Throwable)e);
        }
        return pd;
    }

    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new AttributesMap(this, null);
        }
        return this.attributes;
    }

    public ValueBinding getValueBinding(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        Object result = null;
        ValueExpression ve = null;
        ve = this.getValueExpression(name);
        if (null != ve) {
            result = ve.getClass() == ValueExpressionValueBindingAdapter.class ? ((ValueExpressionValueBindingAdapter)ve).getWrapped() : new ValueBindingValueExpressionAdapter(ve);
        }
        return result;
    }

    public void setValueBinding(String name, ValueBinding binding) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (binding != null) {
            ValueExpressionValueBindingAdapter adapter = new ValueExpressionValueBindingAdapter(binding);
            this.setValueExpression(name, (ValueExpression)adapter);
        } else {
            this.setValueExpression(name, null);
        }
    }

    public ValueExpression getValueExpression(String name) {
        return super.getValueExpression(name);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        super.setValueExpression(name, binding);
    }

    public String getClientId(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.clientId == null) {
            Renderer renderer;
            UIComponent parent = this.getNamingContainer();
            String parentId = null;
            if (parent != null) {
                parentId = parent.getContainerClientId(context);
            }
            this.clientId = this.id;
            if (this.clientId == null) {
                this.clientId = context.getViewRoot().createUniqueId();
            }
            if (parentId != null) {
                this.clientId = parentId + ':' + this.clientId;
            }
            if ((renderer = this.getRenderer(context)) != null) {
                this.clientId = renderer.convertClientId(context, this.clientId);
            }
        }
        return this.clientId;
    }

    private UIComponent getNamingContainer() {
        for (UIComponent namingContainer = this.getParent(); namingContainer != null; namingContainer = namingContainer.getParent()) {
            if (!(namingContainer instanceof NamingContainer)) continue;
            return namingContainer;
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.validateId(id);
        this.id = id;
        this.clientId = null;
    }

    public UIComponent getParent() {
        return this.parent;
    }

    public void setParent(UIComponent parent) {
        this.parent = parent;
    }

    public boolean isRendered() {
        if (this.renderedSet) {
            return this.rendered;
        }
        ValueExpression ve = this.getValueExpression("rendered");
        if (ve != null) {
            boolean result = false;
            try {
                result = !Boolean.FALSE.equals(ve.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
            return result;
        }
        return this.rendered;
    }

    public void setRendered(boolean rendered) {
        this.rendered = rendered;
        this.renderedSet = true;
    }

    public String getRendererType() {
        if (this.rendererType != null) {
            return this.rendererType;
        }
        ValueExpression ve = this.getValueExpression("rendererType");
        if (ve != null) {
            String result = null;
            try {
                result = (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
            return result;
        }
        return null;
    }

    public void setRendererType(String rendererType) {
        this.rendererType = rendererType;
    }

    public boolean getRendersChildren() {
        boolean result = false;
        Renderer renderer = null;
        if (this.getRendererType() != null && null != (renderer = this.getRenderer(this.getFacesContext()))) {
            result = renderer.getRendersChildren();
        }
        return result;
    }

    public List<UIComponent> getChildren() {
        if (this.children == null) {
            this.children = new ChildrenList(this, null);
        }
        return this.children;
    }

    public int getChildCount() {
        if (this.children != null) {
            return this.children.size();
        }
        return 0;
    }

    private void eraseParent(UIComponent component) {
        List children;
        int index;
        UIComponent parent = component.getParent();
        if (parent == null) {
            return;
        }
        if (parent.getChildCount() > 0 && (index = (children = parent.getChildren()).indexOf(component)) >= 0) {
            children.remove(index);
            return;
        }
        if (parent.getFacetCount() > 0) {
            Map facets = parent.getFacets();
            Iterator entries = facets.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                if (entry.getValue() != component) continue;
                entries.remove();
                return;
            }
        }
        throw new IllegalStateException("Parent was not null, but this component not related");
    }

    private void validateId(String id) {
        if (id == null) {
            return;
        }
        int n = id.length();
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < n; ++i) {
            char c = id.charAt(i);
            if (!(i == 0 ? !Character.isLetter(c) && c != '_' : !Character.isLetter(c) && !Character.isDigit(c) && c != '-' && c != '_')) continue;
            throw new IllegalArgumentException(id);
        }
    }

    public UIComponent findComponent(String expr) {
        if (expr == null) {
            throw new NullPointerException();
        }
        UIComponentBase base = this;
        if (expr.charAt(0) == ':') {
            while (base.getParent() != null) {
                base = base.getParent();
            }
            expr = expr.substring(1);
        } else {
            while (base.getParent() != null && !(base instanceof NamingContainer)) {
                base = base.getParent();
            }
        }
        UIComponent result = null;
        String[] segments = expr.split(":");
        int i = 0;
        int length = segments.length - 1;
        while (i < segments.length) {
            result = this.findComponent((UIComponent)base, segments[i], length == 0);
            if (i == 0 && result == null && segments[i].equals(base.getId())) {
                result = base;
            }
            if (result == null && length > 0) {
                throw new IllegalArgumentException(segments[i]);
            }
            base = result;
            ++i;
            --length;
        }
        return result;
    }

    private UIComponent findComponent(UIComponent base, String id, boolean checkId) {
        UIComponent result = null;
        Iterator i = base.getFacetsAndChildren();
        while (i.hasNext()) {
            UIComponent kid = (UIComponent)i.next();
            if (!(kid instanceof NamingContainer)) {
                if (checkId && id.equals(kid.getId())) {
                    result = kid;
                    break;
                }
                result = this.findComponent(kid, id, checkId);
                if (result == null) continue;
                break;
            }
            if (!id.equals(kid.getId())) continue;
            result = kid;
            break;
        }
        return result;
    }

    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        return super.invokeOnComponent(context, clientId, callback);
    }

    public Map<String, UIComponent> getFacets() {
        if (this.facets == null) {
            this.facets = new FacetsMap(this, null);
        }
        return this.facets;
    }

    public int getFacetCount() {
        if (this.facets != null) {
            return this.facets.size();
        }
        return 0;
    }

    public UIComponent getFacet(String name) {
        if (this.facets != null) {
            return (UIComponent)this.facets.get(name);
        }
        return null;
    }

    public Iterator<UIComponent> getFacetsAndChildren() {
        Object result = null;
        int childCount = this.getChildCount();
        int facetCount = this.getFacetCount();
        if (0 == childCount && 0 == facetCount) {
            result = EMPTY_ITERATOR;
        } else if (0 == childCount) {
            Collection unmodifiable = Collections.unmodifiableCollection(this.getFacets().values());
            result = unmodifiable.iterator();
        } else if (0 == facetCount) {
            List unmodifiable = Collections.unmodifiableList(this.getChildren());
            result = unmodifiable.iterator();
        } else {
            result = new FacetsAndChildrenIterator((UIComponent)this);
        }
        return result;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            return;
        }
        for (FacesListener listener : this.listeners) {
            if (!event.isAppropriateListener(listener)) continue;
            event.processListener(listener);
        }
    }

    public void decode(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            this.getRenderer(context).decode(context, (UIComponent)this);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            this.getRenderer(context).encodeBegin(context, (UIComponent)this);
        }
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            this.getRenderer(context).encodeChildren(context, (UIComponent)this);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            this.getRenderer(context).encodeEnd(context, (UIComponent)this);
        }
    }

    protected void addFacesListener(FacesListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    protected FacesListener[] getFacesListeners(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (!FacesListener.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException();
        }
        if (this.listeners == null) {
            return (FacesListener[])Array.newInstance(clazz, 0);
        }
        ArrayList<FacesListener> results = new ArrayList<FacesListener>();
        for (FacesListener item : this.listeners) {
            if (!clazz.isAssignableFrom(item.getClass())) continue;
            results.add(item);
        }
        return (FacesListener[])results.toArray((Object[])Array.newInstance(clazz, results.size()));
    }

    protected void removeFacesListener(FacesListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void queueEvent(FacesEvent event) {
        if (event == null) {
            throw new NullPointerException();
        }
        UIComponent parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException();
        }
        parent.queueEvent(event);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processDecodes(context);
        }
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processUpdates(context);
        }
    }

    public Object processSaveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.isTransient()) {
            return null;
        }
        Object[] stateStruct = new Object[2];
        Object[] childState = EMPTY_ARRAY;
        stateStruct[0] = this.saveState(context);
        int count = this.getChildCount() + this.getFacetCount();
        if (count > 0) {
            ArrayList<Object> stateList = new ArrayList<Object>(count);
            if (this.getChildCount() > 0) {
                for (UIComponent kid : this.getChildren()) {
                    if (kid.isTransient()) continue;
                    stateList.add(kid.processSaveState(context));
                }
            }
            if (this.getFacetCount() > 0) {
                Iterator myFacets = this.getFacets().entrySet().iterator();
                UIComponent facet = null;
                Object facetState = null;
                Object[] facetSaveState = null;
                Map.Entry entry = null;
                while (myFacets.hasNext()) {
                    entry = myFacets.next();
                    facet = (UIComponent)entry.getValue();
                    if (facet.isTransient()) continue;
                    facetState = facet.processSaveState(context);
                    facetSaveState = new Object[]{entry.getKey(), facetState};
                    stateList.add(facetSaveState);
                }
            }
            childState = stateList.toArray();
        }
        stateStruct[1] = childState;
        return stateStruct;
    }

    public void processRestoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object[] stateStruct = (Object[])state;
        Object[] childState = (Object[])stateStruct[1];
        this.restoreState(context, stateStruct[0]);
        int i = 0;
        if (this.getChildCount() > 0) {
            for (UIComponent kid : this.getChildren()) {
                Object currentState;
                if (kid.isTransient() || (currentState = childState[i++]) == null) continue;
                kid.processRestoreState(context, currentState);
            }
        }
        if (this.getFacetCount() > 0) {
            int facetsSize = this.getFacets().size();
            Object[] facetSaveState = null;
            String facetName = null;
            UIComponent facet = null;
            Object facetState = null;
            for (int j = 0; j < facetsSize; ++j) {
                if (null == (facetSaveState = (Object[])childState[i++])) continue;
                facetName = (String)facetSaveState[0];
                facetState = facetSaveState[1];
                facet = (UIComponent)this.getFacets().get(facetName);
                facet.processRestoreState(context, facetState);
            }
        }
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    protected Renderer getRenderer(FacesContext context) {
        String rendererType = this.getRendererType();
        Renderer result = null;
        if (rendererType != null) {
            result = context.getRenderKit().getRenderer(this.getFamily(), rendererType);
            if (null == result && log.isLoggable(Level.FINE)) {
                log.fine("Can't get Renderer for type " + rendererType);
            }
        } else if (log.isLoggable(Level.FINE)) {
            String id = this.getId();
            id = null != id ? id : this.getClass().getName();
            log.fine("No renderer-type for component " + id);
        }
        return result;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[8];
        if (this.attributes != null) {
            HashMap attributesCopy;
            values[0] = attributesCopy = new HashMap(this.attributes);
        }
        values[1] = this.saveBindingsState(context);
        values[2] = this.clientId;
        values[3] = this.id;
        values[4] = this.rendered ? Boolean.TRUE : Boolean.FALSE;
        values[5] = this.renderedSet ? Boolean.TRUE : Boolean.FALSE;
        values[6] = this.rendererType;
        values[7] = UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.listeners);
        assert (!this.transientFlag);
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.attributes = this.getAttributes();
        if (values[0] != null) {
            Map attributesCopy = (Map)values[0];
            for (Map.Entry entry : attributesCopy.entrySet()) {
                this.attributes.put((String)entry.getKey(), entry.getValue());
            }
        }
        this.bindings = this.restoreBindingsState(context, values[1]);
        this.clientId = (String)values[2];
        this.id = (String)values[3];
        this.rendered = (Boolean)values[4];
        this.renderedSet = (Boolean)values[5];
        this.rendererType = (String)values[6];
        List restoredListeners = null;
        restoredListeners = (List)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)values[7]);
        if (null != restoredListeners) {
            if (null != this.listeners) {
                this.listeners.addAll(restoredListeners);
            } else {
                this.listeners = restoredListeners;
            }
        }
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }

    public static Object saveAttachedState(FacesContext context, Object attachedObject) {
        if (null == context) {
            throw new NullPointerException();
        }
        if (null == attachedObject) {
            return null;
        }
        Object result = null;
        List attachedList = null;
        ArrayList<StateHolderSaver> resultList = null;
        Iterator listIter = null;
        if (attachedObject instanceof List) {
            attachedList = (List)attachedObject;
            resultList = new ArrayList<StateHolderSaver>(attachedList.size());
            listIter = attachedList.iterator();
            Object cur = null;
            while (listIter.hasNext()) {
                Object e = listIter.next();
                cur = e;
                if (null == e) continue;
                resultList.add(new StateHolderSaver(context, cur));
            }
            result = resultList;
        } else {
            result = new StateHolderSaver(context, attachedObject);
        }
        return result;
    }

    public static Object restoreAttachedState(FacesContext context, Object stateObj) throws IllegalStateException {
        if (null == context) {
            throw new NullPointerException();
        }
        if (null == stateObj) {
            return null;
        }
        ArrayList<Object> result = null;
        List stateList = null;
        ArrayList<Object> resultList = null;
        Iterator iter = null;
        StateHolderSaver saver = null;
        if (stateObj instanceof List) {
            stateList = (List)stateObj;
            resultList = new ArrayList<Object>(stateList.size());
            iter = stateList.iterator();
            while (iter.hasNext()) {
                try {
                    saver = (StateHolderSaver)iter.next();
                }
                catch (ClassCastException cce) {
                    throw new IllegalStateException("Unknown object type");
                }
                resultList.add(saver.restore(context));
            }
            result = resultList;
        } else if (stateObj instanceof StateHolderSaver) {
            saver = (StateHolderSaver)stateObj;
            result = saver.restore(context);
        } else {
            throw new IllegalStateException("Unknown object type");
        }
        return result;
    }

    private Map restoreBindingsState(FacesContext context, Object state) {
        if (state == null) {
            return null;
        }
        Object[] values = (Object[])state;
        String[] names = (String[])values[0];
        Object[] states = (Object[])values[1];
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        for (int i = 0; i < names.length; ++i) {
            bindings.put(names[i], UIComponentBase.restoreAttachedState((FacesContext)context, (Object)states[i]));
        }
        return bindings;
    }

    private Object saveBindingsState(FacesContext context) {
        if (this.bindings == null) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Object> states = new ArrayList<Object>();
        for (String key : this.bindings.keySet()) {
            ValueExpression binding = (ValueExpression)this.bindings.get(key);
            names.add(key);
            states.add(UIComponentBase.saveAttachedState((FacesContext)context, (Object)binding));
        }
        Object[] values = new Object[]{names.toArray(new String[names.size()]), states.toArray(new Object[states.size()])};
        return values;
    }

    static /* synthetic */ PropertyDescriptor access$300(UIComponentBase x0, String x1) {
        return x0.getPropertyDescriptor(x1);
    }

    static /* synthetic */ Object[] access$400() {
        return empty;
    }

    static /* synthetic */ void access$500(UIComponentBase x0, UIComponent x1) {
        x0.eraseParent(x1);
    }

    static /* synthetic */ Iterator access$600() {
        return EMPTY_ITERATOR;
    }
}

