/*
 * Decompiled with CFR 0.152.
 */
package javax.faces;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKitFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class FactoryFinder {
    public static final String APPLICATION_FACTORY = "javax.faces.application.ApplicationFactory";
    public static final String FACES_CONTEXT_FACTORY = "javax.faces.context.FacesContextFactory";
    public static final String LIFECYCLE_FACTORY = "javax.faces.lifecycle.LifecycleFactory";
    public static final String RENDER_KIT_FACTORY = "javax.faces.render.RenderKitFactory";
    private static HashMap applicationMaps = new HashMap();
    private static String[] factoryNames = new String[]{"javax.faces.application.ApplicationFactory", "javax.faces.context.FacesContextFactory", "javax.faces.lifecycle.LifecycleFactory", "javax.faces.render.RenderKitFactory"};
    private static Map factoryClasses = null;
    private static final Logger LOGGER = Logger.getLogger("javax.faces", "javax.faces.LogStrings");

    FactoryFinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getFactory(String factoryName) throws FacesException {
        FactoryFinder.validateFactoryName((String)factoryName);
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        HashMap hashMap = applicationMaps;
        synchronized (hashMap) {
            Map appMap = FactoryFinder.getApplicationMap();
            Object factory = null;
            Object factoryOrList = appMap.get(factoryName);
            if (factoryOrList != null && !(factoryOrList instanceof List)) {
                return factoryOrList;
            }
            factory = FactoryFinder.getImplementationInstance((ClassLoader)classLoader, (String)factoryName, (List)((List)factoryOrList));
            if (null == factory) {
                ResourceBundle rb = LOGGER.getResourceBundle();
                String message = rb.getString("severe.no_factory");
                message = MessageFormat.format(message, factoryName);
                throw new IllegalStateException(message);
            }
            appMap.put(factoryName, factory);
            return factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFactory(String factoryName, String implName) {
        FactoryFinder.validateFactoryName((String)factoryName);
        ArrayList previouslySetFactories = null;
        Map appMap = null;
        HashMap hashMap = applicationMaps;
        synchronized (hashMap) {
            appMap = FactoryFinder.getApplicationMap();
            Object v = appMap.get(factoryName);
            previouslySetFactories = (ArrayList)v;
            if (null != v) {
                if (!(previouslySetFactories instanceof List)) {
                    return;
                }
            } else {
                previouslySetFactories = new ArrayList();
                appMap.put(factoryName, previouslySetFactories);
            }
            ((List)previouslySetFactories).add(0, implName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseFactories() throws FacesException {
        ClassLoader cl = FactoryFinder.getClassLoader();
        HashMap hashMap = applicationMaps;
        synchronized (hashMap) {
            HashMap map = (HashMap)applicationMaps.get(cl);
            if (map != null) {
                map.clear();
                applicationMaps.remove(cl);
            }
        }
    }

    private static ClassLoader getClassLoader() throws FacesException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            throw new FacesException("getContextClassLoader");
        }
        return cl;
    }

    private static Object getImplementationInstance(ClassLoader classLoader, String factoryName, List implementations) throws FacesException {
        Object result = null;
        String curImplClass = null;
        int len = 0;
        boolean i = false;
        if (null != implementations && (1 < (len = implementations.size()) || 1 == len)) {
            curImplClass = (String)implementations.remove(len - 1);
            result = FactoryFinder.getImplGivenPreviousImpl((ClassLoader)classLoader, (String)factoryName, (String)curImplClass, null);
        }
        if (null != (curImplClass = FactoryFinder.getImplNameFromServices((ClassLoader)classLoader, (String)factoryName))) {
            result = FactoryFinder.getImplGivenPreviousImpl((ClassLoader)classLoader, (String)factoryName, (String)curImplClass, result);
        }
        if (null != implementations) {
            for (len = implementations.size() - 1; 0 <= len; --len) {
                curImplClass = (String)implementations.remove(len);
                result = FactoryFinder.getImplGivenPreviousImpl((ClassLoader)classLoader, (String)factoryName, (String)curImplClass, (Object)result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getImplNameFromServices(ClassLoader classLoader, String factoryName) {
        String result;
        block27: {
            result = null;
            BufferedReader reader = null;
            String resourceName = "META-INF/services/" + factoryName;
            Object props = null;
            InputStream stream = null;
            try {
                stream = classLoader.getResourceAsStream(resourceName);
                if (stream == null) break block27;
                try {
                    reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    reader = new BufferedReader(new InputStreamReader(stream));
                }
                result = reader.readLine();
                reader.close();
                reader = null;
                stream = null;
            }
            catch (IOException e) {
            }
            catch (SecurityException e) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable t) {}
                    reader = null;
                    stream = null;
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {}
                    stream = null;
                }
            }
        }
        return result;
    }

    private static Object getImplGivenPreviousImpl(ClassLoader classLoader, String factoryName, String implName, Object previousImpl) {
        Class<?> clazz = null;
        Class factoryClass = null;
        Class[] getCtorArg = null;
        Object[] newInstanceArgs = new Object[1];
        Constructor<?> ctor = null;
        Object result = null;
        if (null != previousImpl && null != (factoryClass = FactoryFinder.getFactoryClass((ClassLoader)classLoader, (String)factoryName))) {
            try {
                clazz = classLoader.loadClass(implName);
                getCtorArg = new Class[]{factoryClass};
                ctor = clazz.getConstructor(getCtorArg);
                newInstanceArgs[0] = previousImpl;
                result = ctor.newInstance(newInstanceArgs);
            }
            catch (NoSuchMethodException nsme) {
                factoryClass = null;
            }
            catch (Exception e) {
                throw new FacesException(implName, (Throwable)e);
            }
        }
        if (null == previousImpl || null == factoryClass) {
            try {
                clazz = classLoader.loadClass(implName);
                result = clazz.newInstance();
            }
            catch (Exception e) {
                throw new FacesException(implName, (Throwable)e);
            }
        }
        return result;
    }

    private static Class getFactoryClass(ClassLoader classLoader, String factoryClassName) {
        if (null == factoryClasses) {
            factoryClasses = new HashMap(factoryNames.length);
            factoryClasses.put("javax.faces.application.ApplicationFactory", ApplicationFactory.class);
            factoryClasses.put("javax.faces.context.FacesContextFactory", FacesContextFactory.class);
            factoryClasses.put("javax.faces.lifecycle.LifecycleFactory", LifecycleFactory.class);
            factoryClasses.put("javax.faces.render.RenderKitFactory", RenderKitFactory.class);
        }
        return (Class)factoryClasses.get(factoryClassName);
    }

    private static Map getApplicationMap() {
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        HashMap result = null;
        result = (HashMap)applicationMaps.get(classLoader);
        if (result == null) {
            result = new HashMap();
            applicationMaps.put(classLoader, result);
        }
        return result;
    }

    private static void validateFactoryName(String factoryName) {
        if (factoryName == null) {
            throw new NullPointerException();
        }
        boolean found = false;
        for (int i = 0; i < factoryNames.length; ++i) {
            if (!factoryName.equals(factoryNames[i])) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException(factoryName);
        }
    }
}

