/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeELResolver
extends ELResolver {
    private final ArrayList<ELResolver> elResolvers = new ArrayList();

    public void add(ELResolver elResolver) {
        if (elResolver == null) {
            throw new NullPointerException();
        }
        this.elResolvers.add(elResolver);
    }

    public Object getValue(ELContext context, Object base, Object property) {
        context.setPropertyResolved(false);
        int len = this.elResolvers.size();
        for (int i = 0; i < len; ++i) {
            ELResolver elResolver = (ELResolver)this.elResolvers.get(i);
            Object value = elResolver.getValue(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return value;
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        context.setPropertyResolved(false);
        int len = this.elResolvers.size();
        for (int i = 0; i < len; ++i) {
            ELResolver elResolver = (ELResolver)this.elResolvers.get(i);
            Class type = elResolver.getType(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return type;
        }
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object val) {
        context.setPropertyResolved(false);
        int len = this.elResolvers.size();
        for (int i = 0; i < len; ++i) {
            ELResolver elResolver = (ELResolver)this.elResolvers.get(i);
            elResolver.setValue(context, base, property, val);
            if (!context.isPropertyResolved()) continue;
            return;
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        context.setPropertyResolved(false);
        int len = this.elResolvers.size();
        for (int i = 0; i < len; ++i) {
            ELResolver elResolver = (ELResolver)this.elResolvers.get(i);
            boolean readOnly = elResolver.isReadOnly(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return readOnly;
        }
        return false;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return new CompositeIterator(this.elResolvers.iterator(), context, base);
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        Class commonPropertyType = null;
        for (ELResolver elResolver : this.elResolvers) {
            Class type = elResolver.getCommonPropertyType(context, base);
            if (type == null) continue;
            if (commonPropertyType == null) {
                commonPropertyType = type;
                continue;
            }
            if (commonPropertyType.isAssignableFrom(type)) continue;
            if (type.isAssignableFrom(commonPropertyType)) {
                commonPropertyType = type;
                continue;
            }
            return null;
        }
        return commonPropertyType;
    }
}

