/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.BeanELResolver;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ELUtil;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class BeanELResolver
extends ELResolver {
    private boolean isReadOnly;
    private static final int SIZE = 2000;
    private static final Map<Class, BeanProperties> properties = new ConcurrentHashMap(2000);
    private static final Map<Class, BeanProperties> properties2 = new ConcurrentHashMap(2000);

    public BeanELResolver() {
        this.isReadOnly = false;
    }

    public BeanELResolver(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        BeanProperty bp = this.getBeanProperty(context, base, property);
        context.setPropertyResolved(true);
        return bp.getPropertyType();
    }

    public Object getValue(ELContext context, Object base, Object property) {
        Object value;
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        BeanProperty bp = this.getBeanProperty(context, base, property);
        Method method = bp.getReadMethod();
        if (method == null) {
            throw new PropertyNotFoundException(ELUtil.getExceptionMessageString((ELContext)context, (String)"propertyNotReadable", (Object[])new Object[]{base.getClass().getName(), property.toString()}));
        }
        try {
            value = method.invoke(base, new Object[0]);
            context.setPropertyResolved(true);
        }
        catch (ELException ex) {
            throw ex;
        }
        catch (InvocationTargetException ite) {
            throw new ELException(ite.getCause());
        }
        catch (Exception ex) {
            throw new ELException((Throwable)ex);
        }
        return value;
    }

    public void setValue(ELContext context, Object base, Object property, Object val) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return;
        }
        if (this.isReadOnly) {
            throw new PropertyNotWritableException(ELUtil.getExceptionMessageString((ELContext)context, (String)"resolverNotwritable", (Object[])new Object[]{base.getClass().getName()}));
        }
        BeanProperty bp = this.getBeanProperty(context, base, property);
        Method method = bp.getWriteMethod();
        if (method == null) {
            throw new PropertyNotWritableException(ELUtil.getExceptionMessageString((ELContext)context, (String)"propertyNotWritable", (Object[])new Object[]{base.getClass().getName(), property.toString()}));
        }
        try {
            method.invoke(base, val);
            context.setPropertyResolved(true);
        }
        catch (ELException ex) {
            throw ex;
        }
        catch (InvocationTargetException ite) {
            throw new ELException(ite.getCause());
        }
        catch (Exception ex) {
            if (null == val) {
                val = "null";
            }
            String message = ELUtil.getExceptionMessageString((ELContext)context, (String)"setPropertyFailed", (Object[])new Object[]{property.toString(), base.getClass().getName(), val});
            throw new ELException(message, (Throwable)ex);
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return false;
        }
        context.setPropertyResolved(true);
        if (this.isReadOnly) {
            return true;
        }
        BeanProperty bp = this.getBeanProperty(context, base, property);
        return bp.isReadOnly();
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        BeanInfo info = null;
        try {
            info = Introspector.getBeanInfo(base.getClass());
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (info == null) {
            return null;
        }
        ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>(info.getPropertyDescriptors().length);
        for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
            pd.setValue("type", pd.getPropertyType());
            pd.setValue("resolvableAtDesignTime", Boolean.TRUE);
            list.add(pd);
        }
        return list.iterator();
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        return Object.class;
    }

    private static Method getMethod(Class cl, Method method) {
        if (Modifier.isPublic(cl.getModifiers())) {
            return method;
        }
        Class<?>[] interfaces = cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> c = interfaces[i];
            Method m = null;
            try {
                m = c.getMethod(method.getName(), method.getParameterTypes());
                c = m.getDeclaringClass();
                m = BeanELResolver.getMethod(c, (Method)m);
                if (m == null) continue;
                return m;
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        Class<Object> c = cl.getSuperclass();
        if (c != null) {
            Method m = null;
            try {
                m = c.getMethod(method.getName(), method.getParameterTypes());
                c = m.getDeclaringClass();
                m = BeanELResolver.getMethod(c, (Method)m);
                if (m != null) {
                    return m;
                }
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        return null;
    }

    private BeanProperty getBeanProperty(ELContext context, Object base, Object prop) {
        BeanProperty bp;
        String property = prop.toString();
        Class<?> baseClass = base.getClass();
        BeanProperties bps = (BeanProperties)properties.get(baseClass);
        if (bps == null && (bps = (BeanProperties)properties2.get(baseClass)) == null) {
            if (properties.size() > 2000) {
                properties2.clear();
                properties2.putAll(properties);
                properties.clear();
            }
            bps = new BeanProperties(baseClass);
            properties.put(baseClass, bps);
        }
        if ((bp = bps.getBeanProperty(property)) == null) {
            throw new PropertyNotFoundException(ELUtil.getExceptionMessageString((ELContext)context, (String)"propertyNotFound", (Object[])new Object[]{baseClass.getName(), property}));
        }
        return bp;
    }

    static /* synthetic */ Method access$000(Class x0, Method x1) {
        return BeanELResolver.getMethod((Class)x0, (Method)x1);
    }
}

