/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.security;

import com.agitar.common.util.AgitarProperties;
import com.agitar.security.AgPolicy;
import java.io.File;
import java.io.IOException;
import java.security.PrivilegedAction;

public abstract class Wildcard {
    public static final char SEPARATOR = '/';
    public static final String ALL_FILES = "<<ALL FILES>>";
    static /* synthetic */ Class class$com$agitar$security$Wildcard;

    public static Wildcard getWildcard(final String pattern) {
        return (Wildcard)AgPolicy.doPrivilegedAction(new PrivilegedAction(){

            public Object run() {
                if (pattern.equals(Wildcard.ALL_FILES)) {
                    return new UniversalWildcard();
                }
                if (pattern.startsWith("**")) {
                    return new StandardWildcard(pattern);
                }
                if (pattern.length() >= 2 && pattern.charAt(pattern.length() - 1) == '*' && pattern.charAt(pattern.length() - 2) == '/') {
                    return new DirectoryWildcard(Wildcard.canonicalize(pattern));
                }
                if (pattern.length() >= 2 && pattern.charAt(pattern.length() - 1) == '-' && pattern.charAt(pattern.length() - 2) == '/') {
                    return new RecursiveDirectoryWildcard(Wildcard.canonicalize(pattern));
                }
                if (pattern.indexOf(42) >= 0) {
                    return new StandardWildcard(Wildcard.canonicalize(pattern));
                }
                return new NonWildcard(Wildcard.canonicalize(pattern));
            }
        });
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        return o.getClass() == this.getClass() && o.toString().equals(this.toString());
    }

    public abstract boolean match(String var1);

    public static String canonicalize(String path) {
        int lastAsterisk = path.lastIndexOf(42);
        String base = "";
        if (lastAsterisk >= 0) {
            int lastSlash = path.lastIndexOf(47, lastAsterisk);
            if (lastSlash < 0) {
                base = (String)AgPolicy.doPrivilegedAction(new GetUserDir()) + '/';
            } else {
                base = (String)AgPolicy.doPrivilegedAction(new Canonicalize(path.substring(0, lastSlash)));
                path = path.substring(lastSlash);
            }
            path = base + path;
        } else {
            path = (String)AgPolicy.doPrivilegedAction(new Canonicalize(path));
        }
        if (AgitarProperties.OS_NAME.startsWith("Windows")) {
            path = path.toLowerCase();
        }
        path = path.replace(File.separatorChar, '/');
        return path;
    }

    private static boolean match(String pattern, String text) {
        int len = pattern.length();
        if (pattern.charAt(0) != '*') {
            return Wildcard.matchStart(pattern, text);
        }
        if (len == 1) {
            return text.indexOf(47) < 0;
        }
        if (pattern.charAt(1) == '*') {
            return len == 2 || Wildcard.matchDoubleWildcard(pattern, text);
        }
        return Wildcard.matchWildcard(pattern, text);
    }

    private static boolean matchStart(String pattern, String name) {
        int next = pattern.indexOf(42, 0);
        if (next < 0) {
            return name.equals(pattern);
        }
        String part = pattern.substring(0, next);
        return name.startsWith(part) && Wildcard.match(pattern.substring(next), name.substring(next));
    }

    private static boolean matchWildcard(String pattern, String text) {
        int pnext = pattern.indexOf(42, 1);
        if (pnext < 0) {
            String part = pattern.substring(1);
            return text.endsWith(part) && Wildcard.noSlash(text, text.length() - part.length());
        }
        String part = pattern.substring(1, pnext);
        int start = 0;
        while (start < text.length()) {
            int index = text.indexOf(part, start);
            int tnext = index + part.length();
            if (index < 0 || !Wildcard.noSlash(text, index)) {
                return false;
            }
            if (Wildcard.match(pattern.substring(pnext), text.substring(tnext))) {
                return true;
            }
            start = index + 1;
        }
        return false;
    }

    private static boolean matchDoubleWildcard(String pattern, String text) {
        int pnext = pattern.indexOf(42, 2);
        if (pnext < 0) {
            String part = pattern.substring(2);
            return text.endsWith(part);
        }
        String part = pattern.substring(2, pnext);
        int start = 0;
        while (start < text.length()) {
            int index = text.indexOf(part, start);
            int tnext = index + part.length();
            if (index < 0) {
                return false;
            }
            if (Wildcard.match(pattern.substring(pnext), text.substring(tnext))) {
                return true;
            }
            start = index + 1;
        }
        return false;
    }

    private static boolean noSlash(String text, int len) {
        return text.substring(0, len).indexOf(47) < 0;
    }

    private static class GetUserDir
    implements PrivilegedAction {
        private GetUserDir() {
        }

        public Object run() {
            return System.getProperty("user.dir");
        }
    }

    private static class Canonicalize
    implements PrivilegedAction {
        private String cpath;

        public Canonicalize(String cpath) {
            this.cpath = cpath;
        }

        public Object run() {
            File file = new File(this.cpath.replace('/', File.separatorChar));
            if (this.cpath.indexOf(0) >= 0) {
                return file.getAbsolutePath().replace(File.separatorChar, '/');
            }
            try {
                return file.getCanonicalPath().replace(File.separatorChar, '/');
            }
            catch (IOException e) {
                return file.getAbsolutePath().replace(File.separatorChar, '/');
            }
        }
    }

    private static class StandardWildcard
    extends Wildcard {
        private final String pattern;

        public StandardWildcard(String pattern) {
            this.pattern = pattern;
        }

        public boolean match(String text) {
            return text != null && Wildcard.match(this.pattern, text);
        }

        public String toString() {
            return this.pattern;
        }
    }

    private static class RecursiveDirectoryWildcard
    extends Wildcard {
        private final String head;
        static final /* synthetic */ boolean $assertionsDisabled;

        public RecursiveDirectoryWildcard(String pattern) {
            if (!$assertionsDisabled && !pattern.endsWith("/-")) {
                throw new AssertionError();
            }
            this.head = pattern.substring(0, pattern.length() - 1);
        }

        public boolean match(String text) {
            return text != null && text.startsWith(this.head) && text.length() > this.head.length();
        }

        public String toString() {
            return this.head + '-';
        }

        static {
            $assertionsDisabled = !(class$com$agitar$security$Wildcard == null ? (class$com$agitar$security$Wildcard = Wildcard.class$("com.agitar.security.Wildcard")) : class$com$agitar$security$Wildcard).desiredAssertionStatus();
        }
    }

    private static class DirectoryWildcard
    extends Wildcard {
        private final String head;
        static final /* synthetic */ boolean $assertionsDisabled;

        public DirectoryWildcard(String pattern) {
            if (!$assertionsDisabled && !pattern.endsWith("/*")) {
                throw new AssertionError();
            }
            this.head = pattern.substring(0, pattern.length() - 1);
        }

        public boolean match(String text) {
            return text != null && text.startsWith(this.head) && text.length() > this.head.length() && text.substring(this.head.length()).indexOf(47) < 0;
        }

        public String toString() {
            return this.head + '*';
        }

        static {
            $assertionsDisabled = !(class$com$agitar$security$Wildcard == null ? (class$com$agitar$security$Wildcard = Wildcard.class$("com.agitar.security.Wildcard")) : class$com$agitar$security$Wildcard).desiredAssertionStatus();
        }
    }

    private static class NonWildcard
    extends Wildcard {
        private final String pattern;

        public NonWildcard(String pattern) {
            this.pattern = pattern;
        }

        public boolean match(String text) {
            return text != null && text.equals(this.pattern);
        }

        public String toString() {
            return this.pattern;
        }
    }

    private static class UniversalWildcard
    extends Wildcard {
        private UniversalWildcard() {
        }

        public boolean match(String text) {
            return text != null;
        }

        public String toString() {
            return Wildcard.ALL_FILES;
        }
    }
}

