/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.security;

import com.agitar.common.util.AgitarProperties;
import com.agitar.common.util.StringUtility;
import com.agitar.lib.NoObfuscation;
import com.agitar.security.AgFilePermission;
import java.io.File;
import java.security.BasicPermission;
import java.security.Permission;

public class TempDirPermission
extends BasicPermission
implements NoObfuscation {
    private Permission permItself = null;
    private AgFilePermission perm;

    public TempDirPermission(String name, String actions) {
        super(name, actions);
        String tmpDir = AgitarProperties.TMPDIR;
        if (!StringUtility.nullOrEmpty(actions)) {
            String[] selfActions = actions.split(",");
            StringBuffer selfActionsStr = new StringBuffer();
            for (int i = 0; i < selfActions.length; ++i) {
                String act = selfActions[i].trim();
                if ("".equals(act) || "delete".equals(act)) continue;
                selfActionsStr.append(act).append(',');
            }
            if (selfActionsStr.length() > 0) {
                selfActionsStr.deleteCharAt(selfActionsStr.length() - 1);
                this.permItself = new AgFilePermission(tmpDir, selfActionsStr.toString());
            }
            this.perm = new AgFilePermission(tmpDir + File.separator + "-", actions);
        }
    }

    public String getActions() {
        return this.perm == null ? "" : this.perm.getActions();
    }

    public boolean implies(Permission p) {
        return this.perm != null && this.perm.implies(p) || this.permItself != null && this.permItself.implies(p);
    }
}

