/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.security;

import com.agitar.common.util.AgitarProperties;
import com.agitar.security.AgFilePermission;
import com.agitar.security.AgSocketPermission;
import com.agitar.security.TempDirPermission;
import java.awt.AWTPermission;
import java.io.FilePermission;
import java.io.SerializablePermission;
import java.lang.reflect.ReflectPermission;
import java.net.NetPermission;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.SecurityPermission;
import java.sql.SQLPermission;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.PropertyPermission;
import java.util.logging.LoggingPermission;
import javax.net.ssl.SSLPermission;
import javax.security.auth.AuthPermission;
import javax.security.auth.PrivateCredentialPermission;
import javax.security.auth.kerberos.DelegationPermission;
import javax.sound.sampled.AudioPermission;

public class PermissionsHelper {
    private static void addMorePrivilegedPermissions(List p) {
        p.add(new FilePermission("<<ALL FILES>>", "read"));
    }

    private static void addPrivilegedPermissions(List p) {
        p.add(new SecurityPermission("*"));
        p.add(new RuntimePermission("shutdownHooks"));
        p.add(new RuntimePermission("queuePrintJob"));
        p.add(new NetPermission("specifyStreamHandler"));
        p.add(new AudioPermission("play"));
        p.add(new AgSocketPermission("localhost", "resolve"));
        p.add(new AgSocketPermission("127.0.0.1", "resolve"));
        p.add(new RuntimePermission("loadLibrary.*"));
        p.add(new RuntimePermission("createSecurityManager"));
    }

    private static void addCommonPermissions(List p) {
        PermissionsHelper.addBasicCommonPermissions(p);
        PermissionsHelper.addExtraCommonPermissions(p);
    }

    private static void addBasicCommonPermissions(List p) {
        p.add(new SecurityPermission("get.*"));
        p.add(new AWTPermission("accessClipboard"));
        p.add(new AWTPermission("accessEventQueue"));
        p.add(new AWTPermission("listenToAllAWTEvents"));
        p.add(new AWTPermission("readDisplayPixels"));
        p.add(new AWTPermission("showWindowWithoutWarningBanner"));
        p.add(new SerializablePermission("enableSubclassImplementation"));
        p.add(new SerializablePermission("enableSubstitution"));
        p.add(new ReflectPermission("suppressAccessChecks"));
        p.add(new RuntimePermission("getClassLoader"));
        p.add(new RuntimePermission("createClassLoader"));
        p.add(new RuntimePermission("enableContextClassLoaderOverride"));
        p.add(new RuntimePermission("setContextClassLoader"));
        p.add(new RuntimePermission("setFactory"));
        p.add(new RuntimePermission("setIO"));
        p.add(new RuntimePermission("modifyThread"));
        p.add(new RuntimePermission("stopThread"));
        p.add(new RuntimePermission("modifyThreadGroup"));
        p.add(new RuntimePermission("getProtectionDomain"));
        p.add(new RuntimePermission("readFileDescriptor"));
        p.add(new RuntimePermission("accessClassInPackage.*"));
        p.add(new RuntimePermission("defineClassInPackage.*"));
        p.add(new RuntimePermission("accessDeclaredMembers"));
        p.add(new RuntimePermission("selectProvider"));
        p.add(new RuntimePermission("charsetProvider"));
        p.add(new NetPermission("setDefaultAuthenticator"));
        p.add(new NetPermission("requestPasswordAuthentication"));
        p.add(new SQLPermission("setLog"));
        p.add(new PropertyPermission("*", "read,write"));
        p.add(new LoggingPermission("control", null));
        p.add(new SSLPermission("setHostnameVerifier"));
        p.add(new SSLPermission("getSSLSessionContext"));
        p.add(new SSLPermission("setDefaultSSLContext"));
        p.add(new AuthPermission("doAs"));
        p.add(new AuthPermission("doAsPrivileged"));
        p.add(new AuthPermission("getSubject"));
        p.add(new AuthPermission("getSubjectFromDomainCombiner"));
        p.add(new AuthPermission("setReadOnly"));
        p.add(new AuthPermission("modifyPrincipals"));
        p.add(new AuthPermission("modifyPublicCredentials"));
        p.add(new AuthPermission("modifyPrivateCredentials"));
        p.add(new AuthPermission("refreshCredential"));
        p.add(new AuthPermission("destroyCredential"));
        p.add(new AuthPermission("createLoginContext.*"));
        p.add(new AuthPermission("getLoginConfiguration"));
        p.add(new AuthPermission("setLoginConfiguration"));
        p.add(new RuntimePermission("reflectionFactoryAccess"));
        p.add(new AuthPermission("createLoginConfiguration.*"));
        p.add(new AuthPermission("refreshLoginConfiguration"));
        p.add(new PrivateCredentialPermission("* * \"*\"", "read"));
        p.add(new DelegationPermission("\"*\" \"*\""));
        p.add(new RuntimePermission("loadLibrary.awt"));
        p.add(new RuntimePermission("loadLibrary.fontmanager"));
        p.add(new RuntimePermission("loadLibrary.net"));
        p.add(new RuntimePermission("loadLibrary.jpeg"));
        p.add(new RuntimePermission("loadLibrary.zip"));
    }

    private static void addExtraCommonPermissions(List p) {
        p.add(new AgFilePermission("../-", "read"));
        p.add(new AgFilePermission(".", "read"));
        p.add(new AgFilePermission("./-", "read"));
        p.add(new AgFilePermission(AgitarProperties.TMPDIR, "read,write"));
        p.add(new AgFilePermission(AgitarProperties.TMPDIR + "/-", "read,write,delete"));
        PermissionsHelper.addClasspathReadPermissions(p);
        PermissionsHelper.addJavaHomeReadPermissions(p);
        PermissionsHelper.addUserHomeReadPermissions(p);
    }

    private static void addClasspathReadPermissions(List p) {
        String[] classpath = AgitarProperties.CLASS_PATH;
        for (int i = 0; i < classpath.length; ++i) {
            p.add(new AgFilePermission(classpath[i], "read"));
            p.add(new AgFilePermission(classpath[i] + "/-", "read"));
        }
    }

    private static void addJavaHomeReadPermissions(List p) {
        p.add(new AgFilePermission(AgitarProperties.JAVA_HOME.getAbsolutePath(), "read"));
        p.add(new AgFilePermission(AgitarProperties.JAVA_HOME.getAbsolutePath() + "/-", "read"));
    }

    private static void addUserHomeReadPermissions(List p) {
        p.add(new AgFilePermission(AgitarProperties.USER_HOME.getAbsolutePath(), "read"));
        p.add(new AgFilePermission(AgitarProperties.USER_HOME.getAbsolutePath() + "/-", "read"));
    }

    public static List getJUnitFactoryPermissions() {
        if (!AgitarProperties.LOCKDOWN) {
            return PermissionsHelper.getTestGenPermissions();
        }
        ArrayList p = new ArrayList();
        PermissionsHelper.addCommonPermissions(p);
        return p;
    }

    public static List getTestRunnerPermissions() {
        return PermissionsHelper.getTestGenPermissions();
    }

    public static List getTestGenPermissions() {
        ArrayList p = new ArrayList();
        PermissionsHelper.addCommonPermissions(p);
        PermissionsHelper.addPrivilegedPermissions(p);
        return p;
    }

    public static List getAgitationPermissions() {
        ArrayList p = new ArrayList();
        PermissionsHelper.addCommonPermissions(p);
        PermissionsHelper.addPrivilegedPermissions(p);
        PermissionsHelper.addMorePrivilegedPermissions(p);
        return p;
    }

    public static PermissionCollection getAgitationPermissionsCollection() {
        ArrayList<TempDirPermission> p = new ArrayList<TempDirPermission>();
        PermissionsHelper.addPrivilegedPermissions(p);
        PermissionsHelper.addMorePrivilegedPermissions(p);
        PermissionsHelper.addBasicCommonPermissions(p);
        p.add(new TempDirPermission("${java.io.tmpdir}", "read,write,delete"));
        Permissions collection = new Permissions();
        Iterator i = p.iterator();
        while (i.hasNext()) {
            collection.add((Permission)i.next());
        }
        collection.setReadOnly();
        return collection;
    }

    public static Permissions getAllPermissions() {
        Permissions p = new Permissions();
        p.add(new AllPermission());
        return p;
    }
}

