/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.security;

import com.agitar.lib.NoObfuscation;
import java.net.SocketPermission;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class AgSocketPermission
extends BasicPermission
implements NoObfuscation {
    private SocketPermission socketPermission = null;
    private String actions = null;

    public AgSocketPermission(String name, String actions) {
        super(name, actions);
        this.actions = actions;
    }

    public AgSocketPermission(SocketPermission socketPerm) {
        super(socketPerm.getName(), socketPerm.getActions());
        this.socketPermission = socketPerm;
    }

    public boolean implies(Permission p) {
        if (p instanceof AgSocketPermission) {
            if (this.socketPermission == null) {
                return p.getName().equals(this.getName()) || p.getName().startsWith(this.getName() + ":") && p.getActions().equals(this.actions);
            }
            return this.socketPermission.implies(((AgSocketPermission)p).socketPermission);
        }
        return true;
    }

    public String getActions() {
        if (this.socketPermission != null) {
            return this.socketPermission.getActions();
        }
        return this.actions;
    }

    public PermissionCollection newPermissionCollection() {
        return new AgSocketPermissionCollection();
    }

    public static class AgSocketPermissionCollection
    extends PermissionCollection {
        private Set permissionsSet = new HashSet();

        public void add(Permission permission) {
            this.permissionsSet.add(permission);
        }

        public Enumeration elements() {
            return Collections.enumeration(this.permissionsSet);
        }

        public boolean implies(Permission permission) {
            Iterator i = this.permissionsSet.iterator();
            while (i.hasNext()) {
                if (!((Permission)i.next()).implies(permission)) continue;
                return true;
            }
            return false;
        }
    }
}

