/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.security;

import com.agitar.common.diagnostics.DiagnosticResources;
import com.agitar.common.diagnostics.Diagnostics;
import com.agitar.common.logging.AgitarLevel;
import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.types.ClassName;
import com.agitar.common.types.MethodSignature;
import com.agitar.common.util.AgitarProperties;
import com.agitar.common.util.StringEscape;
import com.agitar.common.util.TimeoutController;
import com.agitar.common.util.UserTimer;
import com.agitar.lib.NoObfuscation;
import com.agitar.security.AgFilePermission;
import com.agitar.security.AgPermissionCollection;
import com.agitar.security.AgitarSecurityManager;
import com.agitar.security.MaybeUserThread;
import com.agitar.security.PermissionsHelper;
import com.agitar.security.SafeThread;
import com.agitar.security.SecurityOverride;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class AgPolicy
extends Policy
implements NoObfuscation {
    public static final CodeSource USER_CODE;
    private static final Object AGITATION_SECURITY_POLICY;
    private static final Object JUNIT_FACTORY_SECURITY_POLICY;
    private static final Object JUNIT_SECURITY_POLICY;
    private static final Object TESTGEN_SECURITY_POLICY;
    private AgPermissionCollection currentPermissions = null;
    public final Object type;
    private final Policy policy;
    private List readPermissions = new ArrayList();
    private static boolean isWasherEnabled;
    private static boolean isTestCaseEnabled;
    private static final Set reportedViolations;
    private static boolean isInstalled;
    private static SecurityOverride override;
    private static ThreadLocal privilegedFlag;

    private AgPolicy(Object t) {
        this.type = AgitarProperties.LOCKDOWN ? JUNIT_FACTORY_SECURITY_POLICY : t;
        Policy p = (Policy)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Policy.getPolicy();
            }
        });
        while (p instanceof AgPolicy) {
            p = ((AgPolicy)p).policy;
        }
        this.policy = p;
        if (this.type == JUNIT_FACTORY_SECURITY_POLICY) {
            this.getJUnitFactoryPermissions();
        } else if (this.type == AGITATION_SECURITY_POLICY) {
            this.getAgitationPermissions();
        } else if (this.type == JUNIT_SECURITY_POLICY) {
            this.getJUnitPermissions();
        } else if (this.type == TESTGEN_SECURITY_POLICY) {
            this.getTestGenPermissions();
        }
        this.refresh();
    }

    public static AgPolicy getAgitarOneSecurityPolicy() {
        return new AgPolicy(AGITATION_SECURITY_POLICY);
    }

    public static AgPolicy getJUnitFactorySecurityPolicy() {
        return new AgPolicy(JUNIT_FACTORY_SECURITY_POLICY);
    }

    public static AgPolicy getJUnitSecurityPolicy() {
        return new AgPolicy(JUNIT_SECURITY_POLICY);
    }

    public static AgPolicy getTestGenSecurityPolicy() {
        return new AgPolicy(TESTGEN_SECURITY_POLICY);
    }

    private static void addReadPermissions(PermissionCollection permissions, String path) {
        permissions.add(new AgFilePermission(path, "read"));
        permissions.add(new AgFilePermission(path + "/-", "read"));
    }

    private PermissionCollection getAgitationPermissions() {
        if (this.currentPermissions != null) {
            return this.currentPermissions;
        }
        this.currentPermissions = new AgPermissionCollection();
        this.currentPermissions.add(PermissionsHelper.getAgitationPermissions());
        this.currentPermissions.add(this.readPermissions);
        return this.currentPermissions;
    }

    private PermissionCollection getJUnitFactoryPermissions() {
        if (this.currentPermissions != null) {
            return this.currentPermissions;
        }
        this.currentPermissions = new AgPermissionCollection();
        this.currentPermissions.add(PermissionsHelper.getJUnitFactoryPermissions());
        this.currentPermissions.add(this.readPermissions);
        return this.currentPermissions;
    }

    private PermissionCollection getJUnitPermissions() {
        if (this.currentPermissions != null) {
            return this.currentPermissions;
        }
        this.currentPermissions = new AgPermissionCollection();
        this.currentPermissions.add(PermissionsHelper.getTestRunnerPermissions());
        this.currentPermissions.add(this.readPermissions);
        return this.currentPermissions;
    }

    private PermissionCollection getTestGenPermissions() {
        if (this.currentPermissions != null) {
            return this.currentPermissions;
        }
        this.currentPermissions = new AgPermissionCollection();
        this.currentPermissions.add(PermissionsHelper.getTestGenPermissions());
        this.currentPermissions.add(this.readPermissions);
        return this.currentPermissions;
    }

    public void addReadPermissionsForClasspath(String classpath) {
        String[] p = classpath.split(File.pathSeparator);
        for (int i = 0; i < p.length; ++i) {
            AgPolicy.addReadPermissions(this.currentPermissions, p[i]);
        }
    }

    public void addReadPermissionsForPath(String path) {
        AgPolicy.addReadPermissions(this.currentPermissions, path);
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        if (codeSource == USER_CODE) {
            return this.getPermissions();
        }
        return PermissionsHelper.getAllPermissions();
    }

    public PermissionCollection getCurrentPermissions(CodeSource codesource) {
        Thread thread = Thread.currentThread();
        if (AgPolicy.inPrivilegedBlock() || thread instanceof SafeThread || thread instanceof MaybeUserThread && !MaybeUserThread.isInUser(thread)) {
            return PermissionsHelper.getAllPermissions();
        }
        if (thread instanceof MaybeUserThread && MaybeUserThread.isInUser(thread) || codesource == USER_CODE) {
            return this.getPermissions();
        }
        return PermissionsHelper.getAllPermissions();
    }

    public PermissionCollection getPermissions(ProtectionDomain pd) {
        return this.getPermissions(pd.getCodeSource());
    }

    public Policy getPreviousPolicy() {
        return this.policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(ProtectionDomain domain, final Permission permission) {
        if (AgPolicy.inPrivilegedBlock()) {
            return true;
        }
        int stopCode = TimeoutController.stopTime("AgPolicy.implies");
        try {
            UserTimer.start(permission.getClass().getName());
            boolean implies = false;
            PermissionCollection defaultPermissions = this.getCurrentPermissions(domain.getCodeSource());
            implies = override != null ? override.checkPermission(defaultPermissions, permission) : defaultPermissions.implies(permission);
            if (!implies) {
                Boolean denied = (Boolean)AgPolicy.doPrivilegedAction(new PrivilegedAction(){

                    public Object run() {
                        return AgPolicy.this.reportDenial(permission);
                    }
                });
                boolean bl = denied == false;
                return bl;
            }
            boolean bl = implies;
            return bl;
        }
        finally {
            UserTimer.stop(permission.getClass().getName());
            TimeoutController.resumeTime(stopCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reportDenial(Permission permission) {
        Exception securityTrace = new Exception("security trace");
        StackTraceElement[] trace = securityTrace.getStackTrace();
        if (!AgitarProperties.LOCKDOWN) {
            for (int i = 0; i < trace.length; ++i) {
                if (!"<clinit>".equals(trace[i].getMethodName())) continue;
                return false;
            }
        }
        MethodSignature violator = new MethodSignature("Unknown.unknown()");
        String violation = permission.toString();
        int lineNumber = 0;
        if (trace != null && trace.length > 0) {
            StackTraceElement element = trace[0];
            for (int i = 1; i < trace.length && !AgPolicy.isUser(element.getClassName()); ++i) {
                element = trace[i];
            }
            if (element.getClassName() != null && element.getMethodName() != null) {
                violator = new MethodSignature(element.getClassName() + '.' + element.getMethodName() + "()");
                if (element.getLineNumber() > 0) {
                    lineNumber = element.getLineNumber();
                }
                violation = violator.toString() + ' ' + permission;
            }
        }
        Set set = reportedViolations;
        synchronized (set) {
            if (!reportedViolations.contains(violation)) {
                reportedViolations.add(violation);
                if (AgPolicy.isUser(violator.getClassName().toString())) {
                    String permName = permission.getActions() == null || permission.getActions().length() == 0 ? StringEscape.encodeUndefinedUnicodeChar(permission.getName()) : permission.getActions() + ' ' + StringEscape.encodeUndefinedUnicodeChar(permission.getName());
                    String message = DiagnosticResources.getResource("problem.security.violation.details", new Object[]{ClassName.get(permission.getClass()).getSimpleName(), permName, violator.getClassName(), violator.getName(), new Integer(lineNumber)});
                    Diagnostics.getKey("security.violations").add(violator, message);
                    AgitarLogger.getUserLogger().info("Permission denied: " + message);
                } else {
                    AgitarLogger.getDiagnosticLogger("AgPolicy").log(AgitarLevel.FINE, "internal security violation", securityTrace);
                }
            }
        }
        return true;
    }

    private static boolean isUser(String className) {
        return !className.startsWith("java") && !className.startsWith("sun") && !className.startsWith("com.agitar.");
    }

    public void refresh() {
        this.policy.refresh();
    }

    public void setAuxiliaryPermissions(PermissionCollection p) {
        Enumeration<Permission> e = p.elements();
        while (e.hasMoreElements()) {
            this.addAuxiliaryPermission(e.nextElement());
        }
    }

    public void addAuxiliaryPermission(Permission perm) {
        if (AgitarProperties.LOCKDOWN || this.type.equals(JUNIT_FACTORY_SECURITY_POLICY)) {
            AgitarLogger.getDiagnosticLogger("AgPolicy").warning("Cannot add permission: " + perm + " to JUnit Factory or in lockdown mode");
            return;
        }
        if (this.currentPermissions == null) {
            this.getPermissions();
        }
        this.currentPermissions.add(perm);
    }

    private PermissionCollection getPermissions() {
        if (this.type.equals(TESTGEN_SECURITY_POLICY)) {
            return this.getTestGenPermissions();
        }
        if (this.type.equals(AGITATION_SECURITY_POLICY)) {
            return this.getAgitationPermissions();
        }
        if (this.type.equals(JUNIT_SECURITY_POLICY)) {
            return this.getJUnitPermissions();
        }
        if (this.type.equals(JUNIT_FACTORY_SECURITY_POLICY)) {
            return this.getJUnitFactoryPermissions();
        }
        throw new RuntimeException("Incorrect policy type was requested.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doPrivilegedAction(PrivilegedAction action) {
        boolean previousInPrivileged = AgPolicy.isPrivilegedFlagSet();
        try {
            AgPolicy.setPrivilegedFlag(true);
            Object t = action.run();
            return t;
        }
        finally {
            AgPolicy.setPrivilegedFlag(previousInPrivileged);
        }
    }

    public static Object doPrivilegedAction(PrivilegedExceptionAction action) throws Exception {
        boolean previousInPrivileged = AgPolicy.isPrivilegedFlagSet();
        try {
            AgPolicy.setPrivilegedFlag(true);
            Object t = action.run();
            return t;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            AgPolicy.setPrivilegedFlag(previousInPrivileged);
        }
    }

    public static void setEnableWasherPolicy(boolean isEnabled) {
        isWasherEnabled = isEnabled;
        if (isEnabled && System.getSecurityManager() == null) {
            System.setSecurityManager(new AgitarSecurityManager());
        }
    }

    public static void setEnableTestCasePolicy(boolean isEnabled) {
        isTestCaseEnabled = isEnabled;
        if (isEnabled && System.getSecurityManager() == null) {
            System.setSecurityManager(new AgitarSecurityManager());
        }
    }

    public static boolean inPrivilegedBlock() {
        return !isWasherEnabled && !isTestCaseEnabled || AgPolicy.isPrivilegedFlagSet();
    }

    public static void installPolicy(final AgPolicy agPolicy) {
        AgitarLogger.getDiagnosticLogger("AgPolicy").info("Installing policy " + agPolicy.type);
        AgPolicy.doPrivilegedAction(new PrivilegedAction(){

            public Object run() {
                Policy.setPolicy(agPolicy);
                isInstalled = true;
                return null;
            }
        });
    }

    public static void registerSecurityOverride(SecurityOverride override) {
        AgPolicy.override = override;
    }

    public static boolean isInstalled() {
        return isInstalled;
    }

    private static boolean isPrivilegedFlagSet() {
        return ((PrivilegedFlag)AgPolicy.privilegedFlag.get()).inPrivilegedBlock;
    }

    private static void setPrivilegedFlag(boolean inPrivilegedBlock) {
        ((PrivilegedFlag)AgPolicy.privilegedFlag.get()).inPrivilegedBlock = inPrivilegedBlock;
    }

    static {
        reportedViolations = new HashSet();
        isInstalled = false;
        override = null;
        AGITATION_SECURITY_POLICY = "AGITATION_SECURITY_POLICY";
        JUNIT_FACTORY_SECURITY_POLICY = "JUNIT_FACTORY_SECURITY_POLICY";
        JUNIT_SECURITY_POLICY = "JUNIT_SECURITY_POLICY";
        TESTGEN_SECURITY_POLICY = "TESTGEN_SECURITY_POLICY";
        try {
            USER_CODE = new CodeSource(new URL("file://user_code"), (Certificate[])null);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        privilegedFlag = new ThreadLocal(){

            protected Object initialValue() {
                return new PrivilegedFlag();
            }
        };
    }

    static class PrivilegedFlag {
        public boolean inPrivilegedBlock = false;

        PrivilegedFlag() {
        }
    }
}

