/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.security;

import com.agitar.security.AgFilePermission;
import com.agitar.security.AgSocketPermission;
import java.io.FilePermission;
import java.net.SocketPermission;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class AgPermissionCollection
extends PermissionCollection {
    private Map permsMap = new HashMap();
    private boolean containsAll;

    public void add(List permissions) {
        Iterator i = permissions.iterator();
        while (i.hasNext()) {
            this.add((Permission)i.next());
        }
    }

    public void add(Permission permission) {
        permission = AgPermissionCollection.substitute(permission);
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        if (permission instanceof AllPermission) {
            this.containsAll = true;
        }
        PermissionCollection pc = this.getPermissionCollection(permission, true);
        pc.add(permission);
    }

    public boolean implies(Permission permission) {
        permission = AgPermissionCollection.substitute(permission);
        PermissionCollection pc = this.getPermissionCollection(permission, false);
        return this.containsAll || pc != null && pc.implies(permission);
    }

    private static Permission substitute(Permission permission) {
        if (permission instanceof FilePermission) {
            return new AgFilePermission(permission.getName(), permission.getActions());
        }
        if (permission instanceof SocketPermission) {
            return new AgSocketPermission((SocketPermission)permission);
        }
        return permission;
    }

    public Enumeration elements() {
        return new PermissionsEnumerator(this.permsMap.values().iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionCollection getPermissionCollection(Permission p, boolean createEmpty) {
        Class<?> c = p.getClass();
        Map map = this.permsMap;
        synchronized (map) {
            PermissionCollection pc = (PermissionCollection)this.permsMap.get(c);
            if (pc == null && createEmpty) {
                pc = p.newPermissionCollection();
                if (pc == null) {
                    pc = new PermissionsSet();
                }
                this.permsMap.put(c, pc);
            }
            return pc;
        }
    }

    private class PermissionsEnumerator
    implements Enumeration {
        private Iterator perms;
        private Enumeration permset;

        PermissionsEnumerator(Iterator mainIterator) {
            this.perms = mainIterator;
            this.permset = this.getNextEnumWithMore();
        }

        public boolean hasMoreElements() {
            if (this.permset == null) {
                return false;
            }
            if (this.permset.hasMoreElements()) {
                return true;
            }
            this.permset = this.getNextEnumWithMore();
            return this.permset != null;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                return this.permset.nextElement();
            }
            throw new NoSuchElementException("PermissionsEnumerator");
        }

        private Enumeration getNextEnumWithMore() {
            while (this.perms.hasNext()) {
                PermissionCollection pc = (PermissionCollection)this.perms.next();
                Enumeration<Permission> next = pc.elements();
                if (!next.hasMoreElements()) continue;
                return next;
            }
            return null;
        }
    }

    private class PermissionsSet
    extends PermissionCollection {
        private final Set perms = new HashSet();

        private PermissionsSet() {
        }

        public void add(Permission permission) {
            this.perms.add(permission);
        }

        public boolean implies(Permission permission) {
            if (this.perms.contains(permission)) {
                return true;
            }
            Iterator iterator = this.perms.iterator();
            while (iterator.hasNext()) {
                Permission p = (Permission)iterator.next();
                if (!p.implies(permission)) continue;
                return true;
            }
            return false;
        }

        public Enumeration elements() {
            return Collections.enumeration(this.perms);
        }
    }
}

