/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.security;

import com.agitar.security.AgFilePermission;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class AgFilePermissionCollection
extends PermissionCollection
implements Serializable {
    private Set perms = new HashSet();

    public void add(Permission permission) {
        if (!(permission instanceof AgFilePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        this.perms.add(permission);
    }

    public boolean implies(Permission permission) {
        if (permission instanceof AgFilePermission) {
            AgFilePermission afp = (AgFilePermission)permission;
            int desired = afp.getMask();
            int effective = 0;
            int needed = desired;
            int len = this.perms.size();
            Iterator i = this.perms.iterator();
            while (i.hasNext()) {
                AgFilePermission x = (AgFilePermission)i.next();
                if ((needed & x.getMask()) == 0 || !x.impliesIgnoreMask(afp)) continue;
                if (((effective |= x.getMask()) & desired) == desired) {
                    return true;
                }
                needed = desired ^ effective;
            }
            return false;
        }
        return false;
    }

    public Enumeration elements() {
        return Collections.enumeration(this.perms);
    }
}

