/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.security;

import com.agitar.common.util.AgitarProperties;
import com.agitar.common.util.StringUtility;
import com.agitar.security.AgFilePermissionCollection;
import com.agitar.security.AgPolicy;
import com.agitar.security.Wildcard;
import java.io.File;
import java.io.FilePermission;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.ArrayList;

public class AgFilePermission
extends BasicPermission {
    private static final int NONE = 0;
    private static final int EXECUTE = 1;
    private static final int WRITE = 2;
    private static final int READ = 4;
    private static final int DELETE = 8;
    private static final int ALL = 15;
    private transient int mask;
    private String actions;
    private Wildcard wildcard;
    public static final int MAX_PATH = 255;
    public static final int MAX_NAME = 255;

    public AgFilePermission(String path, final String actions) {
        super(path == null || path.length() == 0 ? "." : path);
        AgPolicy.doPrivilegedAction(new PrivilegedAction(){

            public Object run() {
                AgFilePermission.this.mask = AgFilePermission.getMask(actions);
                String cpath = AgFilePermission.this.getName().replace('\\', '/');
                if ((AgFilePermission.this.mask & 0xF) != AgFilePermission.this.mask || AgFilePermission.this.mask == 0) {
                    throw new IllegalArgumentException("invalid actions mask");
                }
                if (cpath == null) {
                    throw new NullPointerException("name can't be null");
                }
                AgFilePermission.this.wildcard = Wildcard.getWildcard(cpath);
                return null;
            }
        });
    }

    public boolean implies(Permission p) {
        if (p instanceof AgFilePermission) {
            AgFilePermission that = (AgFilePermission)p;
            return (this.mask & that.mask) == that.mask && this.impliesIgnoreMask(that);
        }
        if (p instanceof FilePermission) {
            AgFilePermission that = new AgFilePermission(p.getName(), p.getActions());
            return (this.mask & that.mask) == that.mask && this.impliesIgnoreMask(that);
        }
        return false;
    }

    boolean impliesIgnoreMask(AgFilePermission that) {
        if (AgitarProperties.isWindows() && that.getMask() != 4 && !AgFilePermission.acceptableWindowsFilename(that.wildcard.toString())) {
            return false;
        }
        if (AgitarProperties.isWindows() && AgFilePermission.isFloppyDrive(that.wildcard.toString())) {
            return false;
        }
        return this.wildcard.match(that.wildcard.toString());
    }

    public static boolean isFloppyDrive(String filename) {
        char ch;
        return filename.charAt(1) == ':' && ((ch = filename.charAt(0)) == 'A' || ch == 'B' || ch == 'a' || ch == 'b');
    }

    public static boolean acceptableWindowsFilename(String filename) {
        File file = new File(filename);
        if ("<<ALL FILES>>".equals(filename)) {
            return true;
        }
        if (filename.length() == 0 || filename.length() > 255 || file.getName().length() > 255) {
            return false;
        }
        if (filename.startsWith(" ") || filename.endsWith(" ")) {
            return false;
        }
        return AgFilePermission.checkCharacters(filename);
    }

    private static boolean checkCharacters(String filename) {
        char[] c = filename.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            char ch = c[i];
            switch (ch) {
                case '\u0000': 
                case '\"': 
                case '*': 
                case '<': 
                case '>': 
                case '?': 
                case '|': {
                    return false;
                }
                case ':': {
                    if (i == 1 && !AgFilePermission.isFloppyDrive(c[0])) break;
                    return false;
                }
            }
            if (!Character.isISOControl(ch)) continue;
            return false;
        }
        return true;
    }

    private static boolean isFloppyDrive(char drive) {
        return drive == 'a' || drive == 'A' || drive == 'b' || drive == 'B';
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AgFilePermission) {
            AgFilePermission that = (AgFilePermission)obj;
            return this.mask == that.mask && this.wildcard.equals(that.wildcard);
        }
        return false;
    }

    public int hashCode() {
        return this.wildcard.hashCode();
    }

    private static int getMask(String actionList) {
        int mask = 0;
        if (actionList != null) {
            String[] actions = StringUtility.split(actionList.toLowerCase(), ',');
            for (int i = 0; i < actions.length; ++i) {
                String action = actions[i].trim();
                if ("read".equals(action)) {
                    mask |= 4;
                    continue;
                }
                if ("write".equals(action)) {
                    mask |= 2;
                    continue;
                }
                if ("execute".equals(action)) {
                    mask |= 1;
                    continue;
                }
                if (!"delete".equals(action)) continue;
                mask |= 8;
            }
        }
        return mask;
    }

    int getMask() {
        return this.mask;
    }

    public String getActions() {
        if (this.actions == null) {
            this.actions = AgFilePermission.getActions(this.mask);
        }
        return this.actions;
    }

    private static String getActions(int mask) {
        ArrayList<String> actions = new ArrayList<String>();
        if ((mask & 4) == 4) {
            actions.add("read");
        }
        if ((mask & 2) == 2) {
            actions.add("write");
        }
        if ((mask & 1) == 1) {
            actions.add("execute");
        }
        if ((mask & 8) == 8) {
            actions.add("delete");
        }
        return StringUtility.join(StringUtility.strings(actions), ',');
    }

    public PermissionCollection newPermissionCollection() {
        return new AgFilePermissionCollection();
    }
}

