/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.icon;

import com.agitar.common.util.IOUtility;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class IconUtility {
    public static final String UNSPECIFIED_OUTCOME = "unspecified.gif";
    public static final String EXPECTED_OUTCOME = "expected.gif";
    public static final String UNEXPECTED_OUTCOME = "unexpected.gif";
    public static final String ADD = "Add16.gif";
    public static final String EDIT = "Edit16.gif";
    public static final String REMOVE = "Delete16.gif";
    public static final String ADD_TEST_CLASS = "addTestClass.gif";
    public static final String DUPLICATE_OUTCOME = "copy.gif";
    public static final String INVERT_OUTCOME = "invert.gif";
    public static final String BLANK_DOT = "blankdot.gif";
    public static final String GREEN_DOT = "greendot.gif";
    public static final String RED_DOT = "reddot.gif";
    public static final String YELLOW_DOT = "yellowdot.gif";
    public static final String UNKNOWN_DOT = "Unknown.gif";
    public static final String HELP = "help.gif";
    public static final String OUTPUT = "output.gif";
    public static final String METHOD_TREE_NODE = "method.gif";
    public static final String CLASS_TREE_NODE = "class.gif";
    public static final String GENERAL_PROJECT_PROPERTIES = "projectProperties.gif";
    public static final String ADVANCED_PROJECT_PROPERTIES = "advancedProperties.gif";
    public static final String PACKAGE_TREE_NODE_CLOSED = "pkg_closed.gif";
    public static final String PACKAGE_TREE_NODE_OPEN = "pkg_open.gif";
    public static final String MINI_WARNING = "miniwarning.gif";
    public static final String MINI_GREEN_RESULT = "minigreencheck.gif";
    public static final String MINI_RED_RESULT = "miniredx.gif";
    public static final String MINI_BLANK_RESULT = "miniblank.gif";
    public static final String MINI_UNKNOWN_RESULT = "minidash.gif";
    public static final String AGITATOR_SMALL = "agitator_16x16.gif";
    public static final String AGITATOR_LARGE = "agitator_32x32.gif";
    public static final String SNAPSHOT = "camera.gif";
    public static final String SUMMARY = "summary2.gif";
    private static HashMap iconCache = new HashMap();
    private static final String DISABLED_PREFIX = "d_";

    private IconUtility() {
    }

    public static String getDisabledImageName(String imgName) {
        return DISABLED_PREFIX + imgName;
    }

    public static Icon _about() {
        return IconUtility.getIcon("About16.gif");
    }

    public static Icon _invert() {
        return IconUtility.getIcon(INVERT_OUTCOME);
    }

    public static Icon _interface() {
        return IconUtility.getIcon("interface.gif");
    }

    public static Icon _env() {
        return IconUtility.getIcon("env.gif");
    }

    public static Icon _addTestClass() {
        return IconUtility.getIcon(ADD_TEST_CLASS);
    }

    public static Icon _barberpole() {
        return IconUtility.getIcon("barberpole.gif");
    }

    public static Icon _agitate() {
        return IconUtility.getIcon("agitate.gif");
    }

    public static Icon _agitateMenu() {
        return IconUtility.getIcon("agitate_with_menu.gif");
    }

    public static Icon _testClass() {
        return IconUtility.getIcon("test_class.gif");
    }

    public static Icon _testClassAssigned() {
        return IconUtility.getIcon("test_class_assigned.gif");
    }

    public static Icon _packageClosed() {
        return IconUtility.getIcon(PACKAGE_TREE_NODE_CLOSED);
    }

    public static Icon _packageOpen() {
        return IconUtility.getIcon(PACKAGE_TREE_NODE_OPEN);
    }

    public static Icon _testInterface() {
        return IconUtility.getIcon("test_interface.gif");
    }

    public static Icon _testMethod() {
        return IconUtility.getIcon("test_method.gif");
    }

    public static Icon _initMethod() {
        return IconUtility.getIcon("init_method.gif");
    }

    public static Icon _testMethodAssigned() {
        return IconUtility.getIcon("test_method_assigned.gif");
    }

    public static Icon _expandAll() {
        return IconUtility.getIcon("expandAll.gif");
    }

    public static Icon _collapseAll() {
        return IconUtility.getIcon("collapseAll.gif");
    }

    public static Icon _factory() {
        return IconUtility.getIcon("factory.gif");
    }

    public static Icon _fac_add() {
        return IconUtility.getIcon("fac_add.gif");
    }

    public static Icon _fac_edit() {
        return IconUtility.getIcon("fac_edit.gif");
    }

    public static Icon _fac_remove() {
        return IconUtility.getIcon("fac_remove.gif");
    }

    public static Icon _fac_test() {
        return IconUtility.getIcon("fac_test.gif");
    }

    public static Icon _fac_use() {
        return IconUtility.getIcon("fac_use.gif");
    }

    public static Icon _invalid_fac_use() {
        return IconUtility.getIcon("fac_use_invalid.gif");
    }

    public static Icon _red() {
        return IconUtility.getIcon(RED_DOT);
    }

    public static Icon _export() {
        return IconUtility.getIcon("export.gif");
    }

    public static Icon _check() {
        return IconUtility.getIcon("check.gif");
    }

    public static Icon _yellow() {
        return IconUtility.getIcon(YELLOW_DOT);
    }

    public static Icon _green() {
        return IconUtility.getIcon(GREEN_DOT);
    }

    public static Icon _miniGreenResult() {
        return IconUtility.getIcon(MINI_GREEN_RESULT);
    }

    public static ImageIcon _miniWarningResult() {
        return IconUtility.getIcon(MINI_WARNING);
    }

    public static Icon _miniRedResult() {
        return IconUtility.getIcon(MINI_RED_RESULT);
    }

    public static Icon _miniUnknownResult() {
        return IconUtility.getIcon(MINI_UNKNOWN_RESULT);
    }

    public static Icon _miniDot() {
        return IconUtility.getIcon("minidot.gif");
    }

    public static Icon _miniBlankResult() {
        return IconUtility.getIcon(MINI_BLANK_RESULT);
    }

    public static Icon _ledFlash() {
        return IconUtility.getIcon("ledFlash.gif");
    }

    public static Icon _ledOff() {
        return IconUtility.getIcon("ledOff.gif");
    }

    public static Icon _ledOn() {
        return IconUtility.getIcon("ledOn.gif");
    }

    public static Icon _redLed() {
        return IconUtility.getIcon("redLed.gif");
    }

    public static Icon _unknown() {
        return IconUtility.getIcon(UNKNOWN_DOT);
    }

    public static Icon _back() {
        return IconUtility.getIcon("back.gif");
    }

    public static Icon _forward() {
        return IconUtility.getIcon("forward.gif");
    }

    public static Icon _refresh() {
        return IconUtility.getIcon("refresh.gif");
    }

    public static Icon _open() {
        return IconUtility.getIcon("open.gif");
    }

    public static Icon _new() {
        return IconUtility.getIcon("new.gif");
    }

    public static Icon _findGhosts() {
        return IconUtility.getIcon("findGhosts.gif");
    }

    public static Icon _checkDependencies() {
        return IconUtility.getIcon("checkDependencies.gif");
    }

    public static Icon _properties() {
        return IconUtility.getIcon("properties.gif");
    }

    public static Icon _preferences() {
        return IconUtility.getIcon("preferences.gif");
    }

    public static Icon _zoom() {
        return IconUtility.getIcon("zoom.gif");
    }

    public static Icon _find() {
        return IconUtility.getIcon("find.gif");
    }

    public static Icon _findagain() {
        return IconUtility.getIcon("findagain.gif");
    }

    public static Icon _findmethod() {
        return IconUtility.getIcon("findmethod.gif");
    }

    public static Icon _findclass() {
        return IconUtility.getIcon("findclass.gif");
    }

    public static Icon _spacer() {
        return new SpacerIcon();
    }

    public static Icon _spacer(int w) {
        return new SpacerIcon(w);
    }

    public static Icon _dropDown() {
        return IconUtility.getIcon("dropdown.gif");
    }

    public static Icon _addItem() {
        return IconUtility.getIcon("addItem.gif");
    }

    public static Icon _removeItem() {
        return IconUtility.getIcon("removeItem.gif");
    }

    public static Icon _add() {
        return IconUtility.getIcon(ADD);
    }

    public static Icon _delete() {
        return IconUtility.getIcon(REMOVE);
    }

    public static Icon _edit() {
        return IconUtility.getIcon(EDIT);
    }

    public static Icon _plus() {
        return IconUtility.getIcon("plus.gif");
    }

    public static Icon _minus() {
        return IconUtility.getIcon("minus.gif");
    }

    public static Icon _addToFilter() {
        return IconUtility.getIcon("addToFilter.gif");
    }

    public static Icon _help() {
        return IconUtility.getIcon(HELP);
    }

    public static Icon _contextHelp() {
        return IconUtility.getIcon("contextHelp.gif");
    }

    public static Icon _hide() {
        return IconUtility.getIcon("hide.gif");
    }

    public static ImageIcon _agitatorSmall() {
        return IconUtility.getIcon(AGITATOR_SMALL);
    }

    public static Icon _agitatorLarge() {
        return IconUtility.getIcon(AGITATOR_LARGE);
    }

    public static Icon _expandDetails() {
        return IconUtility.getIcon("expand_details.gif");
    }

    public static Icon _security() {
        return IconUtility.getIcon("security.gif");
    }

    public static Icon _collapseDetails() {
        return IconUtility.getIcon("collapse_details.gif");
    }

    public static Icon _snapshots() {
        return IconUtility.getIcon(SNAPSHOT);
    }

    public static Icon _summary() {
        return IconUtility.getIcon("summary.gif");
    }

    public static Icon _source() {
        return IconUtility.getIcon("source.gif");
    }

    public static Icon _up() {
        return IconUtility.getIcon("up.gif");
    }

    public static Icon _down() {
        return IconUtility.getIcon("down.gif");
    }

    public static Icon _cut() {
        return IconUtility.getIcon("cut.gif");
    }

    public static Icon _duplicate() {
        return IconUtility.getIcon(DUPLICATE_OUTCOME);
    }

    public static Icon _copy() {
        return IconUtility.getIcon(DUPLICATE_OUTCOME);
    }

    public static Icon _class() {
        return IconUtility.getIcon(CLASS_TREE_NODE);
    }

    public static Icon _paste() {
        return IconUtility.getIcon("paste.gif");
    }

    public static Icon _print() {
        return IconUtility.getIcon("Print16.gif");
    }

    public static Icon _pageSetup() {
        return IconUtility.getIcon("PageSetup16.gif");
    }

    public static Icon _undo() {
        return IconUtility.getIcon("Undo16.gif");
    }

    public static Icon _redo() {
        return IconUtility.getIcon("Redo16.gif");
    }

    public static Icon _output() {
        return IconUtility.getIcon(OUTPUT);
    }

    public static Icon _save() {
        return IconUtility.getIcon("save.gif");
    }

    public static Icon _managementConsole() {
        return IconUtility.getIcon("managementConsole.gif");
    }

    public static Icon _managementConsoleAnimation() {
        return IconUtility.getIcon("managementConsoleAnimation.gif");
    }

    public static Icon _generalProjectProperties() {
        return IconUtility.getIcon(GENERAL_PROJECT_PROPERTIES);
    }

    public static Icon _advancedProjectProperies() {
        return IconUtility.getIcon(ADVANCED_PROJECT_PROPERTIES);
    }

    public static Icon _j2eeProjectProperties() {
        return IconUtility.getIcon("J2EEProjectProperties.gif");
    }

    public static Icon _editExternal() {
        return IconUtility.getIcon("editExternal.gif");
    }

    public static Icon _washingMachine() {
        return IconUtility.getIcon("washing-machine.gif");
    }

    public static Icon _setup() {
        return IconUtility.getIcon("setup.gif");
    }

    public static Icon _inform() {
        return IconUtility.getIcon("Inform.gif");
    }

    public static Icon _method() {
        return IconUtility.getIcon(METHOD_TREE_NODE);
    }

    public static Icon _unexpected() {
        return IconUtility.getIcon(UNEXPECTED_OUTCOME);
    }

    public static Icon _expected() {
        return IconUtility.getIcon(EXPECTED_OUTCOME);
    }

    public static Icon _unspecified() {
        return IconUtility.getIcon(UNSPECIFIED_OUTCOME);
    }

    public static Icon _dashboardBanner() {
        return IconUtility.getIcon("db_header.gif");
    }

    public static Icon _dashboardBannerBg() {
        return IconUtility.getIcon("db_headerbg.gif");
    }

    protected static ImageIcon createSelectedIcon(ImageIcon i) {
        GrayFilter filter = new GrayFilter(true, 10);
        FilteredImageSource prod = new FilteredImageSource(i.getImage().getSource(), filter);
        Image grayImage = Toolkit.getDefaultToolkit().createImage(prod);
        return new ImageIcon(grayImage);
    }

    public static void copyImage(String imageName, String directoryPathName) throws IOException {
        InputStream inStream = IconUtility.class.getResourceAsStream(imageName);
        if (inStream == null) {
            throw new FileNotFoundException(imageName);
        }
        if (!new File(directoryPathName).exists()) {
            throw new FileNotFoundException(directoryPathName);
        }
        FileOutputStream outStream = new FileOutputStream(new File(directoryPathName + File.separator + imageName));
        IOUtility.copy(inStream, outStream);
    }

    public static ImageIcon getIcon(String name) {
        ImageIcon icon = (ImageIcon)iconCache.get(name);
        if (icon != null) {
            return icon;
        }
        icon = new ImageIcon(IconUtility.class.getResource(name));
        iconCache.put(name, icon);
        return icon;
    }

    private static class SpacerIcon
    implements Icon {
        private static final int WIDTH = 23;
        private static final int HEIGHT = 16;
        private int width = 23;

        public SpacerIcon() {
        }

        public SpacerIcon(int w) {
            this.width = w;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return 16;
        }
    }
}

