/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.util.IOUtility;
import com.agitar.common.util.StringUtility;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class ZipOutput {
    private final ZipOutputStream zos;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void zipAll(File output, File directory, int level, boolean useAbsoluePath) throws IOException {
        if (!$assertionsDisabled && output == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && directory == null) {
            throw new AssertionError();
        }
        ZipOutput.zipAll(new ZipOutput(new FileOutputStream(output), level), directory, null, useAbsoluePath);
    }

    public static void zipAll(File output, File directory, int level, FileFilter filter, boolean useAbsoluePath) throws IOException {
        if (!$assertionsDisabled && output == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && directory == null) {
            throw new AssertionError();
        }
        ZipOutput.zipAll(new ZipOutput(new FileOutputStream(output), level), directory, filter, useAbsoluePath);
    }

    public static void zipAll(File output, File directory, boolean useAbsoluePath) throws IOException {
        ZipOutput.zipAll(output, directory, null, useAbsoluePath);
    }

    public static void zipAll(File output, File directory, FileFilter filter, boolean useAbsoluePath) throws IOException {
        if (!$assertionsDisabled && output == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && directory == null) {
            throw new AssertionError();
        }
        ZipOutput.zipAll(new ZipOutput(new FileOutputStream(output)), directory, filter, useAbsoluePath);
    }

    private static void zipAll(ZipOutput zip, File directory, FileFilter filter, boolean useAbsoluePath) throws IOException {
        zip.zipAll(directory, ZipOutput.getRootDirectoryPath(useAbsoluePath, directory), filter);
        zip.close();
    }

    private static String getRootDirectoryPath(boolean useAbsoluePath, File directory) {
        if (useAbsoluePath) {
            return null;
        }
        String path = IOUtility.getCanonicalPath(directory).replace('\\', '/');
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    public void zipAll(File directory, String rootDirectoryPath) throws IOException {
        this.zipAll(directory, rootDirectoryPath, null);
    }

    public void zipAll(File directory, String rootDirectoryPath, FileFilter filter) throws IOException {
        if (!(directory.exists() && directory.isDirectory() && directory.canRead())) {
            throw new IOException("can't read dircetory: " + directory.getAbsolutePath());
        }
        if (!IOUtility.isParentPath(new File(rootDirectoryPath), directory)) {
            throw new IOException(directory.getAbsolutePath() + " is not a subdirectory of " + rootDirectoryPath);
        }
        File[] list = filter == null ? directory.listFiles() : directory.listFiles(filter);
        for (int i = 0; i < list.length; ++i) {
            File file = list[i];
            if (!file.exists()) continue;
            if (file.isFile()) {
                this.add(file, rootDirectoryPath);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.zipAll(file, rootDirectoryPath, filter);
        }
    }

    public void add(File file, String rootDirectoryPath) throws IOException {
        String filePath = IOUtility.getCanonicalPath(file).replace('\\', '/');
        if (rootDirectoryPath != null) {
            filePath = filePath.substring(rootDirectoryPath.length());
        }
        this.add(filePath, file);
    }

    public ZipOutput(OutputStream out) {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        this.zos = new ZipOutputStream(out);
    }

    public ZipOutput(OutputStream out, int level) {
        this(out);
        this.zos.setLevel(level);
    }

    public void add(String entryName, File file) throws IOException {
        this.add(new ZipEntryUint(entryName, file));
    }

    public void add(String entryName, InputStream input) throws IOException {
        this.add(new ZipEntryUint(entryName, input));
    }

    public void add(ZipEntryUint zeu) throws IOException {
        InputStream is = zeu.getInputStream();
        if (is != null) {
            ZipEntry entry = new ZipEntry(zeu.name);
            if (zeu.time > 0L) {
                entry.setTime(zeu.time);
            }
            this.zos.putNextEntry(entry);
            IOUtility.copy(is, this.zos);
            is.close();
            this.zos.closeEntry();
        }
    }

    public void close() throws IOException {
        this.zos.close();
    }

    static {
        $assertionsDisabled = !ZipOutput.class.desiredAssertionStatus();
    }

    public static class ZipEntryUint {
        final String name;
        long time = -1L;
        private final File inputFile;
        private final InputStream stream;
        static final /* synthetic */ boolean $assertionsDisabled;

        public ZipEntryUint(String n, File file) {
            if (!$assertionsDisabled && StringUtility.nullOrEmpty(n)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && file == null) {
                throw new AssertionError();
            }
            this.name = n.replace('\\', '/');
            if (file.exists() && file.isFile() && file.canRead()) {
                this.inputFile = file;
                this.time = file.lastModified();
            } else {
                this.inputFile = null;
            }
            this.stream = null;
        }

        public ZipEntryUint(String n, InputStream is) {
            if (!$assertionsDisabled && StringUtility.nullOrEmpty(n)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && is == null) {
                throw new AssertionError();
            }
            this.name = n;
            this.inputFile = null;
            this.stream = is;
        }

        InputStream getInputStream() {
            if (this.stream != null) {
                return this.stream;
            }
            if (this.inputFile != null) {
                try {
                    return new BufferedInputStream(new FileInputStream(this.inputFile));
                }
                catch (FileNotFoundException e) {
                    return null;
                }
            }
            return null;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ZipEntryUint)) {
                return false;
            }
            return this.name.equals(((ZipEntryUint)obj).name);
        }

        static {
            $assertionsDisabled = !(class$com$agitar$common$util$ZipOutput == null ? (class$com$agitar$common$util$ZipOutput = ZipOutput.class$("com.agitar.common.util.ZipOutput")) : class$com$agitar$common$util$ZipOutput).desiredAssertionStatus();
        }
    }
}

