/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.util.AgitarProperties;
import com.agitar.common.util.StringEscape;
import com.agitar.common.util.XMLUtility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class XmlWriter {
    private static final String XML_DECLARATION = "<?xml version=\"1.0\" ?>";
    private Writer out;
    private boolean empty;
    private boolean newLine;
    private int depth;
    private boolean fixEncodingBug;
    static final /* synthetic */ boolean $assertionsDisabled;

    public XmlWriter(Writer out) throws IOException {
        this(out, true);
    }

    public void setFixEncodingBug(boolean fix) {
        this.fixEncodingBug = fix;
    }

    public XmlWriter(Writer out, boolean includeXmlDeclaration) throws IOException {
        if (out == null) {
            throw new NullPointerException("null writer");
        }
        this.out = out;
        if (includeXmlDeclaration) {
            out.write(XML_DECLARATION);
            this.newLine = true;
        }
    }

    public XmlWriter(File file) throws IOException, UnsupportedEncodingException {
        this(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
    }

    public void startElement(String tag) throws IOException {
        this.closeElement();
        this.writeln();
        this.out.write(60);
        this.out.write(tag);
        this.empty = true;
        this.newLine = true;
        ++this.depth;
    }

    public void endElement(String tag) throws IOException {
        if (!$assertionsDisabled && this.depth <= 0) {
            throw new AssertionError();
        }
        --this.depth;
        if (this.empty) {
            this.out.write(47);
            this.out.write(62);
        } else {
            this.writeln();
            this.out.write(60);
            this.out.write(47);
            this.out.write(tag);
            this.out.write(62);
        }
        this.empty = false;
        this.newLine = true;
    }

    public void writeAttribute(String name, int value) throws IOException {
        this.writeAttribute(name, Integer.toString(value));
    }

    public void writeAttribute(String name, long value) throws IOException {
        this.writeAttribute(name, Long.toString(value));
    }

    public void writeAttribute(String name, double value) throws IOException {
        this.writeAttribute(name, Double.toString(value));
    }

    public void writeAttribute(String name, boolean value) throws IOException {
        this.writeAttribute(name, Boolean.toString(value));
    }

    public void writeAttribute(String name, String value) throws IOException {
        this.out.write(32);
        this.out.write(name);
        this.out.write(61);
        this.out.write(34);
        this.out.write(this.escape(value));
        this.out.write(34);
    }

    public void writeComment(String comment) throws IOException {
        this.closeElement();
        this.writeln(true);
        this.out.write("<!-- ");
        this.out.write(this.escape(comment));
        this.out.write(" -->");
        this.writeln(true);
        this.empty = false;
    }

    public void writeNewLine() throws IOException {
        this.closeElement();
        this.writeln(true);
        this.empty = false;
    }

    public void writeText(String text) throws IOException {
        this.writeUnescapedText(this.escape(text));
    }

    public void writeUnescapedText(String text) throws IOException {
        this.closeElement();
        this.empty = false;
        this.newLine = false;
        this.out.write(text);
    }

    private void closeElement() throws IOException {
        if (this.empty) {
            this.out.write(62);
        }
    }

    private void writeln(boolean newline) throws IOException {
        if (newline) {
            this.newLine = false;
            this.out.write(AgitarProperties.LINE_SEPARATOR);
            for (int i = 0; i < this.depth; ++i) {
                this.out.write(9);
            }
        }
    }

    private void writeln() throws IOException {
        this.writeln(this.newLine);
    }

    public void close() {
        try {
            this.writeln();
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeDocType(String name, String publicId, String location) throws IOException {
        StringBuffer doctype = new StringBuffer();
        doctype.append(AgitarProperties.LINE_SEPARATOR);
        doctype.append("<!DOCTYPE ");
        doctype.append(name);
        doctype.append(' ');
        doctype.append("PUBLIC \"");
        doctype.append(publicId);
        doctype.append("\" ");
        doctype.append('\"');
        doctype.append(location);
        doctype.append("\">");
        this.out.write(doctype.toString());
    }

    public String escape(String text) {
        if (!this.fixEncodingBug) {
            return XMLUtility.escape(text);
        }
        if (text == null) {
            return "null";
        }
        StringBuffer outBuf = new StringBuffer(text.length() * 3 / 2);
        if (text != null) {
            int len = text.length();
            char[] inBuf = new char[len];
            text.getChars(0, len, inBuf, 0);
            for (int i = 0; i < len; ++i) {
                this.encodeAndAppend(outBuf, inBuf[i]);
            }
        }
        return outBuf.toString();
    }

    private void encodeAndAppend(StringBuffer outBuf, char c) {
        switch (c) {
            case '&': {
                outBuf.append("&amp;");
                break;
            }
            case '<': {
                outBuf.append("&lt;");
                break;
            }
            case '>': {
                outBuf.append("&gt;");
                break;
            }
            case '\"': {
                outBuf.append("&quot;");
                break;
            }
            case '\'': {
                outBuf.append("&#39;");
                break;
            }
            default: {
                if (StringEscape.isValidXmlCharset(c)) {
                    outBuf.append(c);
                    break;
                }
                outBuf.append("&#").append((int)c).append(';');
            }
        }
    }

    static {
        $assertionsDisabled = !XmlWriter.class.desiredAssertionStatus();
    }
}

