/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.util.SimpleTextTree;
import com.agitar.common.util.XMLParsers;
import com.agitar.common.util.XMLUtility;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlSTTGenerator {
    private static SAXParser parser;

    public static SimpleTextTree getTree(File xmlFile) throws Exception {
        return XmlSTTGenerator.getTree(new FileInputStream(xmlFile));
    }

    public static SimpleTextTree getTree(String xmlStr) throws Exception {
        return XmlSTTGenerator.getTree(xmlStr, "UTF-8");
    }

    public static SimpleTextTree getTree(String xmlStr, String encoding) throws Exception {
        return XmlSTTGenerator.getTree(new ByteArrayInputStream(xmlStr.getBytes(encoding)));
    }

    public static SimpleTextTree getTree(Reader r) throws Exception {
        return XmlSTTGenerator.getTree(new InputSource(r));
    }

    public static SimpleTextTree getTree(InputStream is) throws Exception {
        return XmlSTTGenerator.getTree(new InputSource(new BufferedInputStream(is)));
    }

    public static SimpleTextTree getTree(InputSource is) throws Exception {
        ParseTreeConstructor ptc = new ParseTreeConstructor();
        XmlSTTGenerator.getParser().parse(is, (DefaultHandler)ptc);
        return ptc.getRoot();
    }

    private static SAXParser getParser() throws ParserConfigurationException, SAXException {
        if (parser == null) {
            SAXParserFactory pFactory = XMLParsers.getSaxParserFactory();
            pFactory.setNamespaceAware(false);
            pFactory.setValidating(false);
            parser = pFactory.newSAXParser();
        }
        return parser;
    }

    public static String getXmlStr(SimpleTextTree tree) {
        StringBuffer buf = new StringBuffer(1024);
        XmlSTTGenerator.getElement(tree, buf, new HashSet(), 0);
        return buf.toString();
    }

    private static void getElement(SimpleTextTree tree, StringBuffer sb, HashSet visited, int level) {
        if (!visited.contains(tree)) {
            String tab = "";
            for (int i = 0; i < level; ++i) {
                tab = tab + "  ";
            }
            sb.append(tab);
            sb.append('<').append(tree.name);
            SimpleTextTree[] children = tree.getChildren();
            ArrayList<SimpleTextTree> cElement = new ArrayList<SimpleTextTree>();
            String text = tree.value;
            for (int i = 0; children != null && i < children.length; ++i) {
                SimpleTextTree t = children[i];
                if (t.isAttribute()) {
                    sb.append(' ');
                    sb.append(t.name.substring(1));
                    sb.append("=\"");
                    sb.append(XMLUtility.escape(t.value));
                    sb.append('\"');
                    continue;
                }
                if ("text()".equals(t.name)) {
                    text = t.value;
                    continue;
                }
                cElement.add(t);
            }
            visited.add(tree);
            int n = cElement.size();
            if (n == 0 && text == null) {
                sb.append("/>\n");
                return;
            }
            sb.append(">");
            if (n > 0) {
                sb.append('\n');
                for (int i = 0; i < n; ++i) {
                    XmlSTTGenerator.getElement((SimpleTextTree)cElement.get(i), sb, visited, level + 1);
                }
                sb.append(tab);
            }
            if (text != null) {
                sb.append(XMLUtility.escape(text));
            }
        } else {
            throw new IllegalArgumentException("Cannot generate xml for cyclic tree: " + tree.name);
        }
        sb.append("</");
        sb.append(tree.name);
        sb.append(">\n");
    }

    public static long getLong(String str, long defVal) {
        if (str != null) {
            try {
                return Long.parseLong(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defVal;
    }

    public static long getLong(String str) {
        return XmlSTTGenerator.getLong(str, 0L);
    }

    public static int getInt(String str, int defVal) {
        return (int)XmlSTTGenerator.getLong(str, defVal);
    }

    public static int getInt(String str) {
        return XmlSTTGenerator.getInt(str, 0);
    }

    private static class ParseTreeConstructor
    extends DefaultHandler {
        private SimpleTextTree currentNode = null;
        private SimpleTextTree root = null;

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            return new InputSource(new ByteArrayInputStream("".getBytes()));
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            SimpleTextTree node = new SimpleTextTree(qName);
            int n = attributes.getLength();
            if (n > 0) {
                SimpleTextTree[] children = new SimpleTextTree[n];
                for (int i = 0; i < n; ++i) {
                    children[i] = new SimpleTextTree('@' + attributes.getQName(i), attributes.getValue(i));
                }
                node.setChildren(children);
            }
            if (this.currentNode != null) {
                this.currentNode.addChild(node);
            } else {
                this.root = node;
            }
            this.currentNode = node;
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.currentNode = this.currentNode.parent;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String data = String.valueOf(ch, start, length).trim();
            if (data.length() > 0) {
                this.currentNode.value = this.currentNode.value == null ? data : this.currentNode.value + data;
            }
        }

        public SimpleTextTree getRoot() {
            return this.root;
        }
    }
}

