/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.util.XMLException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;

public class XmlReader {
    private static final int UNKNOWN = 0;
    private static final int OPEN_TAG = 1;
    private static final int EMPTY_TAG = 2;
    private static final int CLOSE_TAG = 3;
    private static final int DECLARATION = 4;
    private Reader in;
    private ArrayList stack;
    private String currentTag;
    private String text;
    private HashMap attributes;
    static /* synthetic */ Class class$com$agitar$common$util$XmlReader;

    public XmlReader(Reader in) {
        if (in == null) {
            throw new NullPointerException("null reader");
        }
        this.in = in;
        this.stack = new ArrayList();
        this.attributes = new HashMap();
    }

    public XmlReader(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public XmlReader(InputStream stream) throws IOException {
        this(new BufferedReader(new InputStreamReader(stream, "UTF-8")));
    }

    public String readElement() throws XMLException {
        this.currentTag = null;
        this.text = null;
        this.read(false);
        return this.currentTag;
    }

    public String getCurrentTag() {
        return this.currentTag;
    }

    public void readElement(String tagName) throws XMLException {
        String element = this.readElement();
        while (element != null) {
            if (element.equals(tagName)) {
                return;
            }
            element = this.readElement();
        }
        throw new XMLException("Could not find tag <" + tagName + ">");
    }

    public String readAttribute(String name) throws XMLException {
        String value = (String)this.attributes.get(name);
        return value != null ? XmlReader.unescape(value) : null;
    }

    public long readLongAttribute(String name) throws XMLException {
        String value = null;
        try {
            value = (String)this.attributes.get(name);
            return value != null ? Long.parseLong(value) : 0L;
        }
        catch (NumberFormatException e) {
            throw new XMLException("Invalid numeric attribute " + name + "='" + value + "'");
        }
    }

    public int readIntAttribute(String name) throws XMLException {
        return (int)this.readLongAttribute(name);
    }

    public double readDoubleAttribute(String name) throws XMLException {
        String value = null;
        try {
            value = (String)this.attributes.get(name);
            return value != null ? Double.parseDouble(value) : 0.0;
        }
        catch (NumberFormatException e) {
            throw new XMLException("Invalid numeric attribute " + name + "='" + value + "'");
        }
    }

    public boolean readBooleanAttribute(String name) throws XMLException {
        String value = (String)this.attributes.get(name);
        if (value == null || value.equals("false")) {
            return false;
        }
        if (value.equals("true")) {
            return true;
        }
        throw new XMLException("Invalid boolean attribute " + name + "='" + value + "'");
    }

    public String readText() throws XMLException {
        this.read(true);
        return XmlReader.unescape(this.text);
    }

    public int getDepth() {
        return this.stack.size();
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String unescape(String string) throws XMLException {
        StringBuffer buffer = new StringBuffer(string);
        XmlReader.replaceUnicode(buffer, "&#");
        XmlReader.replace(buffer, "&quot;", '\"');
        XmlReader.replace(buffer, "&gt;", '>');
        XmlReader.replace(buffer, "&lt;", '<');
        XmlReader.replace(buffer, "&amp;", '&');
        XmlReader.replace(buffer, "&apos;", '\'');
        XmlReader.replace(buffer, "&#39;", '\'');
        return buffer.toString();
    }

    private static void replace(StringBuffer buffer, String entity, char ch) {
        int index = buffer.indexOf(entity);
        while (index != -1) {
            buffer.delete(index, index + entity.length());
            buffer.insert(index, ch);
            index = buffer.indexOf(entity, index + 1);
        }
    }

    private static void replaceUnicode(StringBuffer buffer, String entity) throws XMLException {
        int index = buffer.indexOf(entity);
        while (index != -1) {
            int end = buffer.indexOf(";", index);
            if (end < index + 2) {
                throw new XMLException("Expected semicolon in escape sequence");
            }
            boolean isHex = buffer.charAt(index + 2) == 'x';
            int start = isHex ? index + 3 : index + 2;
            String number = buffer.substring(start, end);
            try {
                char ch = (char)Integer.parseInt(number, isHex ? 16 : 10);
                buffer.delete(index, end + 1);
                buffer.insert(index, ch);
            }
            catch (Exception e) {
                throw new XMLException("Invalid escape sequence \"" + number + "\"");
            }
            index = buffer.indexOf(entity, index + 1);
        }
    }

    private void read(boolean readingTextNode) throws XMLException {
        try {
            Parser parser = new Parser(readingTextNode);
            this.attributes.clear();
            int ch = this.in.read();
            while (ch != -1) {
                parser.handleChar((char)ch);
                if (parser.done()) {
                    return;
                }
                ch = this.in.read();
            }
            parser.validate();
        }
        catch (IOException e) {
            throw new XMLException("Could not read xml file", e);
        }
    }

    private void push(String element) {
        this.stack.add(element);
        this.currentTag = element;
    }

    private void pop(String element) throws XMLException {
        Object expected;
        if (this.stack.isEmpty()) {
            this.handleMissingOpenTag(element);
        }
        if (!element.equals(expected = this.stack.remove(this.stack.size() - 1))) {
            this.handleExpectedCloseTag(expected);
        }
        this.currentTag = this.stack.isEmpty() ? null : (String)this.stack.get(this.stack.size() - 1);
    }

    private void handleMissingOpenTag(Object element) throws XMLException {
        throw new XMLException("Error in xml. Missing open tag for '" + element + "'");
    }

    private void handleExpectedCloseTag(Object expected) throws XMLException {
        throw new XMLException("Error in xml. Expected close tag for '" + expected + "'");
    }

    private void handleUnexpectedChar(char ch) throws XMLException {
        throw new XMLException("Error in xml. Expected '" + ch + "'");
    }

    private class Parser {
        private StringBuffer buffer = new StringBuffer(1024);
        private String tag;
        private String attribute;
        private boolean insideTag;
        private int tagType = 0;
        private boolean readingTextNode;
        private boolean done;
        private char quote;
        private boolean whitespace;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Parser(boolean readingTextNode) {
            this.readingTextNode = readingTextNode;
        }

        public boolean done() {
            return this.done;
        }

        void handleChar(char ch) throws XMLException {
            switch (ch) {
                case '<': {
                    this.handleOpenTag();
                    return;
                }
                case '>': {
                    this.handleCloseTag();
                    return;
                }
                case '/': {
                    this.handleSlash();
                    return;
                }
                case '=': {
                    this.handleEquals();
                    return;
                }
                case '\"': 
                case '\'': {
                    this.handleQuote(ch);
                    return;
                }
                case '?': {
                    this.handleDeclaration();
                    return;
                }
            }
            this.handleText(ch);
        }

        private void handleEquals() {
            if (this.quote != '\u0000' || !this.insideTag) {
                this.buffer.append('=');
                return;
            }
            this.attribute = this.getBuffer();
        }

        private void handleQuote(char ch) {
            if (this.quote == '\u0000' && this.insideTag) {
                this.quote = ch;
            } else if (this.quote == ch) {
                String value = this.getBuffer();
                XmlReader.this.attributes.put(this.attribute, value);
                this.quote = '\u0000';
            } else {
                this.buffer.append(ch);
            }
        }

        private void handleText(char ch) throws XMLException {
            if (this.insideTag) {
                if (Character.isWhitespace(ch)) {
                    if (!this.whitespace && this.tag == null) {
                        this.tag = this.getBuffer();
                    }
                    this.whitespace = true;
                } else {
                    if (this.tagType == 0) {
                        this.tagType = 1;
                    } else if (this.tagType == 2) {
                        XmlReader.this.handleUnexpectedChar('>');
                    }
                    this.whitespace = false;
                }
            } else if (XmlReader.this.getDepth() == 0 && !Character.isWhitespace(ch)) {
                XmlReader.this.handleUnexpectedChar('<');
            }
            if (!this.insideTag && XmlReader.this.getDepth() > 0 || !Character.isWhitespace(ch) || this.quote != '\u0000') {
                this.buffer.append(ch);
            }
        }

        private void handleOpenTag() throws XMLException {
            if (!this.insideTag) {
                this.insideTag = true;
                XmlReader.this.text = this.getBuffer();
            } else {
                XmlReader.this.handleUnexpectedChar('<');
            }
        }

        private void handleCloseTag() throws XMLException {
            this.insideTag = false;
            if (this.tag == null) {
                this.tag = this.getBuffer();
            }
            XmlReader.this.currentTag = this.tag;
            this.tag = null;
            switch (this.tagType) {
                case 1: {
                    XmlReader.this.push(XmlReader.this.currentTag);
                }
                case 2: {
                    this.done = true;
                    return;
                }
                case 3: {
                    XmlReader.this.pop(XmlReader.this.currentTag);
                    if (this.readingTextNode) {
                        this.done = true;
                        return;
                    }
                }
                case 4: {
                    this.tagType = 0;
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        private void handleDeclaration() {
            if (this.quote != '\u0000' || !this.insideTag) {
                this.buffer.append('?');
                return;
            }
            this.tagType = 4;
        }

        private void handleSlash() throws XMLException {
            if (this.quote != '\u0000' || !this.insideTag) {
                this.buffer.append('/');
                return;
            }
            switch (this.tagType) {
                case 1: {
                    this.tagType = 2;
                    break;
                }
                case 0: {
                    this.tagType = 3;
                    break;
                }
                default: {
                    XmlReader.this.handleUnexpectedChar('>');
                }
            }
        }

        private String getBuffer() {
            String string = this.buffer.toString();
            this.buffer = new StringBuffer(this.buffer.length());
            return string;
        }

        public void validate() throws XMLException {
            if (this.insideTag) {
                XmlReader.this.handleUnexpectedChar('>');
            }
            if (!XmlReader.this.stack.isEmpty()) {
                XmlReader.this.handleExpectedCloseTag(XmlReader.this.stack.get(XmlReader.this.stack.size() - 1));
            }
        }

        static {
            $assertionsDisabled = !(class$com$agitar$common$util$XmlReader == null ? (class$com$agitar$common$util$XmlReader = XmlReader.class$("com.agitar.common.util.XmlReader")) : class$com$agitar$common$util$XmlReader).desiredAssertionStatus();
        }
    }
}

