/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.util.AgXPathAPI;
import com.agitar.common.util.XMLParsers;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlDocument {
    private Document document;
    private EntityResolver resolver;

    public XmlDocument(File theFile) throws IOException, ParserConfigurationException, SAXException {
        this(theFile, (EntityResolver)new EmptyResolver());
    }

    public XmlDocument(String xml) throws IOException, ParserConfigurationException, SAXException {
        this(xml, (EntityResolver)new EmptyResolver());
    }

    public XmlDocument(File theFile, EntityResolver theResolver) throws IOException, ParserConfigurationException, SAXException {
        if (!theFile.isFile()) {
            throw new IllegalArgumentException(theFile + " is not a valid file");
        }
        this.setEntityResolver(theResolver);
        this.parse(new InputSource(new BufferedInputStream(new FileInputStream(theFile))));
    }

    public XmlDocument(String xml, EntityResolver theResolver) throws IOException, ParserConfigurationException, SAXException {
        this.setEntityResolver(theResolver);
        this.parse(new InputSource(new ByteArrayInputStream(xml.getBytes())));
    }

    public XmlDocument(Reader in) throws ParserConfigurationException, SAXException, IOException {
        this(in, (EntityResolver)new EmptyResolver());
    }

    public XmlDocument(Reader in, EntityResolver theResolver) throws ParserConfigurationException, SAXException, IOException {
        this.setEntityResolver(theResolver);
        this.parse(new InputSource(in));
    }

    public XmlDocument(InputStream in, EntityResolver theResolver) throws ParserConfigurationException, SAXException, IOException {
        this.setEntityResolver(theResolver);
        this.parse(new InputSource(in));
    }

    public XmlDocument(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        this(in, (EntityResolver)new EmptyResolver());
    }

    private void parse(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder parser = this.createParser();
        this.document = parser.parse(inputSource);
    }

    private DocumentBuilder createParser() throws ParserConfigurationException {
        DocumentBuilder parser = XMLParsers.getDocumentBuilderFactory().newDocumentBuilder();
        if (this.resolver != null) {
            parser.setEntityResolver(this.resolver);
        }
        return parser;
    }

    public Element getDocumentRoot() {
        return this.document.getDocumentElement();
    }

    public Document getDocument() {
        return this.document;
    }

    public String getXPathText(String xpath) throws TransformerException {
        return this.getNode(xpath).getNodeValue();
    }

    public Element[] getXPathElements(String xpath) throws TransformerException {
        NodeList nodes = AgXPathAPI.selectNodeList(this.getDocumentRoot(), xpath);
        Element[] elements = new Element[nodes.getLength()];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = (Element)nodes.item(i);
        }
        return elements;
    }

    public Node getNode(String xpath) throws TransformerException {
        Node node = AgXPathAPI.selectSingleNode(this.getDocumentRoot(), xpath);
        if (node == null) {
            throw new NoSuchElementException("Node not found [" + xpath + "]");
        }
        return node;
    }

    private void setEntityResolver(EntityResolver entityResolver) {
        this.resolver = entityResolver;
    }

    private static class EmptyResolver
    implements EntityResolver {
        private EmptyResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (systemId != null && systemId.startsWith("http://")) {
                InputSource is = new InputSource();
                is.setByteStream(new ByteArrayInputStream("".getBytes()));
                return is;
            }
            return null;
        }
    }
}

