/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.logging.AgitarLevel;
import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.util.AgitarProperties;
import com.agitar.common.util.ExceptionUtility;
import com.agitar.common.util.StringEscape;
import com.agitar.common.util.StringUtility;
import com.agitar.common.util.TypeFormat;
import com.agitar.common.util.XMLException;
import com.agitar.common.util.XMLParsers;
import com.agitar.common.util.XmlWriter;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLUtility {
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private static DocumentBuilderFactory DOCUMENT_FACTORY;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String writeAttribute(String name, String value) {
        if (!$assertionsDisabled && StringUtility.nullOrEmpty(name)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        StringBuffer buf = new StringBuffer(name.length() + value.length() * 3 / 2 + 50);
        XMLUtility.writeAttribute(name, value, buf);
        return buf.toString();
    }

    public static void writeTrue(String name, StringBuffer buf) {
        if (!$assertionsDisabled && StringUtility.nullOrEmpty(name)) {
            throw new AssertionError();
        }
        buf.append(' ');
        buf.append(name);
        buf.append("=\"true\"");
    }

    public static void writeFalse(String name, StringBuffer buf) {
        if (!$assertionsDisabled && StringUtility.nullOrEmpty(name)) {
            throw new AssertionError();
        }
        buf.append(' ');
        buf.append(name);
        buf.append("=\"false\"");
    }

    public static void writeAttribute(String name, String value, StringBuffer buf) {
        if (!$assertionsDisabled && StringUtility.nullOrEmpty(name)) {
            throw new AssertionError();
        }
        buf.append(' ');
        buf.append(name);
        buf.append("=\"");
        XMLUtility.escape(value, buf);
        buf.append('\"');
    }

    public static void writeAttribute(String name, boolean value, StringBuffer buf) {
        if (!$assertionsDisabled && StringUtility.nullOrEmpty(name)) {
            throw new AssertionError();
        }
        buf.append(' ');
        buf.append(name);
        buf.append("=\"");
        buf.append(value ? TRUE : FALSE);
        buf.append('\"');
    }

    public static void writeAttribute(String name, int value, StringBuffer buf) {
        if (!$assertionsDisabled && StringUtility.nullOrEmpty(name)) {
            throw new AssertionError();
        }
        buf.append(' ');
        buf.append(name);
        buf.append("=\"");
        TypeFormat.format(value, buf);
        buf.append('\"');
    }

    public static void writeAttribute(String name, long value, StringBuffer buf) {
        if (!$assertionsDisabled && StringUtility.nullOrEmpty(name)) {
            throw new AssertionError();
        }
        buf.append(' ');
        buf.append(name);
        buf.append("=\"");
        TypeFormat.format(value, buf);
        buf.append('\"');
    }

    public static String getEndTag(String name) {
        if (!$assertionsDisabled && StringUtility.nullOrEmpty(name)) {
            throw new AssertionError();
        }
        StringBuffer buf = new StringBuffer(32);
        XMLUtility.writeEndTag(name, buf);
        return buf.toString();
    }

    public static void writeEndTag(String name, StringBuffer buf) {
        if (!$assertionsDisabled && StringUtility.nullOrEmpty(name)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && buf == null) {
            throw new AssertionError();
        }
        buf.append("</");
        buf.append(name);
        buf.append(">");
        buf.append(AgitarProperties.LINE_SEPARATOR);
    }

    public static Element getElement(Element parent, String name, File f) throws XMLException {
        if (!$assertionsDisabled && StringUtility.nullOrEmpty(name)) {
            throw new AssertionError();
        }
        NodeList list = parent.getChildNodes();
        Element res = null;
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(name)) continue;
            if (res != null) {
                throw new XMLException("There is more than one " + name, f);
            }
            res = (Element)node;
        }
        return res;
    }

    public static Element[] getElements(NodeList nodes) {
        ArrayList<Node> elements = new ArrayList<Node>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() != 1) continue;
            elements.add(n);
        }
        return elements.toArray(new Element[0]);
    }

    public static Element[] getElementsByTagName(Element elm, String name) {
        if (!$assertionsDisabled && elm == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        NodeList nodes = elm.getChildNodes();
        int length = nodes.getLength();
        ArrayList<Element> list = new ArrayList<Element>(length + 1);
        for (int i = 0; i < length; ++i) {
            Element eelm;
            String et;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || (et = (eelm = (Element)node).getTagName()) == null || !et.equals(name)) continue;
            list.add(eelm);
        }
        Element[] res = new Element[list.size()];
        list.toArray(res);
        return res;
    }

    public static String escape(String text) {
        if (text == null) {
            return "null";
        }
        StringBuffer outBuf = new StringBuffer(text.length() * 3 / 2);
        XMLUtility.escape(text, outBuf);
        return outBuf.toString();
    }

    public static void escape(String text, StringBuffer outBuf) {
        if (text != null) {
            int len = text.length();
            char[] inBuf = new char[len];
            text.getChars(0, len, inBuf, 0);
            block7: for (int i = 0; i < len; ++i) {
                char c = inBuf[i];
                switch (c) {
                    case '&': {
                        outBuf.append("&amp;");
                        continue block7;
                    }
                    case '<': {
                        outBuf.append("&lt;");
                        continue block7;
                    }
                    case '>': {
                        outBuf.append("&gt;");
                        continue block7;
                    }
                    case '\"': {
                        outBuf.append("&quot;");
                        continue block7;
                    }
                    case '\'': {
                        outBuf.append("&#39;");
                        continue block7;
                    }
                    default: {
                        StringEscape.encodeUndefinedUnicodeChar(outBuf, c, false);
                    }
                }
            }
        }
    }

    public static String[] getChildrenAsTextNodes(Node root, String name) throws XMLException {
        if (!$assertionsDisabled && StringUtility.nullOrEmpty(name)) {
            throw new AssertionError();
        }
        ArrayList<String> res = new ArrayList<String>();
        NodeList list = root.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            Node theOne = null;
            if (name.equals(node.getNodeName())) {
                theOne = node;
            }
            if (theOne != null) {
                String s = XMLUtility.getValueOfTextNode(node);
                if (s == null) continue;
                res.add(s);
                continue;
            }
            throw new XMLException("unknown element -- " + node.getNodeName());
        }
        return StringUtility.strings(res);
    }

    public static String getValueOfTextNode(Node node) {
        if (!$assertionsDisabled && node == null) {
            throw new AssertionError();
        }
        String res = null;
        for (Node first = node.getFirstChild(); first != null; first = first.getNextSibling()) {
            if (first.getNodeType() != 3) continue;
            res = StringUtility.trim(first.getNodeValue());
            break;
        }
        return res;
    }

    public static String getAttribute(Element elm, String attr) {
        if (!$assertionsDisabled && StringUtility.nullOrEmpty(attr)) {
            throw new AssertionError();
        }
        if (elm == null) {
            return "";
        }
        return StringUtility.trim(elm.getAttribute(attr));
    }

    public static boolean getBooleanAttribute(Element elm, String attr, boolean defaultValue) {
        if (!$assertionsDisabled && (elm == null || StringUtility.nullOrEmpty(attr))) {
            throw new AssertionError();
        }
        String val = StringUtility.trim(elm.getAttribute(attr));
        if (TRUE.equals(val)) {
            return true;
        }
        if (FALSE.equals(val)) {
            return false;
        }
        return defaultValue;
    }

    public static int getIntAttribute(Element elm, String attr, int defaultValue) {
        if (!$assertionsDisabled && (elm == null || StringUtility.nullOrEmpty(attr))) {
            throw new AssertionError();
        }
        String val = StringUtility.trim(elm.getAttribute(attr));
        return !StringUtility.nullOrEmpty(val) ? Integer.parseInt(val) : defaultValue;
    }

    public static long getLongAttribute(Element elm, String attr, long defaultValue) {
        if (!$assertionsDisabled && (elm == null || StringUtility.nullOrEmpty(attr))) {
            throw new AssertionError();
        }
        String val = StringUtility.trim(elm.getAttribute(attr));
        return !StringUtility.nullOrEmpty(val) ? Long.parseLong(val) : defaultValue;
    }

    public static boolean string2Boolean(String s) {
        return TRUE.equalsIgnoreCase(StringUtility.trim(s));
    }

    public static String boolean2String(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static final Node[] getLeaves(Node root) {
        if (!$assertionsDisabled && root == null) {
            throw new AssertionError();
        }
        ArrayList list = new ArrayList();
        XMLUtility.getLeaves(root, list);
        Node[] res = new Node[list.size()];
        if (!$assertionsDisabled && res.length <= 0) {
            throw new AssertionError();
        }
        list.toArray(res);
        return res;
    }

    public static final void getLeaves(Node root, ArrayList list) {
        if (!$assertionsDisabled && list == null) {
            throw new AssertionError();
        }
        if (!root.hasChildNodes()) {
            list.add(root);
            return;
        }
        NodeList kids = root.getChildNodes();
        for (int i = 0; i < kids.getLength(); ++i) {
            XMLUtility.getLeaves(kids.item(i), list);
        }
    }

    public static void writeDocument(Document document, File file) throws FileNotFoundException, TransformerException {
        XMLUtility.writeDocument(document, file, null);
    }

    /*
     * Loose catch block
     */
    public static void writeDocument(Document document, File file, String encoding) throws FileNotFoundException, TransformerException {
        block9: {
            DOMSource domSource = new DOMSource(document);
            String encodingToUse = encoding != null && !encoding.equals("") ? encoding : "UTF-8";
            OutputStreamWriter osw = null;
            osw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encodingToUse);
            StreamResult streamResult = new StreamResult(osw);
            TransformerFactory tf = XMLParsers.getTransformerFactory();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("encoding", encodingToUse);
            serializer.setOutputProperty("indent", "yes");
            serializer.transform(domSource, streamResult);
            Object var10_10 = null;
            try {
                if (osw != null) {
                    osw.close();
                }
                break block9;
            }
            catch (IOException e) {
                AgitarLogger.getDiagnosticLogger("xmlutility").log(AgitarLevel.SEVERE, ExceptionUtility.getMessageFromThrowable(e), e);
            }
            break block9;
            {
                catch (UnsupportedEncodingException e) {
                    AgitarLogger.getDiagnosticLogger("xmlutility").log(AgitarLevel.SEVERE, ExceptionUtility.getMessageFromThrowable(e), e);
                    throw new TransformerException("UnsupportedEncodingException in writing out document." + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                try {
                    if (osw != null) {
                        osw.close();
                    }
                }
                catch (IOException e) {
                    AgitarLogger.getDiagnosticLogger("xmlutility").log(AgitarLevel.SEVERE, ExceptionUtility.getMessageFromThrowable(e), e);
                }
                throw throwable;
            }
        }
    }

    public static void writeNode(PrintWriter pw, Node node) throws IOException {
        XmlWriter writer = new XmlWriter(pw, false);
        XMLUtility.writeElement(writer, node);
    }

    private static void writeElement(XmlWriter writer, Node node) throws IOException {
        int i;
        writer.startElement(node.getNodeName());
        for (i = 0; i < node.getAttributes().getLength(); ++i) {
            Node attribute = node.getAttributes().item(i);
            writer.writeAttribute(attribute.getNodeName(), attribute.getNodeValue());
        }
        if (node.getFirstChild() != null) {
            for (i = 0; i < node.getChildNodes().getLength(); ++i) {
                Node childNode = node.getChildNodes().item(i);
                XMLUtility.writeElement(writer, childNode);
            }
        }
        if (!StringUtility.nullOrEmpty(node.getNodeValue())) {
            writer.writeText(node.getNodeValue());
        }
        writer.endElement(node.getNodeName());
        writer.writeUnescapedText("\n");
    }

    public static final DocumentBuilder getDocumentBuilder() {
        if (DOCUMENT_FACTORY == null) {
            try {
                DOCUMENT_FACTORY = (DocumentBuilderFactory)Class.forName("agitar.org.apache.crimson.jaxp.DocumentBuilderFactoryImpl").newInstance();
            }
            catch (Throwable e) {
                DOCUMENT_FACTORY = DocumentBuilderFactory.newInstance();
            }
            DOCUMENT_FACTORY.setCoalescing(true);
            DOCUMENT_FACTORY.setIgnoringComments(true);
            DOCUMENT_FACTORY.setIgnoringElementContentWhitespace(true);
            DOCUMENT_FACTORY.setNamespaceAware(true);
            DOCUMENT_FACTORY.setValidating(false);
        }
        try {
            DocumentBuilder builder = DOCUMENT_FACTORY.newDocumentBuilder();
            builder.setEntityResolver(new EmptyResolver());
            return builder;
        }
        catch (Exception ex) {
            AgitarLogger.getDiagnosticLogger("xmlutility").log(AgitarLevel.SEVERE, ExceptionUtility.getMessageFromThrowable(ex), ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(File file) throws SAXException, IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        try {
            Document document = XMLUtility.parse(is, file.toString());
            return document;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(InputStream input) throws SAXException, IOException {
        try {
            Document document = XMLUtility.parse(new InputStreamReader(input, "UTF-8"));
            return document;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(Reader reader) throws IOException, SAXException {
        try {
            Document document = XMLUtility.getDocumentBuilder().parse(new InputSource(reader));
            return document;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private static Document parse(InputStream input, String systemId) throws SAXException, IOException {
        Document doc = XMLUtility.getDocumentBuilder().parse(input, systemId);
        input.close();
        return doc;
    }

    private XMLUtility() {
    }

    static {
        $assertionsDisabled = !XMLUtility.class.desiredAssertionStatus();
    }

    private static class EmptyResolver
    implements EntityResolver {
        private EmptyResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (systemId != null && systemId.startsWith("http://")) {
                InputSource is = new InputSource();
                is.setByteStream(new ByteArrayInputStream("".getBytes()));
                return is;
            }
            return null;
        }
    }
}

