/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLParsers {
    private static boolean caching;
    private static TransformerFactory transformerFactory;
    private static DocumentBuilderFactory documentBuilderFactory;
    private static SAXParserFactory saxParserFactory;

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        XMLParsers.init();
        return documentBuilderFactory;
    }

    public static SAXParserFactory getSaxParserFactory() {
        XMLParsers.init();
        return saxParserFactory;
    }

    public static TransformerFactory getTransformerFactory() {
        XMLParsers.init();
        return transformerFactory;
    }

    public static Transformer newTransformer(InputStream in) throws TransformerConfigurationException, SAXException, ParserConfigurationException {
        XMLParsers.init();
        XMLReader reader = saxParserFactory.newSAXParser().getXMLReader();
        reader.setFeature("http://xml.org/sax/features/namespaces", true);
        SAXSource sax = new SAXSource(reader, new InputSource(in));
        return transformerFactory.newTransformer(sax);
    }

    public static void setCache(boolean enabled) {
        caching = enabled;
        if (enabled) {
            XMLParsers.init();
        }
    }

    public static void init() {
        if (transformerFactory == null || !caching) {
            transformerFactory = TransformerFactory.newInstance();
        }
        if (documentBuilderFactory == null || !caching) {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        if (saxParserFactory == null || !caching) {
            saxParserFactory = SAXParserFactory.newInstance();
        }
    }

    public static void setSystemProperties() {
        if (transformerFactory != null) {
            System.setProperty("javax.xml.transform.TransformerFactory", transformerFactory.getClass().getName());
        }
        if (documentBuilderFactory != null) {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", documentBuilderFactory.getClass().getName());
        }
        if (saxParserFactory != null) {
            System.setProperty("javax.xml.parsers.SAXParserFactory", saxParserFactory.getClass().getName());
        }
    }
}

