/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.util.StringUtility;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;

public class Version {
    protected static final String UNKNOWN_FIELD = "unknown";
    private static Version instance;
    private String fullVersionNumber;
    private String simpleVersionNumber;
    private String commonVersionNumber;
    private String product = "unknown";
    private String version = "unknown";
    public static int EARLIER_VERSION;
    public static int LATER_VERSION;
    public static final int SAME_VERSION = 0;

    public Version() {
        this.fullVersionNumber = this.readVersionFile();
        this.parseVersionNumber();
    }

    Version(String fullVersionNumber) {
        this.fullVersionNumber = fullVersionNumber;
        this.parseVersionNumber();
    }

    public Version(String product, String version, String timestamp) {
        if (product != null) {
            this.product = product;
        }
        if (version != null) {
            this.version = version;
        }
        this.simpleVersionNumber = product + ' ' + version;
        this.commonVersionNumber = version + " (" + timestamp + ')';
        this.fullVersionNumber = product + ' ' + this.commonVersionNumber;
    }

    public String getFullNumber() {
        return this.fullVersionNumber;
    }

    public String getSimpleNumber() {
        return this.simpleVersionNumber;
    }

    public String getCommonNumber() {
        return this.commonVersionNumber;
    }

    private void parseVersionNumber() {
        int idx = this.fullVersionNumber.indexOf(40);
        this.simpleVersionNumber = idx > 0 ? this.fullVersionNumber.substring(0, idx).trim() : this.fullVersionNumber;
        int firstSpace = this.fullVersionNumber.indexOf(32);
        if (firstSpace > 0) {
            this.product = this.fullVersionNumber.substring(0, firstSpace);
            this.commonVersionNumber = this.fullVersionNumber.substring(firstSpace + 1);
        } else {
            this.product = "AgitarOne";
            this.commonVersionNumber = this.fullVersionNumber;
        }
        int secondSpace = this.commonVersionNumber.indexOf(" (");
        this.version = secondSpace > 0 ? this.commonVersionNumber.substring(0, secondSpace) : UNKNOWN_FIELD;
    }

    private String readVersionFile() {
        try {
            InputStream is = this.getClass().getResourceAsStream("version.txt");
            if (is == null) {
                return "";
            }
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(is));
            String line = reader.readLine();
            while (line != null) {
                if (!StringUtility.nullOrEmpty(line)) {
                    return line;
                }
                line = reader.readLine();
            }
            return "";
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static Version getInstance() {
        if (instance == null) {
            instance = new Version();
        }
        return instance;
    }

    public static void setInstance(Version instance) {
        Version.instance = instance;
    }

    public String getProduct() {
        return this.product;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMajorVersion() {
        String[] versionNumbers = this.parseVersionNumbers();
        if (versionNumbers == null || versionNumbers.length == 0) {
            return null;
        }
        return this.parseVersionNumbers()[0];
    }

    public String getMinorVersion() {
        String[] versionNumbers = this.parseVersionNumbers();
        if (versionNumbers == null || versionNumbers.length < 2) {
            return null;
        }
        return this.parseVersionNumbers()[1];
    }

    public String getMinorMinorVersion() {
        String[] versionNumbers = this.parseVersionNumbers();
        if (versionNumbers == null || versionNumbers.length < 3) {
            return null;
        }
        return this.parseVersionNumbers()[2];
    }

    public String getFullBuildNumber() {
        int leftBraket = this.fullVersionNumber.indexOf(91);
        int rightBraket = this.fullVersionNumber.indexOf(93);
        return this.fullVersionNumber.substring(leftBraket + 1, rightBraket);
    }

    private String[] parseVersionNumbers() {
        if (UNKNOWN_FIELD.equals(this.version) || StringUtility.nullOrEmpty(this.version)) {
            return null;
        }
        String versionJustNumbers = this.version.startsWith("Version ") ? this.version.substring("Version ".length(), this.version.length()) : this.version;
        return versionJustNumbers.split("\\.");
    }

    public static boolean checkLinuxKernelVersion() {
        if (System.getProperty("os.name").toLowerCase().startsWith("linux")) {
            String kversion = System.getProperty("os.version");
            try {
                int x;
                int idx = kversion.indexOf(45);
                if (idx > -1) {
                    kversion = kversion.substring(0, idx);
                }
                String[] v = kversion.split("\\.");
                int[] target = new int[]{2, 4, 20};
                int n = Math.min(v.length, target.length);
                for (int i = 0; i < n && (x = Integer.parseInt(v[i])) >= target[i]; ++i) {
                    if (x <= target[i]) continue;
                    return true;
                }
                AgitarLogger.getUserLogger().warning("\n=============================================\nYour OS kernel version is 2.4.20 or earlier,\nwhich is known to have resource locking problem\nwith the JVM during long Agitation runs.\n=============================================\n");
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public int compareVersions(Version other) {
        int majorCompare = this.leftVersionComparedToRight(this.getMajorVersion(), other.getMajorVersion());
        if (majorCompare != 0) {
            return majorCompare;
        }
        int minorCompare = this.leftVersionComparedToRight(this.getMinorVersion(), other.getMinorVersion());
        if (minorCompare != 0) {
            return minorCompare;
        }
        return this.leftVersionComparedToRight(this.getMinorMinorVersion(), other.getMinorMinorVersion());
    }

    private int leftVersionComparedToRight(String leftSideStr, String rightSideStr) {
        Integer rightVer;
        Integer leftVer;
        if (StringUtility.nullOrEmpty(leftSideStr)) {
            if (StringUtility.nullOrEmpty(rightSideStr)) {
                return 0;
            }
            return EARLIER_VERSION;
        }
        if (StringUtility.nullOrEmpty(rightSideStr)) {
            return LATER_VERSION;
        }
        try {
            leftVer = new Integer(leftSideStr);
        }
        catch (NumberFormatException nfe) {
            try {
                Integer.parseInt(rightSideStr);
                return EARLIER_VERSION;
            }
            catch (NumberFormatException nfe2) {
                return 0;
            }
        }
        try {
            rightVer = new Integer(rightSideStr);
        }
        catch (NumberFormatException nfe) {
            return LATER_VERSION;
        }
        if (rightVer.intValue() == leftVer.intValue()) {
            return 0;
        }
        if (rightVer > leftVer) {
            return EARLIER_VERSION;
        }
        return LATER_VERSION;
    }

    public static void main(String[] args) {
        System.out.println(Version.getInstance().getFullNumber());
    }

    static {
        EARLIER_VERSION = -1;
        LATER_VERSION = 1;
    }
}

