/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.util.AgitarProperties;
import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;

public final class Utility {
    public static final String nl;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Object[] arraycopy(Class cls, Object[] array1, Object[] array2) {
        if (array1 == null && array2 == null) {
            return null;
        }
        if (array1 != null && (array2 == null || array2.length == 0)) {
            return array1;
        }
        if ((array1 == null || array1.length == 0) && array2 != null) {
            return array2;
        }
        Object[] res = (Object[])Array.newInstance(cls, array1.length + array2.length);
        System.arraycopy(array1, 0, res, 0, array1.length);
        System.arraycopy(array2, 0, res, array1.length, array2.length);
        return res;
    }

    public static String type(Object obj) {
        if (obj == null) {
            return "NULL";
        }
        return obj.getClass().getName();
    }

    public static Throwable rootCause(Throwable thr) {
        Throwable r = thr;
        while (r.getCause() != null) {
            r = r.getCause();
        }
        return r;
    }

    public static final void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void delete(ArrayList args, int[] indices) {
        int i;
        if (indices == null || indices.length == 0) {
            return;
        }
        Object[] targets = new Object[indices.length];
        for (i = 0; i < indices.length; ++i) {
            if (!($assertionsDisabled || indices[i] >= 0 && indices[i] < args.size())) {
                throw new AssertionError();
            }
            targets[i] = args.get(indices[i]);
        }
        for (i = 0; i < targets.length; ++i) {
            args.remove(targets[i]);
        }
    }

    public static TreeSet toTreeSet(Object[] vals) {
        TreeSet<Object> set = new TreeSet<Object>();
        for (int i = 0; vals != null && i < vals.length; ++i) {
            set.add(vals[i]);
        }
        return set;
    }

    public static final void addAll(Collection collection, Object[] objects) {
        if (!$assertionsDisabled && collection == null) {
            throw new AssertionError();
        }
        if (objects == null) {
            return;
        }
        for (int i = 0; objects != null && i < objects.length; ++i) {
            if (objects[i] == null) continue;
            collection.add(objects[i]);
        }
    }

    public static void removeAll(Collection coll, Object[] objs) {
        if (coll == null || objs == null) {
            return;
        }
        for (int i = 0; i < objs.length; ++i) {
            coll.remove(objs[i]);
        }
    }

    public static void removeAll(Collection set1, Collection set2) {
        if (set1 == null || set2 == null) {
            return;
        }
        set1.removeAll(set2);
    }

    public static final boolean containsAny(Collection collection, Object[] objects) {
        if (!$assertionsDisabled && collection == null) {
            throw new AssertionError();
        }
        for (int i = 0; objects != null && i < objects.length; ++i) {
            if (!collection.contains(objects[i])) continue;
            return true;
        }
        return false;
    }

    public static final boolean containsAny(Object[] collection, Object[] objects) {
        if (!$assertionsDisabled && collection == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && objects == null) {
            throw new AssertionError();
        }
        if (collection.length * objects.length > 1000 && objects.length > 3) {
            HashSet hs = new HashSet();
            Utility.addAll(hs, collection);
            return Utility.containsAny(hs, objects);
        }
        for (int i = 0; i < collection.length; ++i) {
            for (int j = 0; j < objects.length; ++j) {
                if (!collection[i].equals(objects[j])) continue;
                return true;
            }
        }
        return false;
    }

    public static final Set add(Set s1, String elm) {
        HashSet<String> res = null;
        if (s1 != null) {
            res = s1;
            if (elm != null) {
                res.add(elm);
            }
        } else if (elm != null) {
            res = new HashSet<String>();
            res.add(elm);
        }
        return res;
    }

    public static final Set union(Set s1, Set s2) {
        Set res = null;
        if (s1 != null) {
            res = s1;
            if (s2 != null) {
                s1.addAll(s2);
            }
        } else if (s2 != null) {
            res = s2;
        }
        return res;
    }

    public static HashSet intersect(Collection a, Collection b) {
        int as = a.size();
        int bs = b.size();
        if (as < 1 || bs < 1) {
            return new HashSet();
        }
        HashSet r = new HashSet(Math.min(as, bs));
        Collection big = a;
        Collection small = b;
        if (bs > as || a instanceof List) {
            big = b;
            small = a;
        }
        Iterator it = small.iterator();
        while (it.hasNext()) {
            Object v = it.next();
            if (!big.contains(v)) continue;
            r.add(v);
        }
        return r;
    }

    public static List cloneAndSort(List list) {
        list = new ArrayList(list);
        Collections.sort(list);
        return list;
    }

    public static List cloneAndSort(List list, Comparator comp) {
        list = new ArrayList(list);
        Collections.sort(list, comp);
        return list;
    }

    public static Object[] cloneAndSort(Object[] a) {
        a = (Object[])a.clone();
        Arrays.sort(a);
        return a;
    }

    public static Object[] cloneAndSort(Object[] a, Comparator comp) {
        a = (Object[])a.clone();
        Arrays.sort(a, comp);
        return a;
    }

    public static void fixupSystemPreferences() {
        if (!AgitarProperties.OS_NAME.toUpperCase().startsWith("WINDOWS") && AgitarProperties.JAVA_VERSION.indexOf("1.4.1") >= 0 && !new File("/etc/.java").exists()) {
            System.setProperty("java.util.prefs.systemRoot", AgitarProperties.USER_HOME + File.separator + ".agitar");
        }
    }

    public static boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    public static String logRealCause(Throwable exception, Logger userLogger) {
        Throwable classException = exception;
        while (classException != null && classException.getCause() != null && classException.getCause() != classException) {
            if (!((classException = classException.getCause()) instanceof NoClassDefFoundError) && !(classException instanceof ClassNotFoundException) || classException.getMessage().trim().length() <= 0) continue;
            String msg = "-- caused by: " + classException;
            if (userLogger == null) {
                return msg;
            }
            userLogger.warning(msg);
            break;
        }
        return null;
    }

    static {
        $assertionsDisabled = !Utility.class.desiredAssertionStatus();
        nl = AgitarProperties.LINE_SEPARATOR;
    }
}

