/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

public class UserTimer {
    static Map timers = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timer start(String timerName) {
        Timer t;
        Map map = timers;
        synchronized (map) {
            t = (Timer)timers.get(timerName);
            if (t == null) {
                t = new Timer(timerName);
                timers.put(timerName, t);
            }
        }
        t.start();
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(String timerName) {
        Map map = timers;
        synchronized (map) {
            Timer t = (Timer)timers.get(timerName);
            if (t != null) {
                t.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpAll(Logger logger, boolean reset, int threshold) {
        Map map = timers;
        synchronized (map) {
            Iterator i = timers.values().iterator();
            while (i.hasNext()) {
                Timer next = (Timer)i.next();
                if (next.isRunning() || next.totalTime <= (long)threshold) continue;
                logger.info(next.toString());
                if (!reset) continue;
                i.remove();
            }
        }
    }

    public static void dumpAll(Logger logger, boolean reset) {
        UserTimer.dumpAll(logger, reset, 0);
    }

    public static class Timer {
        private String timerName;
        private int numTimes;
        private long totalTime;
        private long minTime;
        private long maxTime;
        private long startTime = 0L;

        private Timer(String timerName) {
            this.timerName = timerName;
            this.numTimes = 0;
            this.totalTime = 0L;
            this.minTime = Integer.MAX_VALUE;
            this.maxTime = Integer.MIN_VALUE;
            this.startTime = 0L;
        }

        private synchronized void start() {
            ++this.numTimes;
            if (this.startTime != 0L) {
                this.stop();
            }
            this.startTime = System.currentTimeMillis();
        }

        public synchronized void stop() {
            if (this.startTime == 0L) {
                return;
            }
            long diffTime = System.currentTimeMillis() - this.startTime;
            if (diffTime < this.minTime) {
                this.minTime = diffTime;
            }
            if (diffTime > this.maxTime) {
                this.maxTime = diffTime;
            }
            this.totalTime += diffTime;
            this.startTime = 0L;
        }

        public boolean isRunning() {
            return this.startTime != 0L;
        }

        public String toString() {
            return this.timerName + " invoked " + this.numTimes + " times for " + this.totalTime + " ms. [min: " + this.minTime + ", max: " + this.maxTime + "]";
        }
    }
}

