/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.util.Assertions;
import java.util.Set;

public class UniqueNameGenerator {
    public static final String UNIQIFIER_PATTERN = "\\{.*i.*\\}";
    public static final String UNIQIFIER_INDEX = "i";
    private Set names;

    public UniqueNameGenerator(Set names) {
        this.names = names;
    }

    public String generate(String pattern, String uniqifier, String defaultValue) {
        String name = pattern.replaceAll(UNIQIFIER_PATTERN, defaultValue);
        int i = 2;
        while (this.names.contains(name)) {
            String newName = pattern.replaceAll(UNIQIFIER_PATTERN, uniqifier.replaceAll(UNIQIFIER_INDEX, Integer.toString(i)));
            Assertions.assertNotEquals("Uniqifier not found in pattern", newName, name);
            name = newName;
            ++i;
        }
        return name;
    }
}

