/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.diagnostics.Diagnostics;
import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.util.EvilTwin;
import com.agitar.common.util.StringUtility;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public abstract class TimingStats
extends LinkedHashMap {
    public static final String TIMING_STATS_LOG_NAME = "TimingStats";
    private static TimingStats stats;
    private static final char SEPARATOR = ';';
    public final String className;
    private final Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void addTimingStats(Kind key, String value) {
        if (stats != null) {
            stats.put(key.getName(), value);
        } else {
            AgitarLogger.getDiagnosticLogger().fine("TimingStats " + key + "=" + value + " not logged");
        }
    }

    public static void addTimingStats(Kind key, long time) {
        TimingStats.addTimingStats(key, "" + time);
    }

    public static void logTimingStats() {
        if (stats != null) {
            if (EvilTwin.isMe()) {
                TimingStats.stats.logger.warning(stats.toString());
            } else {
                TimingStats.stats.logger.info(stats.toString());
            }
            Iterator iter = stats.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = String.valueOf(entry.getKey());
                String value = String.valueOf(entry.getValue());
                Diagnostics.getKey("timing." + key).set(value);
            }
        }
    }

    public static void clearStats() {
        stats = null;
    }

    public static void setTimingStats(String className, Logger logger) {
        if (!$assertionsDisabled && StringUtility.nullOrEmpty(className)) {
            throw new AssertionError();
        }
        if (stats != null) {
            AgitarLogger.getDiagnosticLogger().warning("TimingStats is already set. old=" + TimingStats.stats.className + " new=" + className);
        }
        stats = new TimingStats(className, logger){};
    }

    public static TimingStats decode(String text) {
        int start = text.indexOf(91);
        int last = text.lastIndexOf(93);
        if (start <= 0 || last <= start) {
            return null;
        }
        TimingStats res = new TimingStats(text.substring(0, start).trim(), null){};
        String[] pair = StringUtility.split(text.substring(start + 1, last), ';');
        for (int i = 0; i < pair.length; ++i) {
            String content = pair[i];
            int eq = content.indexOf(61);
            if (eq <= 0 || eq == content.length() - 1) {
                res.put(content, "");
                continue;
            }
            res.put(content.substring(0, eq), content.substring(eq + 1));
        }
        return res;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.className).append('[');
        boolean first = true;
        Iterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (first) {
                first = false;
            } else {
                buffer.append(';');
            }
            String key = this.fixup(entry.getKey());
            String value = this.fixup(entry.getValue());
            buffer.append(key).append('=').append(value);
        }
        buffer.append(']');
        return buffer.toString();
    }

    private String fixup(Object value) {
        if (value == null) {
            return "null";
        }
        return value.toString().replace(';', '_').replace('=', '_');
    }

    private TimingStats(String className, Logger logger) {
        this.className = className;
        this.logger = logger == null ? AgitarLogger.getDiagnosticLogger(TIMING_STATS_LOG_NAME) : logger;
    }

    static {
        $assertionsDisabled = !TimingStats.class.desiredAssertionStatus();
    }

    public static class Kind {
        private String name;
        private boolean isCounter;

        public Kind(String name) {
            this(name, false);
        }

        public Kind(String name, boolean isCounter) {
            this.name = name;
            this.isCounter = isCounter;
        }

        public String getName() {
            return this.name;
        }

        public boolean isCounter() {
            return this.isCounter;
        }
    }
}

