/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class TimeOptimizedSuite
extends TestSuite {
    private final Map timers;
    private final File timeFile;
    private Vector sortedTests;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TimeOptimizedSuite(File timeFile) {
        if (timeFile == null) {
            throw new IllegalArgumentException();
        }
        this.timers = new HashMap();
        this.timeFile = timeFile;
    }

    public void run(TestResult result) {
        result.addListener((TestListener)new TimingListener(this.timers));
        super.run(result);
        this.saveTimes();
    }

    private Map loadTimes() {
        HashMap<String, Integer> nameToTime = new HashMap<String, Integer>();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(this.timeFile));
            while ((line = in.readLine()) != null) {
                String[] words = line.split(" ");
                if (!$assertionsDisabled && words.length != 2) {
                    throw new AssertionError();
                }
                nameToTime.put(words[0], new Integer(words[1]));
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return nameToTime;
    }

    public void addTest(Test test) {
        super.addTest(test);
        this.sortedTests = null;
    }

    public Enumeration tests() {
        if (this.sortedTests == null) {
            Map nameToTime = this.loadTimes();
            ArrayList<TestWrapper> tests = new ArrayList<TestWrapper>();
            Enumeration e = super.tests();
            while (e.hasMoreElements()) {
                Test test;
                Number time = (Number)nameToTime.get((test = (Test)e.nextElement()).toString());
                tests.add(new TestWrapper(test, time == null ? 0 : time.intValue()));
            }
            Collections.sort(tests);
            this.sortedTests = new Vector(tests.size());
            Iterator iterator = tests.iterator();
            while (iterator.hasNext()) {
                TestWrapper testWrapper = (TestWrapper)iterator.next();
                this.sortedTests.add(testWrapper.getTest());
            }
        }
        return this.sortedTests.elements();
    }

    private void saveTimes() {
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.timeFile)));
            Iterator iterator = this.timers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String test = (String)entry.getKey();
                Timer timer = (Timer)entry.getValue();
                out.println(test + " " + timer.getDuration());
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        $assertionsDisabled = !TimeOptimizedSuite.class.desiredAssertionStatus();
    }

    private static class TestWrapper
    implements Comparable {
        private final Test test;
        private final int index;

        public TestWrapper(Test test, int index) {
            this.test = test;
            this.index = index;
        }

        public Test getTest() {
            return this.test;
        }

        public int compareTo(Object o) {
            TestWrapper that = (TestWrapper)o;
            return this.index - that.index;
        }
    }

    private static class Timer {
        private long start;
        private int time;

        private Timer() {
        }

        public void start() {
            this.start = System.currentTimeMillis();
        }

        public void stop() {
            long end = System.currentTimeMillis();
            if (this.time >= 0) {
                this.time = (int)((long)this.time + (end - this.start));
            }
        }

        public int getDuration() {
            return this.time;
        }

        public void flag() {
            this.time = -1;
        }
    }

    private static class TimingListener
    implements TestListener {
        private final Map timers;

        public TimingListener(Map timers) {
            this.timers = timers;
        }

        public void addError(Test test, Throwable t) {
            this.getTimer(test).flag();
        }

        public void addFailure(Test test, AssertionFailedError t) {
            this.getTimer(test).flag();
        }

        public void endTest(Test test) {
            this.getTimer(test).stop();
        }

        public void startTest(Test test) {
            this.getTimer(test).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Timer getTimer(Test test) {
            Map map = this.timers;
            synchronized (map) {
                Timer timer;
                String testName = test.toString();
                int paren = testName.indexOf(40);
                if (paren > 0) {
                    testName = testName.substring(paren + 1, testName.length() - 1);
                }
                if ((timer = (Timer)this.timers.get(testName)) == null) {
                    timer = new Timer();
                    this.timers.put(testName, timer);
                }
                return timer;
            }
        }
    }
}

