/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.util.ExecArgsParser;
import com.agitar.common.util.IOUtility;
import com.agitar.common.util.StringUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class TestRunProperties
extends Properties {
    private static final String CLASS_PATH_KEY = "cp";
    private static final String TESTS_KEY = "tests";
    private static final String ROOT_KEY = "root";
    private static final String PROJECT_NAME_KEY = "projectName";
    private static final String RESULTS_DIR_KEY = "resultsDir";
    private static final String IGNORE_HAND_WRITTENS = "ignorehandwrittens";
    private static final String JUNIT_XML_RESULTS_DIR = "junixmlresultsdir";
    private static final String VM_ARGS = "vmargs";
    private static final String CWD_KEY = "cwd";

    public TestRunProperties(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.load(fileInputStream);
        fileInputStream.close();
    }

    public TestRunProperties() {
    }

    public void setCWD(String cwd) {
        this.setProperty(CWD_KEY, cwd);
    }

    public void setUserClassPath(String classPath) {
        this.setProperty(CLASS_PATH_KEY, classPath);
    }

    public void setTests(String[] tests) {
        this.setProperty(TESTS_KEY, StringUtility.toCSVString(tests));
    }

    public void setRoot(File rootDir) {
        this.setProperty(ROOT_KEY, IOUtility.getCanonicalPath(rootDir));
    }

    public void setResultsDir(File resultsDir) {
        this.setProperty(RESULTS_DIR_KEY, IOUtility.getCanonicalPath(resultsDir));
    }

    public void setProjectName(String name) {
        this.setProperty(PROJECT_NAME_KEY, "name");
    }

    public void setIgnoreHandWrittens(boolean ignoreHandWrittenTests) {
        this.setProperty(IGNORE_HAND_WRITTENS, Boolean.toString(ignoreHandWrittenTests));
    }

    public String[] getTests() {
        return StringUtility.split(this.getProperty(TESTS_KEY), ',');
    }

    public boolean isIgnoreHandWrittens() {
        if (this.getProperty(IGNORE_HAND_WRITTENS) == null) {
            return true;
        }
        return Boolean.valueOf(this.getProperty(IGNORE_HAND_WRITTENS));
    }

    public void setJUnitXMLResultsDir(File jUnitXMLResultsDir) {
        this.setProperty(JUNIT_XML_RESULTS_DIR, IOUtility.getCanonicalPath(jUnitXMLResultsDir));
    }

    public void setJVMArgs(String[] vmArgs) {
        this.setProperty(VM_ARGS, StringUtility.mergeStrings(vmArgs, ' '));
    }

    public String[] getJVMArgs() {
        return ExecArgsParser.split(this.getProperty(VM_ARGS));
    }

    public String getJunitXMLResultsDir() {
        return this.getProperty(JUNIT_XML_RESULTS_DIR);
    }

    public File getCoverageResultsDir() {
        return new File(this.getProperty(RESULTS_DIR_KEY));
    }

    public String getUserClassPath() {
        return this.getProperty(CLASS_PATH_KEY);
    }

    public String getProjectName() {
        return this.getProperty(PROJECT_NAME_KEY);
    }

    public String getBaseDir() {
        return this.getProperty(ROOT_KEY);
    }

    public String getCWD() {
        return this.getProperty(CWD_KEY);
    }
}

