/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.util.StringUtility;
import com.agitar.common.util.TestClassMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class TestClassSorter {
    public static TestClassResultSets findTestClassesForTargetClasses(Set targetClasses, Set allClasses) {
        HashSet<String> testClasses = new HashSet<String>();
        Iterator iter = allClasses.iterator();
        block0: while (iter.hasNext()) {
            String testName = (String)iter.next();
            for (int i = 0; i < TestClassMapper.REGEXS.length; ++i) {
                Pattern pattern = TestClassMapper.REGEXS[i];
                if (pattern.matcher(testName) == null) continue;
                testClasses.add(testName);
                continue block0;
            }
        }
        return TestClassSorter.find(StringUtility.strings(testClasses), targetClasses, TestClassMapper.REGEXS);
    }

    public static TestClassResultSets findTargetClasses(String[] testClassNames, Set targetClasses) {
        return TestClassSorter.find(testClassNames, targetClasses, TestClassMapper.REGEXS);
    }

    private static TestClassResultSets find(String[] testClassNames, Set targetClasses, Pattern[] patterns) {
        TestClassResultSets result = new TestClassResultSets();
        for (int i = 0; i < testClassNames.length; ++i) {
            String testName = testClassNames[i];
            boolean found = false;
            block1: for (int j = 0; !found && j < patterns.length; ++j) {
                Pattern pattern = TestClassMapper.REGEXS[j];
                List list = TestClassMapper.findMatchingNames(testName, pattern);
                String[] targetNames = StringUtility.strings(list);
                for (int k = 0; k < targetNames.length; ++k) {
                    String target = targetNames[k];
                    if (!targetClasses.contains(target)) continue;
                    result.add(target, testName);
                    found = true;
                    continue block1;
                }
            }
            if (found) continue;
            result.add(null, testName);
        }
        return result;
    }

    public static class TestClassResultSets {
        public final Set nonTestClasses;
        public final TreeSet testClasses;
        public static final String NONE = "~NONE~";
        public final Map targetToTestMap = new TreeMap();
        public final Map testToTargetMap = new HashMap();
        public final Set classesWithoutTest;

        public static TestClassResultSets convert(String text) {
            TestClassResultSets res = new TestClassResultSets();
            if (text != null) {
                int start = 0;
                int openCurly = text.indexOf(123);
                while (openCurly > 0) {
                    String key = text.substring(start, openCurly);
                    int closeCurly = text.indexOf(125, openCurly);
                    String csv = text.substring(openCurly + 1, closeCurly);
                    String[] testClasses = csv.length() == 0 ? new String[]{} : csv.split(",");
                    for (int i = 0; i < testClasses.length; ++i) {
                        String name = testClasses[i];
                        res.add(key, name);
                    }
                    start = closeCurly + 1;
                    openCurly = text.indexOf(123, closeCurly);
                }
            }
            return res;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            Iterator iter = this.targetToTestMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object key = entry.getKey();
                buffer.append(key);
                buffer.append('{');
                Set set = (Set)entry.getValue();
                boolean first = true;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String name = (String)iterator.next();
                    if (first) {
                        first = false;
                    } else {
                        buffer.append(',');
                    }
                    buffer.append(name);
                }
                buffer.append('}');
            }
            return buffer.toString();
        }

        public String[] getTestForTarget(String targetName) {
            return StringUtility.strings((Set)this.targetToTestMap.get(targetName));
        }

        public String getTargetForTest(String testName) {
            return (String)this.testToTargetMap.get(testName);
        }

        public void removeTest(String testClass) {
            String target = (String)this.testToTargetMap.get(testClass);
            if (target != null) {
                this.nonTestClasses.remove(target);
                this.targetToTestMap.remove(target);
            }
            this.testClasses.remove(testClass);
            this.testToTargetMap.remove(testClass);
        }

        private void add(String targetClass, String testClass) {
            if (targetClass == null) {
                targetClass = NONE;
            } else {
                this.nonTestClasses.add(targetClass);
            }
            TreeSet<String> set = (TreeSet<String>)this.targetToTestMap.get(targetClass);
            if (set == null) {
                set = new TreeSet<String>();
                this.targetToTestMap.put(targetClass, set);
            }
            if (testClass != null) {
                set.add(testClass);
                this.testClasses.add(testClass);
                this.testToTargetMap.put(testClass, targetClass);
            }
        }

        private TestClassResultSets() {
            this.nonTestClasses = new HashSet();
            this.testClasses = new TreeSet();
            this.classesWithoutTest = new HashSet();
        }

        public String[] getRealTargetClasses() {
            TreeSet result = new TreeSet(this.nonTestClasses);
            result.remove(NONE);
            return StringUtility.strings(result);
        }
    }
}

