/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.types.ClassName;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TestClassMapper {
    public static final Pattern DEFAULT_REGEX1 = Pattern.compile("(.*)Test[0-9]*");
    public static final Pattern DEFAULT_REGEX2 = Pattern.compile("(.*)_Test[0-9]*");
    public static final Pattern[] REGEXS = new Pattern[]{Pattern.compile("(.*)AgitarTest[0-9]*"), DEFAULT_REGEX2, DEFAULT_REGEX1, Pattern.compile("(.*)_Test_[0-9]*"), Pattern.compile("(.*)Test_[0-9]*"), Pattern.compile("Test[0-9]*_(.+)"), Pattern.compile("Test[0-9]*(.+)"), Pattern.compile("Test_[0-9]*_(.+)"), Pattern.compile("Test_[0-9]*(.+)"), Pattern.compile("(.*)[0-9]+Test"), Pattern.compile("Ag(.*)Test[0-9]*"), Pattern.compile("Ag(.*)_Test[0-9]*"), Pattern.compile("(.*)_Tests"), Pattern.compile("(.*)Tests")};
    private ClassList list;
    static /* synthetic */ Class class$com$agitar$common$util$TestClassMapper;

    public TestClassMapper(ClassList list) {
        this.list = list;
    }

    public TestClassMapper(final Set set) {
        this.list = new ClassList(){

            public boolean contains(String name) {
                return set.contains(name);
            }
        };
    }

    public String getTargetClassFromName(String testClassName) {
        ClassNameContainer wrapper = new ClassNameContainer(testClassName);
        String result = this.checkExpressions(wrapper, REGEXS);
        if (result == null && testClassName.indexOf(95) > 0) {
            wrapper = new ClassNameContainer(testClassName.replace('_', '$'));
            result = this.checkExpressions(wrapper, REGEXS);
        }
        return result;
    }

    private String checkExpressions(ClassNameContainer wrapper, Pattern[] patterns) {
        String res = TestClassMapper.checkAllRegexs(wrapper, patterns, this.list);
        if (res == null && wrapper.testPackagePrefix != null) {
            res = TestClassMapper.checkAllRegexs(new ClassNameContainer(wrapper.nameWithoutPackage, wrapper.testPackagePrefix, null), patterns, this.list);
        }
        return res;
    }

    private static String checkAllRegexs(ClassNameContainer wrapper, Pattern[] patterns, ClassList classList) {
        for (int i = 0; i < patterns.length; ++i) {
            List res = TestClassMapper.findMatchingNames(wrapper, patterns[i], classList);
            if (res == null || res.size() <= 0) continue;
            return (String)res.get(0);
        }
        return null;
    }

    public static List findMatchingNames(String name, Pattern pattern) {
        List list = TestClassMapper.findMatchingNames(new ClassNameContainer(name), pattern, null);
        if (name.indexOf(95) > 0) {
            list.addAll(TestClassMapper.findMatchingNames(new ClassNameContainer(name.replace('_', '$')), pattern, null));
        }
        return list;
    }

    private static List findMatchingNames(ClassNameContainer wrapper, Pattern pattern, ClassList classList) {
        List res = new ArrayList();
        Matcher matcher = pattern.matcher(wrapper.nameWithoutPackage);
        if (matcher != null && matcher.matches()) {
            String targetClassName = matcher.group(1);
            String fullClassName = wrapper.packagePrefix + targetClassName;
            if (classList == null) {
                TestClassMapper.addToList(res, fullClassName);
            } else {
                if (classList.contains(fullClassName)) {
                    return TestClassMapper.addToList(res, fullClassName);
                }
                if (targetClassName.indexOf(95) > -1) {
                    String name = targetClassName.replace('_', '$');
                    if (classList.contains(wrapper.packagePrefix + name)) {
                        return TestClassMapper.addToList(res, wrapper.packagePrefix + name);
                    }
                }
            }
        }
        if (wrapper.nameWithoutPackage.indexOf(36) < 0 && wrapper.nameWithoutPackage.indexOf(95) > 0) {
            wrapper = wrapper.replaceUnderScore();
        }
        res = TestClassMapper.checkInner(wrapper, pattern, classList, res);
        return res;
    }

    private static List checkInner(ClassNameContainer wrapper, Pattern pattern, ClassList classList, List res) {
        if (wrapper.nameWithoutPackage.indexOf(36) >= 0) {
            String name1 = wrapper.nameWithoutPackage.substring(0, wrapper.nameWithoutPackage.indexOf(36));
            String name2 = wrapper.nameWithoutPackage.substring(wrapper.nameWithoutPackage.indexOf(36) + 1);
            Matcher matcher1 = pattern.matcher(name1);
            Matcher matcher2 = pattern.matcher(name2);
            if (matcher1 != null && matcher2 != null && matcher1.matches() && matcher2.matches()) {
                String targetClassName = matcher1.group(1) + '$' + matcher2.group(1);
                String fullClassName = wrapper.packagePrefix + targetClassName;
                if (classList == null) {
                    res = TestClassMapper.addToList(res, fullClassName);
                } else if (classList.contains(fullClassName)) {
                    res = TestClassMapper.addToList(res, fullClassName);
                }
            }
        }
        return res;
    }

    private static List addToList(List list, String name) {
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(name);
        return list;
    }

    private static class ClassNameContainer {
        private final String nameWithoutPackage;
        private final String packagePrefix;
        private final String testPackagePrefix;
        static final /* synthetic */ boolean $assertionsDisabled;

        private ClassNameContainer replaceUnderScore() {
            ClassNameContainer wrapper = new ClassNameContainer(this.nameWithoutPackage.replace('_', '$'), this.packagePrefix, this.testPackagePrefix);
            return wrapper;
        }

        private ClassNameContainer(String nameWithoutPackage, String packagePrefix, String testPackagePrefix) {
            if (!$assertionsDisabled && nameWithoutPackage == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && packagePrefix == null) {
                throw new AssertionError();
            }
            this.nameWithoutPackage = nameWithoutPackage;
            this.packagePrefix = packagePrefix;
            this.testPackagePrefix = testPackagePrefix;
        }

        private ClassNameContainer(String className) {
            ClassName cn = ClassName.get(className);
            this.nameWithoutPackage = cn.getNameWithoutPackage();
            String packageName = cn.getPackageName();
            this.packagePrefix = packageName.equals("") ? packageName : packageName + ".";
            String newPackagePrefix = null;
            if (this.packagePrefix.endsWith(".test.")) {
                newPackagePrefix = this.packagePrefix.substring(0, this.packagePrefix.length() - "test.".length());
            } else if (this.packagePrefix.startsWith(".test.")) {
                newPackagePrefix = this.packagePrefix.substring(".test.".length() + 1);
            }
            this.testPackagePrefix = newPackagePrefix;
        }

        static {
            $assertionsDisabled = !(class$com$agitar$common$util$TestClassMapper == null ? (class$com$agitar$common$util$TestClassMapper = TestClassMapper.class$("com.agitar.common.util.TestClassMapper")) : class$com$agitar$common$util$TestClassMapper).desiredAssertionStatus();
        }
    }

    public static interface ClassList {
        public boolean contains(String var1);
    }
}

