/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.util.AgitarProperties;
import com.agitar.common.util.IOUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;

public final class StringUtility {
    private static final int MAX_TRACE_DEPTH = 15;
    public static final String[] EMPTY_STRING_ARRAY;
    public static final String[] NONE;
    private static SimpleDateFormat dateFormat;
    private static DecimalFormat decimalFormat;
    public static final String nl;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String squeezeWhiteSpaceWithComma(String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        StringBuffer buffer = new StringBuffer(input.length());
        boolean foundComma = false;
        boolean foundSpace = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c <= ' ') {
                if (foundComma) {
                    foundComma = false;
                    foundSpace = true;
                    continue;
                }
                if (foundSpace) continue;
                foundSpace = true;
                buffer.append(' ');
                continue;
            }
            if (c == ',') {
                foundComma = true;
                foundSpace = false;
                if (buffer.length() > 1 && buffer.charAt(buffer.length() - 1) == ' ') {
                    buffer.setLength(buffer.length() - 1);
                }
                buffer.append(c);
                continue;
            }
            foundComma = false;
            foundSpace = false;
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String squeezeWhiteSpace(String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        StringBuffer buffer = new StringBuffer(input.length());
        boolean foundSpace = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c <= ' ') {
                if (foundSpace) continue;
                foundSpace = true;
                buffer.append(' ');
                continue;
            }
            foundSpace = false;
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String cat(char a, String b, char c, String d, char e, String f, char g) {
        StringBuffer r = new StringBuffer(4 + b.length() + d.length() + f.length());
        r.append(a).append(b).append(c).append(d).append(e).append(f).append(g);
        return r.toString();
    }

    public static String cat(char a, String b, char c) {
        StringBuffer r = new StringBuffer(2 + b.length());
        r.append(a).append(b).append(c);
        return r.toString();
    }

    public static String cat(String b, char c, String d, char e, String f) {
        StringBuffer r = new StringBuffer(2 + b.length() + d.length() + f.length());
        r.append(b).append(c).append(d).append(e).append(f);
        return r.toString();
    }

    public static String cat(String a, String b, String c, String d, String e) {
        int al = a.length();
        int bl = b.length();
        int cl = c.length();
        int dl = d.length();
        int el = e.length();
        int cs = bl + al;
        int ds = cl + cs;
        int es = dl + ds;
        char[] r = new char[es + el];
        a.getChars(0, al, r, 0);
        b.getChars(0, bl, r, al);
        c.getChars(0, cl, r, cs);
        d.getChars(0, dl, r, ds);
        e.getChars(0, el, r, es);
        return new String(r);
    }

    public static String cat(String a, String b, String c, String d, String e, String f, String g) {
        int al = a.length();
        int bl = b.length();
        int cl = c.length();
        int dl = d.length();
        int el = e.length();
        int fl = f.length();
        int gl = g.length();
        int cs = bl + al;
        int ds = cl + cs;
        int es = dl + ds;
        int fs = el + es;
        int gs = fl + fs;
        char[] r = new char[gs + gl];
        a.getChars(0, al, r, 0);
        b.getChars(0, bl, r, al);
        c.getChars(0, cl, r, cs);
        d.getChars(0, dl, r, ds);
        e.getChars(0, el, r, es);
        f.getChars(0, fl, r, fs);
        g.getChars(0, gl, r, gs);
        return new String(r);
    }

    public static String cat(String a, String b, String c, String d) {
        int al = a.length();
        int bl = b.length();
        int cl = c.length();
        int dl = d.length();
        int cs = bl + al;
        int ds = cl + cs;
        char[] r = new char[ds + dl];
        a.getChars(0, al, r, 0);
        b.getChars(0, bl, r, al);
        c.getChars(0, cl, r, cs);
        d.getChars(0, dl, r, ds);
        return new String(r);
    }

    public static String cat(String a, String b, String c) {
        int al = a.length();
        int bl = b.length();
        int cl = c.length();
        int cs = bl + al;
        char[] r = new char[cs + cl];
        a.getChars(0, al, r, 0);
        b.getChars(0, bl, r, al);
        c.getChars(0, cl, r, cs);
        return new String(r);
    }

    public static String cat(String a, String b, char c) {
        StringBuffer r = new StringBuffer(a.length() + b.length() + 1);
        r.append(a).append(b).append(c);
        return r.toString();
    }

    public static String cat(String a, char b, String c) {
        StringBuffer r = new StringBuffer(a.length() + c.length() + 1);
        r.append(a).append(b).append(c);
        return r.toString();
    }

    public static String cat(String a, char b, int c) {
        StringBuffer r = new StringBuffer(a.length() + 11);
        r.append(a).append(b);
        switch (c) {
            case -1: {
                r.append("-1");
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                char iv = (char)(48 + c);
                r.append(iv);
                break;
            }
            default: {
                r.append(Integer.toString(c, 10));
            }
        }
        return r.toString();
    }

    public static String cat(String a, String b) {
        int al = a.length();
        int bl = b.length();
        char[] r = new char[al + bl];
        a.getChars(0, al, r, 0);
        b.getChars(0, bl, r, al);
        return new String(r);
    }

    public static String cleanTrace(Throwable exc) {
        return StringUtility.cleanTrace(exc, false, true);
    }

    public static String[] cleanTraceWithoutTopMessage(Throwable exc, boolean checkJUnit) {
        return StringUtility.cleanStackTraceAsArray0(exc, checkJUnit, false);
    }

    public static String cleanTrace(Throwable exc, boolean checkJUnit, boolean keepTopMessage) {
        if (!$assertionsDisabled && exc == null) {
            throw new AssertionError();
        }
        StringBuffer res = new StringBuffer(2048);
        String[] traces = StringUtility.cleanStackTraceAsArray0(exc, checkJUnit, keepTopMessage);
        for (int i = 0; i < traces.length; ++i) {
            if (i != 0) {
                res.append(nl);
            }
            res.append(traces[i]);
        }
        return res.toString();
    }

    static boolean keepTrace(StackTraceElement trace, boolean checkJUnit) {
        if (trace == null) {
            return false;
        }
        String className = trace.getClassName();
        if (StringUtility.nullOrEmpty(className)) {
            return false;
        }
        String methodName = trace.getMethodName();
        if (methodName.startsWith("access$")) {
            return false;
        }
        if (className.startsWith("com.agitar.lib.") || className.startsWith("com.agitar.common.")) {
            return true;
        }
        return !className.startsWith("com.agitar.") && !className.startsWith("java.lang.Thread.run") && !className.startsWith("sun.reflect.") && !className.startsWith("java.lang.reflect.") && (!checkJUnit || !className.startsWith("junit.framework.Assert."));
    }

    public static String[] cleanStackTraceAsArray(Throwable exc, boolean checkJUnit) {
        return StringUtility.cleanStackTraceAsArray0(exc, checkJUnit, true);
    }

    private static String[] cleanStackTraceAsArray0(Throwable exc, boolean checkJUnit, boolean keepTopMessage) {
        if (!$assertionsDisabled && exc == null) {
            throw new AssertionError();
        }
        ArrayList<String> cleanList = new ArrayList<String>();
        if (keepTopMessage) {
            cleanList.add(exc.toString());
        }
        StringUtility.getTrace(checkJUnit, cleanList, exc.getStackTrace());
        StringUtility.cleanStackTraceForCause(exc, checkJUnit, cleanList, 0, false);
        return cleanList.toArray(new String[cleanList.size()]);
    }

    private static void getTrace(boolean checkJUnit, List cleanList, StackTraceElement[] elms) {
        for (int i = 0; i < elms.length; ++i) {
            if (!StringUtility.keepTrace(elms[i], checkJUnit)) continue;
            cleanList.add(elms[i].toString().trim());
        }
    }

    private static void cleanStackTraceForCause(Throwable exc, boolean checkJUnit, List cleanList, int depth, boolean causeByOnly) {
        if (!$assertionsDisabled && exc == null) {
            throw new AssertionError();
        }
        Throwable cause = exc.getCause();
        if (depth <= 15 && cause != null) {
            boolean causeBy = false;
            ArrayList list = new ArrayList();
            StringUtility.getTrace(checkJUnit, list, cause.getStackTrace());
            if (list.size() > 0) {
                if (!causeByOnly) {
                    cleanList.add("");
                }
                cleanList.add("Caused by: " + cause.toString());
                cleanList.addAll(list);
            } else {
                causeBy = true;
            }
            StringUtility.cleanStackTraceForCause(cause, checkJUnit, cleanList, depth + 1, causeBy);
        }
    }

    public static String[] getLines(File file) throws IOException {
        if (file == null) {
            throw new IOException("file is null");
        }
        LineNumberReader reader = new LineNumberReader(new FileReader(file));
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            String text;
            if (line != null && (text = line.trim()).length() != 0) {
                list.add(text);
            }
            line = reader.readLine();
        }
        return StringUtility.strings(list);
    }

    public static String[] getJavaArgs(String[] args) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-X")) continue;
            set.add(args[i].substring(2));
        }
        return StringUtility.strings(set);
    }

    public static boolean isJavaIdentifier(String name) {
        if (StringUtility.nullOrEmpty(name)) {
            return false;
        }
        return name.matches("[A-Za-z_]\\w*");
    }

    public static boolean isFullJavaIdentifier(String name) {
        if (StringUtility.nullOrEmpty(name)) {
            return false;
        }
        return name.matches("[A-Za-z_]\\w*(\\.[A-Za-z_]\\w*)*");
    }

    public static boolean isFullJavaClassName(String name) {
        if (StringUtility.nullOrEmpty(name)) {
            return false;
        }
        return name.matches("[A-Za-z_]\\w*([.$][A-Za-z_]\\w*)*");
    }

    public static String dateFormatter(long time) {
        return dateFormat.format(new Date(time));
    }

    public static String dateFormatter(Date date) {
        return dateFormat.format(date);
    }

    public static String decimalFormatter(double d) {
        return decimalFormat.format(d);
    }

    public static String roundup(double num) {
        return StringUtility.decimalFormatter(num);
    }

    public static String plainReplaceAll(String instr, String srch, String replace) {
        if (!($assertionsDisabled || srch != null && replace != null)) {
            throw new AssertionError();
        }
        if (instr == null || instr.length() < srch.length() || srch.length() < 1) {
            return instr;
        }
        int last = 0;
        int fnd = instr.indexOf(srch);
        if (fnd == -1) {
            return instr;
        }
        StringBuffer r = new StringBuffer(instr.length() * 2);
        while (fnd != -1) {
            r.append(instr.substring(last, fnd)).append(replace);
            last = fnd + srch.length();
            fnd = instr.indexOf(srch, last);
        }
        r.append(instr.substring(last));
        return r.toString();
    }

    public static String[] concat(String[] list1, String[] list2) {
        if (list1 == null && list2 == null) {
            return EMPTY_STRING_ARRAY;
        }
        if (list2 == null) {
            return list1;
        }
        String[] res = new String[list1.length + list2.length];
        System.arraycopy(list1, 0, res, 0, list1.length);
        System.arraycopy(list2, 0, res, list1.length, list2.length);
        return res;
    }

    public static boolean match(String target, String[] filter) {
        if (StringUtility.nullOrEmpty(target)) {
            return false;
        }
        if (filter == null || filter.length == 0) {
            return true;
        }
        for (int i = 0; i < filter.length; ++i) {
            if (StringUtility.nullOrEmpty(filter[i])) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                continue;
            }
            if (!target.matches(filter[i])) continue;
            return true;
        }
        return false;
    }

    public static String[] match(String[] target, String[] filter) {
        HashSet<String> res = new HashSet<String>();
        for (int i = 0; target != null && i < target.length; ++i) {
            if (!StringUtility.match(target[i], filter)) continue;
            res.add(target[i]);
        }
        return StringUtility.strings(res);
    }

    public static boolean matchWithIndexOf(String target, String[] filter) {
        if (StringUtility.nullOrEmpty(target)) {
            return false;
        }
        if (filter == null || filter.length == 0) {
            return true;
        }
        for (int i = 0; i < filter.length; ++i) {
            if (StringUtility.nullOrEmpty(filter[i])) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                continue;
            }
            if (target.indexOf(filter[i]) < 0) continue;
            return true;
        }
        return false;
    }

    public static String[] csvToStringArray(String str) {
        return StringUtility.splitString(str, ',');
    }

    public static String[] splitString(String str, char separator) {
        if (StringUtility.nullOrEmpty(StringUtility.trim(str))) {
            return EMPTY_STRING_ARRAY;
        }
        return StringUtility.trim(str.split("" + separator));
    }

    public static String toCSVString(String[] items) {
        return StringUtility.mergeStrings(items, ',');
    }

    public static String mergeStrings(String[] items, char separator) {
        String res = "";
        for (int i = 0; items != null && i < items.length; ++i) {
            if (!$assertionsDisabled && items[i] == null) {
                throw new AssertionError();
            }
            if (i != 0) {
                res = res + separator;
            }
            res = res + items[i];
        }
        return res;
    }

    public static String trim(String s) {
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    public static String[] trim(String[] strs) {
        for (int i = 0; strs != null && i < strs.length; ++i) {
            strs[i] = StringUtility.trim(strs[i]);
        }
        return strs;
    }

    public static boolean nullOrEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean noNullElement(Object[] objs) {
        for (int i = 0; objs != null && i < objs.length; ++i) {
            if (objs[i] != null) continue;
            return false;
        }
        return true;
    }

    public static ArrayList toList(String[] values) {
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; values != null && i < values.length; ++i) {
            res.add(values[i]);
        }
        return res;
    }

    public static HashSet set(String[] strs) {
        int len = strs.length;
        HashSet<String> ret = new HashSet<String>(len * 2);
        for (int i = 0; i < len; ++i) {
            ret.add(strs[i]);
        }
        return ret;
    }

    public static String[] strings(Collection coll) {
        if (coll == null || coll.isEmpty()) {
            return NONE;
        }
        return coll.toArray(new String[coll.size()]);
    }

    public static String[] toString(Object[] o) {
        String[] result = new String[o.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = o[i].toString();
        }
        return result;
    }

    public static String[] cdr(String[] arr) {
        if (arr == null) {
            return null;
        }
        if (arr.length < 2) {
            return NONE;
        }
        String[] r = new String[arr.length - 1];
        System.arraycopy(arr, 1, r, 0, r.length);
        return r;
    }

    public static boolean allEqual(String[] a, String[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] == null ? b[i] != null : !a[i].equals(b[i]))) continue;
            return false;
        }
        return true;
    }

    public static String trace(Throwable ex) {
        if (!$assertionsDisabled && ex == null) {
            throw new AssertionError();
        }
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        String res = sw.toString();
        if (res.length() == 0) {
            return ex.getClass().getName();
        }
        return res;
    }

    public static int countOccurrences(String s, char c) {
        char[] ca = s.toCharArray();
        int count = 0;
        for (int i = 0; i < ca.length; ++i) {
            if (ca[i] != c) continue;
            ++count;
        }
        return count;
    }

    public static String removeBlank(String text) {
        if (StringUtility.nullOrEmpty(text)) {
            return text;
        }
        int len = text.length();
        int count = 0;
        char[] inBuf = new char[len];
        text.getChars(0, len, inBuf, 0);
        block3: for (int i = 0; i < len; ++i) {
            char c = inBuf[i];
            switch (c) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
                default: {
                    inBuf[count++] = c;
                }
            }
        }
        if (count == len) {
            return text;
        }
        return new String(inBuf, 0, count);
    }

    public static String safeSubstring(String line, int start) {
        return start >= line.length() ? "" : line.substring(start);
    }

    public static String safeSubstring(String line, int start, int end) {
        if (start > end || start >= line.length()) {
            return "";
        }
        if (end >= line.length()) {
            return line.substring(start);
        }
        return line.substring(start, end);
    }

    public static String toJavaSyntaxString(String literal) {
        if (literal == null) {
            return null;
        }
        literal = literal.replaceAll("\\\\", "\\\\\\\\").replaceAll("'", "\\\\'").replaceAll("\"", "\\\\\"");
        return "\"" + literal + '\"';
    }

    public static String toJavaSyntaxChar(char c) {
        StringBuffer unicode = new StringBuffer(Integer.toHexString(c));
        while (unicode.length() < 4) {
            unicode.insert(0, '0');
        }
        unicode.insert(0, "'\\u");
        unicode.append('\'');
        return unicode.toString();
    }

    public static String join(String[] s, String separator) {
        if (separator == null) {
            separator = "null";
        }
        int seplen = separator.length();
        int salen = s.length;
        int len = seplen * Math.max(salen - 1, 0);
        for (int i = 0; i < salen; ++i) {
            String si = s[i];
            len += si == null ? 4 : si.length();
        }
        int offset = 0;
        char[] result = new char[len];
        for (int i = 0; i < salen; ++i) {
            String si = s[i];
            if (si == null) {
                si = "null";
            }
            int slen = si.length();
            si.getChars(0, slen, result, offset);
            offset += slen;
            if (i + 1 >= salen) continue;
            separator.getChars(0, seplen, result, offset);
            offset += seplen;
        }
        return new String(result);
    }

    public static String join(String[] s, char separator) {
        int salen = s.length;
        int len = Math.max(salen - 1, 0);
        for (int i = 0; i < salen; ++i) {
            String si = s[i];
            len += si == null ? 4 : si.length();
        }
        int offset = 0;
        char[] result = new char[len];
        for (int i = 0; i < salen; ++i) {
            String si = s[i];
            if (si == null) {
                si = "null";
            }
            int slen = si.length();
            si.getChars(0, slen, result, offset);
            offset += slen;
            if (i + 1 >= salen) continue;
            result[offset] = separator;
            ++offset;
        }
        return new String(result);
    }

    public static String[] split(String s, char separator) {
        if (s == null || s.length() == 0) {
            return NONE;
        }
        char[] ca = s.toCharArray();
        int count = 1;
        int cct = ca.length;
        int first = -1;
        for (int i = 0; i < cct; ++i) {
            if (ca[i] != separator) continue;
            if (first < 0) {
                first = i;
            }
            ++count;
        }
        String[] result = new String[count];
        if (count == 1) {
            result[0] = s;
            return result;
        }
        int cst = 0;
        int cidx = 0;
        for (int i = first; i < cct; ++i) {
            if (ca[i] != separator) continue;
            int ct = i - cst;
            result[cidx++] = ct < 1 ? "" : new String(ca, cst, ct);
            cst = i + 1;
            if (cidx == count - 1) break;
        }
        result[result.length - 1] = new String(ca, cst, cct - cst);
        return result;
    }

    public static String[] split(String s, String delim) {
        if (s == null || s.length() == 0) {
            return new String[0];
        }
        StringTokenizer tok = new StringTokenizer(s, delim);
        String[] result = new String[tok.countTokens()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = tok.nextToken();
        }
        return result;
    }

    public static String trimLeading(String s) {
        int startpt;
        int len = s.length();
        for (startpt = 0; startpt < len && s.charAt(startpt) <= ' '; ++startpt) {
        }
        return s.substring(startpt);
    }

    public static String trimTrailing(String s) {
        int endpt = s.length();
        while (endpt - 1 >= 0 && s.charAt(endpt - 1) <= ' ') {
            --endpt;
        }
        return s.substring(0, endpt);
    }

    private StringUtility() {
    }

    public static boolean stringEquals(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    public static void toFile(File file, String stringToWrite) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write(stringToWrite);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtility.close(fileWriter, true);
        }
    }

    public static String fileToString(File file) {
        try {
            int ch;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuffer buff = new StringBuffer();
            while ((ch = reader.read()) != -1) {
                buff.append((char)ch);
            }
            return buff.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] classPathAsArrayOfStrings(String cp) {
        return cp.split(AgitarProperties.PATH_SEPARATOR);
    }

    public static String time(long time) {
        if (!$assertionsDisabled && time < 0L) {
            throw new AssertionError();
        }
        StringBuffer buffer = new StringBuffer();
        long ms = time % 1000L;
        buffer.append(ms);
        if (ms < 10L) {
            buffer.insert(0, "00");
        } else if (ms < 100L) {
            buffer.insert(0, 0);
        }
        buffer.insert(0, '.');
        long remain = time / 1000L;
        long sec = remain % 60L;
        buffer.insert(0, sec);
        if (sec < 10L) {
            buffer.insert(0, 0);
        }
        buffer.insert(0, ':');
        long min = remain / 60L;
        buffer.insert(0, min);
        if (min < 10L) {
            buffer.insert(0, 0);
        }
        return buffer.toString();
    }

    public static String toSimpleClassName(String name) {
        if (name == null) {
            return null;
        }
        int idx = name.lastIndexOf(46);
        if (idx <= 0) {
            return name;
        }
        return name.substring(idx + 1);
    }

    public static boolean equals(String[] one, String[] theOther) {
        if (one == null && theOther == null) {
            return true;
        }
        if (one != null && theOther != null && one.length == theOther.length) {
            for (int i = 0; i < theOther.length; ++i) {
                if (StringUtility.equals(theOther[i], one[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(String one, String theOther) {
        if (one == null && theOther == null) {
            return true;
        }
        if (one != null && theOther != null) {
            return one.equals(theOther);
        }
        return false;
    }

    static {
        $assertionsDisabled = !StringUtility.class.desiredAssertionStatus();
        EMPTY_STRING_ARRAY = new String[0];
        NONE = EMPTY_STRING_ARRAY;
        dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss z");
        decimalFormat = new DecimalFormat("#.###");
        nl = AgitarProperties.LINE_SEPARATOR;
    }
}

