/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

public class StringEscape {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String code(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof Boolean) {
            return obj.toString();
        }
        if (obj instanceof Character) {
            char x = ((Character)obj).charValue();
            return StringEscape.javaEscape(new String(new char[]{x}), '\'');
        }
        if (obj instanceof String) {
            return StringEscape.javaEscape((String)obj, '\"');
        }
        if (obj instanceof Number) {
            if (obj instanceof Float || obj instanceof Double) {
                double dv = ((Number)obj).doubleValue();
                boolean flt = obj instanceof Float;
                if (Double.isNaN(dv)) {
                    return (flt ? "Float." : "Double.") + "NaN";
                }
                if (Double.isInfinite(dv)) {
                    boolean neg = dv < 0.0;
                    return (flt ? "Float." : "Double.") + (neg ? "NEGA" : "POSI") + "TIVE_INFINITY";
                }
                if (obj instanceof Double) {
                    if (dv == Double.MAX_VALUE) {
                        return "Double.MAX_VALUE";
                    }
                    if (dv == -1.7976931348623157E308) {
                        return "-Double.MAX_VALUE";
                    }
                    if (dv == Double.MIN_VALUE) {
                        return "Double.MIN_VALUE";
                    }
                    if (dv == -4.9E-324) {
                        return "-Double.MIN_VALUE";
                    }
                } else if (obj instanceof Float) {
                    float fv = ((Float)obj).floatValue();
                    if (fv == Float.MAX_VALUE) {
                        return "Float.MAX_VALUE";
                    }
                    if (fv == -3.4028235E38f) {
                        return "-Float.MAX_VALUE";
                    }
                    if (fv == Float.MIN_VALUE) {
                        return "Float.MIN_VALUE";
                    }
                    if (fv == -1.4E-45f) {
                        return "-Float.MIN_VALUE";
                    }
                }
                return obj.toString() + (flt ? "F" : "");
            }
            if (obj instanceof Long) {
                long iv = (Long)obj;
                if (iv == Long.MAX_VALUE) {
                    return "Long.MAX_VALUE";
                }
                if (iv == Long.MIN_VALUE) {
                    return "Long.MIN_VALUE";
                }
                return obj.toString() + "L";
            }
            if (obj instanceof Short) {
                return "(short)" + obj.toString();
            }
            if (obj instanceof Byte) {
                return "(byte)" + obj.toString();
            }
            if (obj instanceof Integer) {
                int iv = (Integer)obj;
                switch (iv) {
                    case 0x7FFFFFFF: {
                        return "Integer.MAX_VALUE";
                    }
                    case -2147483648: {
                        return "Integer.MIN_VALUE";
                    }
                    case 0x7FFFFFFE: {
                        return "Integer.MAX_VALUE - 1";
                    }
                    case -2147483647: {
                        return "Integer.MIN_VALUE + 1";
                    }
                    case 0x7FFFFFFD: {
                        return "Integer.MAX_VALUE - 2";
                    }
                    case -2147483646: {
                        return "Integer.MIN_VALUE + 2";
                    }
                    case 0x7FFFFFFC: {
                        return "Integer.MAX_VALUE - 3";
                    }
                    case -2147483645: {
                        return "Integer.MIN_VALUE + 3";
                    }
                }
                return obj.toString();
            }
            return obj.toString();
        }
        return "<an " + obj.getClass().getName() + ">";
    }

    public static String javaEscape(String theString, char quoteChar) {
        if (theString == null) {
            return "null";
        }
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2 + 3);
        if (quoteChar != '\u0000') {
            outBuffer.append(quoteChar);
        }
        block10: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    outBuffer.append(' ');
                    continue block10;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block10;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block10;
                }
                case '\"': {
                    if (quoteChar == '\"') {
                        outBuffer.append('\\');
                    }
                    outBuffer.append('\"');
                    continue block10;
                }
                case '\'': {
                    if (quoteChar == '\'') {
                        outBuffer.append('\\');
                    }
                    outBuffer.append('\'');
                    continue block10;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block10;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block10;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block10;
                }
                default: {
                    StringEscape.encodeUndefinedUnicodeChar(outBuffer, aChar);
                }
            }
        }
        if (quoteChar != '\u0000') {
            outBuffer.append(quoteChar);
        }
        return outBuffer.toString();
    }

    public static String encodeUndefinedUnicodeChar(String s) {
        StringBuffer buf = new StringBuffer(s.length());
        char[] c = s.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            StringEscape.encodeUndefinedUnicodeChar(buf, c[i], false);
        }
        if (s.length() == buf.length()) {
            return s;
        }
        return buf.toString();
    }

    public static void encodeUndefinedUnicodeChar(StringBuffer outBuffer, char aChar) {
        StringEscape.encodeUndefinedUnicodeChar(outBuffer, aChar, true);
    }

    public static void encodeUndefinedUnicodeChar(StringBuffer outBuffer, char aChar, boolean encodeBelow20) {
        boolean encode;
        boolean bl = encode = !StringEscape.isValidXmlCharset(aChar) || encodeBelow20 && aChar < ' ';
        if (encode) {
            outBuffer.append('\\');
            outBuffer.append('u');
            outBuffer.append(StringEscape.toHex(aChar >> 12 & 0xF));
            outBuffer.append(StringEscape.toHex(aChar >> 8 & 0xF));
            outBuffer.append(StringEscape.toHex(aChar >> 4 & 0xF));
            outBuffer.append(StringEscape.toHex(aChar & 0xF));
        } else {
            outBuffer.append(aChar);
        }
    }

    static boolean isValidXmlCharset(char c) {
        return c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff' || c == '\t' || c == '\n' || c == '\r';
    }

    public static void javaAndXMLEscape(String theString, char quoteChar, StringBuffer outBuffer) {
        if (theString == null) {
            outBuffer.append("null");
            return;
        }
        switch (quoteChar) {
            case '\'': {
                outBuffer.append('\'');
                break;
            }
            case '\"': {
                outBuffer.append("&quot;");
                break;
            }
        }
        int len = theString.length();
        for (int x = 0; x < len; ++x) {
            StringEscape.javaAndXMLEscape(theString.charAt(x), false, outBuffer);
        }
        switch (quoteChar) {
            case '\'': {
                outBuffer.append('\'');
                break;
            }
            case '\"': {
                outBuffer.append("&quot;");
                break;
            }
        }
    }

    public static void javaAndXMLEscape(char aChar, boolean quote, StringBuffer outBuffer) {
        if (quote) {
            outBuffer.append('\'');
        }
        switch (aChar) {
            case ' ': {
                outBuffer.append(' ');
                break;
            }
            case '\\': {
                outBuffer.append('\\');
                outBuffer.append('\\');
                break;
            }
            case '\t': {
                outBuffer.append('\\');
                outBuffer.append('t');
                break;
            }
            case '\'': {
                outBuffer.append('\\');
                outBuffer.append('\'');
                break;
            }
            case '\n': {
                outBuffer.append('\\');
                outBuffer.append('n');
                break;
            }
            case '\r': {
                outBuffer.append('\\');
                outBuffer.append('r');
                break;
            }
            case '\f': {
                outBuffer.append('\\');
                outBuffer.append('f');
                break;
            }
            case '&': {
                outBuffer.append("&amp;");
                break;
            }
            case '<': {
                outBuffer.append("&lt;");
                break;
            }
            case '>': {
                outBuffer.append("&gt;");
                break;
            }
            case '\"': {
                outBuffer.append('\\');
                outBuffer.append("&quot;");
                break;
            }
            default: {
                StringEscape.encodeUndefinedUnicodeChar(outBuffer, aChar);
            }
        }
        if (quote) {
            outBuffer.append('\'');
        }
    }

    public static String javaUnescape(String escString) {
        int len = escString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        for (int x = 0; x < len; ++x) {
            char aChar = escString.charAt(x);
            if (aChar == '\\') {
                char eChar = escString.charAt(++x);
                switch (eChar) {
                    case 't': {
                        outBuffer.append('\t');
                        break;
                    }
                    case 'n': {
                        outBuffer.append('\n');
                        break;
                    }
                    case 'r': {
                        outBuffer.append('\r');
                        break;
                    }
                    case 'f': {
                        outBuffer.append('\f');
                        break;
                    }
                    case 'u': {
                        int cv1 = StringEscape.fromHex(escString.charAt(++x)) << 12;
                        int cv2 = StringEscape.fromHex(escString.charAt(++x)) << 8;
                        int cv3 = StringEscape.fromHex(escString.charAt(++x)) << 4;
                        int cv4 = StringEscape.fromHex(escString.charAt(++x));
                        char cun = (char)(cv1 | cv2 | cv3 | cv4);
                        outBuffer.append(cun);
                        break;
                    }
                    default: {
                        int oc = StringEscape.isOctal(escString, x);
                        int ov = -1;
                        if (oc >= 0) {
                            ov = oc;
                            int o2 = StringEscape.isOctal(escString, x + 1);
                            if (o2 >= 0) {
                                int o3;
                                ov = oc << 3 | o2;
                                if (oc <= 3 && (o3 = StringEscape.isOctal(escString, ++x + 1)) >= 0) {
                                    ov = ov << 3 | o3;
                                    ++x;
                                }
                            }
                        }
                        outBuffer.append(ov >= 0 ? (char)ov : eChar);
                        break;
                    }
                }
                continue;
            }
            outBuffer.append(aChar);
        }
        return outBuffer.toString();
    }

    static int isOctal(String s, int idx) {
        char c;
        if (idx < s.length() && idx >= 0 && (c = s.charAt(idx)) >= '0' && c <= '7') {
            return c - 48;
        }
        return -1;
    }

    public static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    private static int fromHex(char c) {
        int v = c - 48;
        if (v >= 10) {
            v = c - 65 + 10;
        }
        return v;
    }
}

