/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.logging.AgitarLevel;
import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.util.BlackBox;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;

public class StreamCopier
extends Thread {
    private static int READSIZE;
    private static int WAITTIME;
    private static Logger log;
    private boolean dieNow = false;
    private InputStream is;
    private OutputStream os;
    private boolean close;
    private BlackBox blackBox = new BlackBox(1024);
    private static final char[] HEX;
    static final /* synthetic */ boolean $assertionsDisabled;

    public StreamCopier(InputStream i, OutputStream o, boolean c) {
        if (!$assertionsDisabled && i == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && o == null) {
            throw new AssertionError();
        }
        this.is = i;
        this.os = o;
        this.close = c;
        if (this.close) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        this.setName("StreamCopier " + i);
        this.start();
    }

    public void run() {
        block2: {
            try {
                this.copy(this.is, this.os, this.close);
            }
            catch (IOException ex) {
                if (this.dieNow) break block2;
                log.log(AgitarLevel.FINER, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(int delay) {
        StreamCopier streamCopier = this;
        synchronized (streamCopier) {
            this.dieNow = true;
            this.notify();
        }
        try {
            this.join(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(InputStream input, OutputStream output, boolean close) throws IOException {
        int numAvailable = 0;
        int readSize = 0;
        int zeroCnt = 0;
        byte[] buf = new byte[READSIZE];
        while (true) {
            if (numAvailable <= 0) {
                numAvailable = input.available();
            }
            if (numAvailable == 0) {
                if (this.dieNow && zeroCnt++ > 5) break;
                try {
                    StreamCopier streamCopier = this;
                    synchronized (streamCopier) {
                        this.wait(WAITTIME);
                    }
                }
                catch (Exception ignore) {}
                continue;
            }
            readSize = numAvailable > READSIZE ? READSIZE : numAvailable;
            numAvailable -= readSize;
            int read = input.read(buf, 0, readSize);
            output.write(buf, 0, read);
            output.flush();
            this.blackBox.put(buf, 0, readSize);
        }
        if (close) {
            input.close();
            output.close();
        } else {
            output.flush();
        }
    }

    public String getBlackBox() {
        return this.blackBox.toString();
    }

    static {
        $assertionsDisabled = !StreamCopier.class.desiredAssertionStatus();
        READSIZE = 1024;
        WAITTIME = 100;
        log = AgitarLogger.getDiagnosticLogger("runner");
        HEX = "0123456789ABCDEF".toCharArray();
    }
}

