/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.util.Assertions;
import com.agitar.common.util.IOUtility;
import java.io.IOException;
import java.io.InputStream;

public class StreamConcatenator
extends InputStream {
    public static final int EOF = -1;
    private InputStream[] streams;
    private int index;

    public StreamConcatenator(InputStream[] streams) {
        this.streams = streams;
        Assertions.assertNotNull("Null input stream array", streams);
    }

    public int read() throws IOException {
        int ch = -1;
        while (ch == -1) {
            if (this.index >= this.streams.length) {
                return -1;
            }
            ch = this.streams[this.index].read();
            if (ch != -1) continue;
            ++this.index;
        }
        return ch;
    }

    public void close() {
        for (int i = 0; i < this.streams.length; ++i) {
            IOUtility.close(this.streams[i], true);
        }
    }
}

