/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.InternalException;
import com.agitar.common.util.XMLUtility;
import com.agitar.common.util.XmlSTTGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Element;

public class SimpleTextTree {
    private static final char SEP = '/';
    public static final String WILDCARD = "*";
    public static final String TEXTNODE = "text()";
    public static final String ATTRNODEPREFIX = "@";
    private static HashMap compiledPaths = new HashMap();
    public String name = null;
    public String value = null;
    public SimpleTextTree parent = null;
    private SimpleTextTree[] children = null;
    private int index = -1;

    public SimpleTextTree(String name) {
        this.name = name;
    }

    public SimpleTextTree(String name, String val) {
        this.name = name;
        this.value = val;
    }

    public SimpleTextTree(String name, SimpleTextTree child) {
        this.name = name;
        this.children = new SimpleTextTree[]{child};
    }

    public SimpleTextTree(String name, String value, SimpleTextTree child) {
        this.name = name;
        this.value = value;
        this.children = new SimpleTextTree[]{child};
    }

    public SimpleTextTree(String name, SimpleTextTree[] children) {
        this.name = name;
        this.children = children;
    }

    public SimpleTextTree(String name, String value, SimpleTextTree[] children) {
        this.name = name;
        this.value = value;
        this.children = children;
    }

    int getIndex() {
        return this.index;
    }

    protected SimpleTextTree[] getChildrenWithTexts() {
        int n;
        int n2 = n = this.children == null ? 0 : this.children.length;
        if (this.value != null) {
            ++n;
        }
        SimpleTextTree[] c = new SimpleTextTree[n];
        if (this.children != null) {
            System.arraycopy(this.children, 0, c, 0, this.children.length);
        }
        if (this.value != null) {
            SimpleTextTree text = new SimpleTextTree(TEXTNODE, this.value);
            text.index = n - 1;
            text.parent = this;
            c[n - 1] = text;
        }
        return c;
    }

    public void addChild(SimpleTextTree nd) {
        if (nd == null) {
            return;
        }
        if (this.children == null) {
            this.children = new SimpleTextTree[]{nd};
            nd.index = 0;
        } else {
            int n = this.children.length;
            SimpleTextTree[] tmp = new SimpleTextTree[n + 1];
            System.arraycopy(this.children, 0, tmp, 0, n);
            tmp[n] = nd;
            this.children = tmp;
            nd.index = n;
        }
        nd.parent = this;
    }

    public void setChildren(SimpleTextTree[] c) {
        this.children = c;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.length > 0;
    }

    public boolean isAttribute() {
        return this.name.startsWith(ATTRNODEPREFIX);
    }

    public String getFullPath() {
        SimpleTextTree current = this;
        StringBuffer path = new StringBuffer();
        while (current != null) {
            path.insert(0, current.name + '/');
            current = current.parent;
        }
        return path.length() == 0 ? "" : path.substring(0, path.length() - 1);
    }

    public String[] getValues(String path) {
        SearchPath sp = SimpleTextTree.getSearchPath(path);
        SimpleTextTree[] tn = sp.search(this);
        if (tn == null || tn.length == 0) {
            return null;
        }
        int n = tn.length;
        String[] ret = new String[n];
        for (int i = 0; i < n; ++i) {
            SimpleTextTree txt;
            ret[i] = tn[i].value;
            if (this.value != null || (txt = tn[i].getFirstChild(TEXTNODE)) == null) continue;
            ret[i] = txt.value;
        }
        return ret;
    }

    public Element toElement() {
        if (this.isAttribute()) {
            return null;
        }
        try {
            String xml = XmlSTTGenerator.getXmlStr(this);
            ByteArrayInputStream input = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            InputStreamReader r = new InputStreamReader((InputStream)input, "UTF-8");
            return XMLUtility.parse(r).getDocumentElement();
        }
        catch (Exception e) {
            throw new InternalException("xml parse error:", e);
        }
    }

    public String getFirstValue(String path) {
        SimpleTextTree txt;
        SearchPath sp = SimpleTextTree.getSearchPath(path);
        SimpleTextTree[] tn = sp.search(this);
        if (tn == null || tn.length == 0) {
            return null;
        }
        String ret = tn[0].value;
        if (ret == null && (txt = tn[0].getFirstChild(TEXTNODE)) != null) {
            ret = txt.value;
        }
        return ret;
    }

    public SimpleTextTree[] getNodes(String path) {
        return SimpleTextTree.getSearchPath(path).search(this);
    }

    public SimpleTextTree getFirstNode(String path) {
        SearchPath sp = SimpleTextTree.getSearchPath(path);
        SimpleTextTree[] ns = sp.search(this);
        if (ns != null && ns.length > 0) {
            return ns[0];
        }
        return null;
    }

    public SimpleTextTree getFirstChild() {
        if (this.children == null || this.children.length == 0) {
            return null;
        }
        return this.children[0];
    }

    public SimpleTextTree[] getChildren() {
        return this.children;
    }

    public SimpleTextTree getFirstChild(String nName) {
        if (this.children == null || this.children.length == 0) {
            return null;
        }
        if (WILDCARD.equals(nName)) {
            return this.children[0];
        }
        for (int i = 0; i < this.children.length; ++i) {
            if (!this.children[i].name.equals(nName)) continue;
            return this.children[i];
        }
        return null;
    }

    public SimpleTextTree getFirstChild(String nName, String nVal) {
        if (this.children == null || this.children.length == 0) {
            return null;
        }
        if (WILDCARD.equals(nName) && WILDCARD.equals(nVal)) {
            return this.children[0];
        }
        for (int i = 0; i < this.children.length; ++i) {
            SimpleTextTree c = this.children[i];
            if (!nName.equals(c.name) && !WILDCARD.equals(nName)) continue;
            if (nVal.equals(c.value) || WILDCARD.equals(nVal)) {
                return c;
            }
            SimpleTextTree txt = c.getFirstChild(TEXTNODE);
            if (txt == null || !nVal.equals(txt.value)) continue;
            return c;
        }
        return null;
    }

    public SimpleTextTree[] getChildren(String nName) {
        if (WILDCARD.equals(nName)) {
            return this.children;
        }
        if (this.children != null) {
            ArrayList<SimpleTextTree> alist = new ArrayList<SimpleTextTree>(this.children.length);
            for (int i = 0; i < this.children.length; ++i) {
                if (!nName.equals(this.children[i].name)) continue;
                alist.add(this.children[i]);
            }
            return alist.toArray(new SimpleTextTree[alist.size()]);
        }
        return null;
    }

    public SimpleTextTree[] getChildren(String nName, String nVal) {
        if (this.children != null) {
            ArrayList<SimpleTextTree> alist = new ArrayList<SimpleTextTree>(this.children.length);
            for (int i = 0; i < this.children.length; ++i) {
                SimpleTextTree c = this.children[i];
                if (!nName.equals(c.name) && !WILDCARD.equals(nName)) continue;
                if (nVal.equals(c.value) || WILDCARD.equals(nVal)) {
                    alist.add(c);
                    continue;
                }
                SimpleTextTree txt = c.getFirstChild(TEXTNODE);
                if (txt == null || !nVal.equals(txt.value)) continue;
                alist.add(c);
            }
            return alist.toArray(new SimpleTextTree[alist.size()]);
        }
        return null;
    }

    public String toString() {
        return this.printGraph("", new HashSet());
    }

    String printGraph(String tab, Set visitedNodes) {
        StringBuffer sb = new StringBuffer(tab);
        if (visitedNodes.contains(this)) {
            sb.append("... cyclic node: ").append(this.name).append('\n');
            return sb.toString();
        }
        sb.append(this.name).append(" = ").append(this.value == null ? "~" : this.value).append('\n');
        visitedNodes.add(this);
        if (this.hasChildren()) {
            for (int i = 0; i < this.children.length; ++i) {
                sb.append(this.children[i].printGraph(tab + "|  ", visitedNodes));
            }
        }
        return sb.toString();
    }

    private static final SearchPath getSearchPath(String path) {
        SearchPath sp = (SearchPath)compiledPaths.get(path);
        if (sp == null) {
            sp = new SearchPath(path);
            compiledPaths.put(path, sp);
        }
        return sp;
    }

    private static class SearchPath {
        String[] pName = null;
        String[] pCName = null;
        String[] pCVal = null;
        private static final String WS = " \t\r\n";
        private static final String QT = "\"'";
        private static final String VALIDTAGCHAR = "-_@()*";
        private static final int _A = 65;
        private static final int _Z = 90;
        private static final int _a = 97;
        private static final int _z = 122;
        private static final int _0 = 48;
        private static final int _9 = 57;
        private static final int SELECT0 = 0;
        private static final int SELECT1 = 1;
        private static final int SELECT2 = 2;
        private static final int SELECT3 = 3;
        private static final int COND0 = 4;
        private static final int COND1 = 5;
        private static final int COND2 = 6;
        private static final int COND3 = 7;
        private static final int COND4 = 8;
        private static final int COND5 = 9;
        private static final int COND6 = 10;
        private String _path = null;

        public SearchPath(String path) {
            this._path = path;
            ArrayList<String> lpName = new ArrayList<String>();
            ArrayList<String> lpCName = new ArrayList<String>();
            ArrayList<String> lpCVal = new ArrayList<String>();
            int state = 0;
            int n = this._path.length();
            int beg = 0;
            char quote = '\"';
            block18: for (int i = 0; i < n; ++i) {
                char c = this._path.charAt(i);
                switch (state) {
                    case 0: {
                        if (this._isIn(c, WS)) continue block18;
                        if (c == '/') {
                            state = 1;
                            continue block18;
                        }
                        if (this._isValidTagChar(c)) {
                            state = 2;
                            beg = i;
                            continue block18;
                        }
                        this._throw(i, "Invalid char in select name");
                    }
                    case 1: {
                        if (this._isIn(c, WS)) continue block18;
                        if (c == '/') {
                            this._throw(i, "Empty select name not accepted");
                        }
                        if (this._isValidTagChar(c)) {
                            state = 2;
                            beg = i;
                            continue block18;
                        }
                        this._throw(i, "Invalid char in select name");
                    }
                    case 2: {
                        if (this._isValidTagChar(c)) continue block18;
                        if (this._isIn(c, WS)) {
                            state = 3;
                            lpName.add(this._path.substring(beg, i));
                            continue block18;
                        }
                        if (c == '[') {
                            state = 4;
                            lpName.add(this._path.substring(beg, i));
                            continue block18;
                        }
                        if (c == '/') {
                            state = 1;
                            lpName.add(this._path.substring(beg, i));
                            lpCName.add(null);
                            lpCVal.add(null);
                            continue block18;
                        }
                        this._throw(i, "Invalid char in select name");
                    }
                    case 3: {
                        if (this._isIn(c, WS)) continue block18;
                        if (c == '[') {
                            state = 4;
                            continue block18;
                        }
                        if (c == '/') {
                            state = 1;
                            continue block18;
                        }
                        this._throw(i, "Expecting '[', '/' or EOL");
                    }
                    case 4: {
                        if (this._isIn(c, WS)) continue block18;
                        if (!this._isValidTagChar(c)) {
                            this._throw(i, "Invalid char in condition name");
                        }
                        state = 5;
                        beg = i;
                        continue block18;
                    }
                    case 5: {
                        if (c == '=') {
                            state = 7;
                            lpCName.add(this._path.substring(beg, i));
                            continue block18;
                        }
                        if (this._isIn(c, WS)) {
                            state = 6;
                            lpCName.add(this._path.substring(beg, i));
                            continue block18;
                        }
                        if (c == ']') {
                            state = 10;
                            lpCName.add(this._path.substring(beg, i));
                            lpCVal.add(null);
                            continue block18;
                        }
                        if (this._isValidTagChar(c)) continue block18;
                        this._throw(i, "Invalid char in condition name");
                        continue block18;
                    }
                    case 6: {
                        if (this._isIn(c, WS)) continue block18;
                        if (c == ']') {
                            state = 10;
                            lpCVal.add(null);
                            continue block18;
                        }
                        if (c == '=') {
                            state = 7;
                            continue block18;
                        }
                        this._throw(i, "Expecting '=' or ']'");
                    }
                    case 7: {
                        if (this._isIn(c, WS)) continue block18;
                        if (this._isIn(c, QT)) {
                            state = 8;
                            quote = c;
                            beg = i + 1;
                            continue block18;
                        }
                        this._throw(i, "Expecting '\"' or \"'\"");
                    }
                    case 8: {
                        if (c != quote) continue block18;
                        state = 9;
                        lpCVal.add(this._path.substring(beg, i));
                        continue block18;
                    }
                    case 9: {
                        if (this._isIn(c, WS)) continue block18;
                        if (c == ']') {
                            state = 10;
                            continue block18;
                        }
                        this._throw(i, "Expecting ']'");
                    }
                    case 10: {
                        if (this._isIn(c, WS)) continue block18;
                        if (c == '/') {
                            state = 1;
                            continue block18;
                        }
                        this._throw(i, "Invalid char after ']'");
                    }
                }
            }
            switch (state) {
                case 2: {
                    lpName.add(this._path.substring(beg));
                    lpCName.add(null);
                    lpCVal.add(null);
                    break;
                }
                case 3: {
                    lpCName.add(null);
                    lpCVal.add(null);
                }
                case 1: 
                case 10: {
                    break;
                }
                default: {
                    this._throw(n - 1, "Unfinished statement");
                }
            }
            int size = lpName.size();
            if (size == 0) {
                this._throw(0, "Empty select name not accepted.");
            }
            this.pName = lpName.toArray(new String[size]);
            this.pCName = lpCName.toArray(new String[size]);
            this.pCVal = lpCVal.toArray(new String[size]);
            this._path = null;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.pCName.length; ++i) {
                sb.append(this.pName[i]).append(':');
                sb.append(this.pCName[i] != null ? this.pCName[i] : "null").append('=');
                sb.append(this.pCVal[i] != null ? this.pCVal[i] : "null");
                sb.append('|');
            }
            return sb.substring(0, sb.length() - 1);
        }

        private void _throw(int idx, String message) throws RuntimeException {
            throw new RuntimeException(message + " : " + this._path.substring(0, idx + 1) + "<-");
        }

        private boolean _isValidTagChar(char c) {
            return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || VALIDTAGCHAR.indexOf(c) != -1;
        }

        private boolean _isIn(char c, String s) {
            return s.indexOf(c) != -1;
        }

        private final boolean _matches(SimpleTextTree nd, int pathIdx) {
            if (nd.name.equals(this.pName[pathIdx]) || SimpleTextTree.WILDCARD.equals(this.pName[pathIdx])) {
                if (this.pCName[pathIdx] != null) {
                    if (this.pCVal[pathIdx] != null) {
                        if (this.pCName[pathIdx].equals(SimpleTextTree.TEXTNODE) && nd.value != null) {
                            return this.pCVal[pathIdx].equals(nd.value);
                        }
                        SimpleTextTree ch = nd.getFirstChild(this.pCName[pathIdx], this.pCVal[pathIdx]);
                        if (ch != null) {
                            return true;
                        }
                    } else {
                        if (this.pCName[pathIdx].equals(SimpleTextTree.TEXTNODE) && nd.value != null) {
                            return true;
                        }
                        if (nd.getFirstChild(this.pCName[pathIdx]) != null) {
                            return true;
                        }
                    }
                } else {
                    return true;
                }
            }
            return false;
        }

        private void _search(SimpleTextTree nd, ArrayList nodes, int i) {
            if (i == this.pName.length - 1 && this._matches(nd, i)) {
                nd = nd.name.equals(SimpleTextTree.TEXTNODE) ? nd.parent : nd;
                nodes.add(nd);
                return;
            }
            if (this._matches(nd, i)) {
                SimpleTextTree[] nds = nd.getChildren();
                if (nds != null && nds.length > 0) {
                    for (int k = 0; k < nds.length; ++k) {
                        this._search(nds[k], nodes, i + 1);
                    }
                } else if (i == this.pName.length - 2 && this.pName[i + 1].equals(SimpleTextTree.TEXTNODE) && nd.value != null) {
                    nodes.add(nd);
                }
            }
        }

        SimpleTextTree[] search(SimpleTextTree[] childSet) {
            ArrayList l = new ArrayList();
            for (int i = 0; i < childSet.length; ++i) {
                this._search(childSet[i], l, 0);
            }
            return l.toArray(new SimpleTextTree[l.size()]);
        }

        SimpleTextTree[] search(SimpleTextTree root) {
            if (root.hasChildren()) {
                return this.search(root.getChildren());
            }
            return null;
        }
    }
}

