/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.types.ClassName;
import java.util.Arrays;
import java.util.HashSet;

public final class RoommateUtility {
    private RoommateUtility() {
    }

    public static String[] findRoommateClasses(String className, String[] potentialRoomates, boolean inclItself, Filter exclude) {
        ClassName cont;
        HashSet<String> classes = new HashSet<String>();
        ClassName cn = ClassName.get(className);
        while ((cont = cn.getContainingClass()) != null) {
            cn = cont;
        }
        String baseName = cn.toString();
        if (potentialRoomates != null) {
            int index;
            for (int i = index = Arrays.binarySearch(potentialRoomates, baseName); i >= 0 && i < potentialRoomates.length && potentialRoomates[i].startsWith(baseName); ++i) {
                String name = potentialRoomates[i];
                int len = baseName.length();
                if (name.length() != len && name.charAt(len) != '$' && name.charAt(len) != '+' || exclude.exclude(name)) continue;
                classes.add(potentialRoomates[i]);
            }
            if (!inclItself) {
                classes.remove(className);
            }
        }
        return classes.toArray(new String[classes.size()]);
    }

    public static String[] findRoommateClasses(String className, String[] potentialRoomates, boolean inclItself) {
        Filter noExclusions = new Filter(){

            public boolean exclude(String className) {
                return false;
            }
        };
        return RoommateUtility.findRoommateClasses(className, potentialRoomates, inclItself, noExclusions);
    }

    public static interface Filter {
        public boolean exclude(String var1);
    }
}

