/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.util.IOUtility;
import java.io.File;

public class RelativeFile {
    private final String absoluteFile;
    private final String baseDir;

    public RelativeFile(File basedir, File absoluteLocation) {
        this(RelativeFile.getCanonicalPathNoBackslashes(basedir), RelativeFile.getCanonicalPathNoBackslashes(absoluteLocation));
    }

    private static String getCanonicalPathNoBackslashes(File file) {
        String canonical = IOUtility.getCanonicalPath(file);
        return RelativeFile.replaceBackSlashes(canonical);
    }

    private static String replaceBackSlashes(String canonical) {
        StringBuffer toReplaceSingleBackslashes = new StringBuffer(canonical);
        for (int i = 0; i < toReplaceSingleBackslashes.length(); ++i) {
            int previousslashes;
            if (toReplaceSingleBackslashes.charAt(i) != '\\' || i < toReplaceSingleBackslashes.length() - 1 && toReplaceSingleBackslashes.charAt(i + 1) == '\\' || (previousslashes = RelativeFile.countPreviousBackSlashes(toReplaceSingleBackslashes, i)) % 2 != 1) continue;
            toReplaceSingleBackslashes.setCharAt(i, '/');
        }
        return toReplaceSingleBackslashes.toString();
    }

    private static int countPreviousBackSlashes(StringBuffer toReplaceSingleBackslashes, int index) {
        int count = 0;
        for (int i = index; i > 0 && toReplaceSingleBackslashes.charAt(i) == '\\'; --i) {
            ++count;
        }
        return count;
    }

    public RelativeFile(String basedir, String absoluteLocation) {
        basedir = RelativeFile.replaceBackSlashes(basedir);
        absoluteLocation = RelativeFile.replaceBackSlashes(absoluteLocation);
        if (!basedir.endsWith("/")) {
            basedir = basedir + "/";
        }
        this.baseDir = basedir;
        this.absoluteFile = absoluteLocation;
    }

    public String getRelativePath() {
        if (this.isRelativizeable()) {
            return this.absoluteFile.substring(this.baseDir.length(), this.absoluteFile.length());
        }
        return this.absoluteFile;
    }

    public RelativeFile from(File absoluteLocation) {
        return new RelativeFile(this.absoluteFile, RelativeFile.getCanonicalPathNoBackslashes(absoluteLocation));
    }

    public boolean isRelativizeable() {
        return this.absoluteFile.startsWith(this.baseDir);
    }
}

