/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.util.ReflectionCache;
import com.agitar.common.util.WeakLookupReference;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class ReflectionCacheRegistry {
    private static final Set weakCaches = new HashSet();
    private static final Map caches = new IdentityHashMap();
    private static int cacheCount = 0;
    private static final Map threadToClassLoaders = new IdentityHashMap();

    public static synchronized void register(ReflectionCache cache) {
        caches.put(cache, "");
    }

    public static synchronized void registerWeak(ReflectionCache cache) {
        weakCaches.add(new WeakLookupReference(cache));
        if (++cacheCount > 500) {
            ReflectionCacheRegistry.cleanCache();
            cacheCount = 0;
        }
    }

    private static synchronized void cleanCache() {
        Iterator iterator = weakCaches.iterator();
        while (iterator.hasNext()) {
            WeakLookupReference ref = (WeakLookupReference)iterator.next();
            ReflectionCache cache = (ReflectionCache)ref.get();
            if (cache != null) continue;
            iterator.remove();
        }
    }

    public static synchronized void releaseAllReflection() {
        Iterator<Object> iterator = weakCaches.iterator();
        while (iterator.hasNext()) {
            WeakLookupReference ref = (WeakLookupReference)iterator.next();
            ReflectionCache cache = (ReflectionCache)ref.get();
            if (cache == null) {
                iterator.remove();
                continue;
            }
            cache.releaseReflection();
        }
        iterator = caches.keySet().iterator();
        while (iterator.hasNext()) {
            ReflectionCache cache = (ReflectionCache)iterator.next();
            cache.releaseReflection();
        }
    }

    public static synchronized ClassLoader getContextClassLoader() {
        return ReflectionCacheRegistry.getContextClassLoader(Thread.currentThread());
    }

    private static Stack getClassLoaderStack(Thread thread) {
        ClassLoaderHolder holder;
        Stack stack = (Stack)threadToClassLoaders.get(thread);
        if (stack == null) {
            stack = new Stack();
            threadToClassLoaders.put(thread, stack);
        }
        while (stack.size() > 0 && (holder = (ClassLoaderHolder)stack.peek()).getLoader() == null) {
            stack.pop();
        }
        return stack;
    }

    public static synchronized ClassLoader getContextClassLoader(Thread thread) {
        Stack classLoaders = ReflectionCacheRegistry.getClassLoaderStack(thread);
        if (classLoaders == null || classLoaders.size() == 0) {
            return thread.getContextClassLoader();
        }
        ClassLoader loader = ((ClassLoaderHolder)classLoaders.peek()).getLoader();
        if (loader == null) {
            loader = thread.getContextClassLoader();
        }
        return loader;
    }

    public static synchronized void pushContextClassLoader(Thread thread, ClassLoader loader) {
        AgitarLogger.getDiagnosticLogger("ReflectionCacheRegistry").info("pushing loader: " + loader);
        ClassLoader contextClassLoader = ReflectionCacheRegistry.getContextClassLoader(thread);
        Stack<ClassLoaderHolder> classLoaders = ReflectionCacheRegistry.getClassLoaderStack(thread);
        if (classLoaders == null) {
            classLoaders = new Stack<ClassLoaderHolder>();
            threadToClassLoaders.put(thread, classLoaders);
        }
        classLoaders.push(new ClassLoaderHolder(contextClassLoader, loader));
        if (loader != contextClassLoader) {
            ReflectionCacheRegistry.releaseAllReflection();
        }
        thread.setContextClassLoader(loader);
    }

    public static synchronized void pushContextClassLoader(ClassLoader loader) {
        ReflectionCacheRegistry.pushContextClassLoader(Thread.currentThread(), loader);
    }

    public static synchronized ClassLoader popContextClassLoader(Thread thread) {
        Stack classLoaders = ReflectionCacheRegistry.getClassLoaderStack(thread);
        if (classLoaders == null || classLoaders.size() == 0) {
            AgitarLogger.getDiagnosticLogger("ReflectionCacheRegistry").severe("Trying to pop classloader on empty stack: " + thread);
            return null;
        }
        ClassLoaderHolder previousLoader = (ClassLoaderHolder)classLoaders.pop();
        ClassLoader nextLoader = previousLoader.getContextLoader();
        if (classLoaders.size() > 0) {
            ClassLoaderHolder nextLoaderHolder = (ClassLoaderHolder)classLoaders.peek();
            while (classLoaders.size() > 0 && nextLoaderHolder.getLoader() == null) {
                nextLoaderHolder = (ClassLoaderHolder)classLoaders.pop();
            }
            nextLoader = nextLoaderHolder.getLoader();
        }
        if (nextLoader != previousLoader.getLoader()) {
            ReflectionCacheRegistry.releaseAllReflection();
        }
        thread.setContextClassLoader(nextLoader);
        AgitarLogger.getDiagnosticLogger("ReflectionCacheRegistry").info(thread + " Popping loader: " + previousLoader);
        return previousLoader.getLoader();
    }

    public static synchronized ClassLoader popContextClassLoader() {
        return ReflectionCacheRegistry.popContextClassLoader(Thread.currentThread());
    }

    static class ClassLoaderHolder {
        private final WeakLookupReference contextLoaderRef;
        private final WeakLookupReference loaderRef;

        public ClassLoaderHolder(ClassLoader contextLoader, ClassLoader loader) {
            this.contextLoaderRef = new WeakLookupReference(contextLoader);
            this.loaderRef = new WeakLookupReference(loader);
        }

        public ClassLoader getContextLoader() {
            return (ClassLoader)this.contextLoaderRef.get();
        }

        public ClassLoader getLoader() {
            return (ClassLoader)this.loaderRef.get();
        }
    }
}

