/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;

public class ReaderInputStream
extends InputStream {
    private static final String DEFAULT_ENCODING = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
    private Reader m_reader;
    private CharsetEncoder m_encoder;
    private final byte[] m_oneByteBuffer = new byte[1];
    private final char[] m_chars = new char[256];
    private CharBuffer m_charBuf = null;
    private int m_closingState = 0;

    public ReaderInputStream(Reader reader) {
        this.init(reader, DEFAULT_ENCODING);
    }

    public ReaderInputStream(Reader reader, String encoding) throws UnsupportedEncodingException {
        try {
            this.init(reader, encoding);
        }
        catch (IllegalCharsetNameException e) {
            throw new UnsupportedEncodingException(encoding);
        }
        catch (UnsupportedCharsetException e) {
            throw new UnsupportedEncodingException(encoding);
        }
    }

    private void init(Reader reader, String encoding) {
        if (reader == null) {
            throw new NullPointerException("null reader");
        }
        if (encoding == null) {
            throw new NullPointerException("null encoding");
        }
        this.m_reader = reader;
        this.m_encoder = Charset.forName(encoding).newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public synchronized void close() throws IOException {
        this.m_reader.close();
    }

    public synchronized int read() throws IOException {
        return this.read(this.m_oneByteBuffer, 0, 1) != -1 ? this.m_oneByteBuffer[0] & 0xFF : -1;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int pos;
        ByteBuffer byteBuf = ByteBuffer.wrap(b, off, len);
        while (byteBuf.remaining() > 0) {
            int read;
            if (this.m_charBuf == null || this.m_charBuf.remaining() == 0) {
                read = this.m_reader.read(this.m_chars, 0, this.m_chars.length);
                if (read == -1) {
                    if (this.m_closingState == 0 && this.m_encoder.encode(CharBuffer.allocate(0), byteBuf, true) != CoderResult.OVERFLOW) {
                        this.m_closingState = 1;
                    }
                    if (this.m_closingState != 1 || this.m_encoder.flush(byteBuf) == CoderResult.OVERFLOW) break;
                    this.m_encoder.reset();
                    this.m_closingState = 0;
                    break;
                }
                this.m_charBuf = CharBuffer.wrap(this.m_chars, 0, read);
            }
            this.m_encoder.encode(this.m_charBuf, byteBuf, false);
            if (this.m_charBuf.remaining() <= 0 || this.m_charBuf.position() == 0) continue;
            System.arraycopy(this.m_chars, this.m_charBuf.position(), this.m_chars, 0, this.m_chars.length - this.m_charBuf.position());
            read = this.m_reader.read(this.m_chars, this.m_charBuf.position(), this.m_chars.length - this.m_charBuf.position());
            this.m_charBuf = CharBuffer.wrap(this.m_chars, 0, this.m_charBuf.position() + (read != -1 ? read : 0));
        }
        return (pos = byteBuf.position()) != 0 ? pos : -1;
    }
}

