/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MultiMap {
    public static final MultiMap EMPTY_MULTI_MAP = new EmptyMultiMap();
    private final HashMap map = new HashMap();

    public int keyCount() {
        return this.map.size();
    }

    public void put(Object key, Object val) {
        Set s = this.get(key);
        if (s == null) {
            s = this.newSet();
            this.map.put(key, s);
        }
        s.add(val);
    }

    public boolean hasMapping(Object key, Object val) {
        Set set = this.get(key);
        if (set == null) {
            return false;
        }
        return set.contains(val);
    }

    public Set get(Object key) {
        return (Set)this.map.get(key);
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public void putAll(MultiMap m) {
        Iterator keyIter = m.keySet().iterator();
        while (keyIter.hasNext()) {
            Object key = keyIter.next();
            Set bucket = m.get(key);
            if (bucket == null) continue;
            Iterator bucketIter = bucket.iterator();
            while (bucketIter.hasNext()) {
                this.put(key, bucketIter.next());
            }
        }
    }

    public void putAll(Object key, Collection vals) {
        Set s = this.get(key);
        if (s == null) {
            s = this.newSet();
            this.map.put(key, s);
        }
        s.addAll(vals);
    }

    public Collection values() {
        ArrayList retval = new ArrayList();
        Iterator iter = this.map.values().iterator();
        while (iter.hasNext()) {
            retval.addAll((Collection)iter.next());
        }
        return retval;
    }

    public Set valuesAsSet() {
        HashSet retval = new HashSet();
        retval.addAll(this.values());
        return retval;
    }

    public boolean remove(Object key, Object val) {
        Set s = (Set)this.map.get(key);
        if (s == null) {
            return false;
        }
        return s.remove(val);
    }

    public Set removeKey(Object key) {
        return (Set)this.map.remove(key);
    }

    public Set removeValue(Object val) {
        HashSet retval = new HashSet();
        Iterator iter = this.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Set set = this.get(key);
            if (set == null || !set.remove(val)) continue;
            retval.add(key);
        }
        return retval;
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        int size = 0;
        Iterator iter = this.map.values().iterator();
        while (iter.hasNext()) {
            size += ((Collection)iter.next()).size();
        }
        return size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        return this.map.toString();
    }

    protected Set newSet() {
        return new HashSet();
    }

    private static final class EmptyMultiMap
    extends MultiMap {
        private EmptyMultiMap() {
        }

        public int keyCount() {
            return 0;
        }

        public void put(Object key, Object val) {
            throw new UnsupportedOperationException();
        }

        public boolean hasMapping(Object key, Object val) {
            return false;
        }

        public Set get(Object key) {
            return null;
        }

        public Set keySet() {
            return Collections.EMPTY_SET;
        }

        public void putAll(MultiMap m) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Object key, Collection vals) {
            throw new UnsupportedOperationException();
        }

        public Collection values() {
            return Collections.EMPTY_SET;
        }

        public Set valuesAsSet() {
            return Collections.EMPTY_SET;
        }

        public boolean remove(Object key, Object val) {
            return false;
        }

        public void clear() {
        }

        public int size() {
            return 0;
        }

        public boolean isEmpty() {
            return true;
        }
    }
}

