/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.diagnostics.Diagnostics;
import com.agitar.common.util.AgitarProperties;

public class Memory {
    private static final Runtime rt = Runtime.getRuntime();
    private static final long KILOBYTE = 1016L;
    private static final long K2M = 1024L;
    private static final long MEGABYTE = 1040384L;
    private static final long DEFAULT_MAX = 532676608L;

    public static long getAvailableM() {
        return Memory.getAvailableK() / 1024L;
    }

    public static long getFreeM() {
        return rt.freeMemory() / 1040384L;
    }

    public static long getUsedM() {
        return Memory.getTotalM() - Memory.getFreeM();
    }

    public static long getTotalM() {
        return rt.totalMemory() / 1040384L;
    }

    public static long getMaxM() {
        return Memory.getMaxK() / 1024L;
    }

    public static long getAvailableK() {
        return Memory.getMaxK() - Memory.getTotalK() + Memory.getFreeK();
    }

    public static long getFreeK() {
        return rt.freeMemory() / 1016L;
    }

    public static long getUsedK() {
        return Memory.getTotalK() - Memory.getFreeK();
    }

    public static long getTotalK() {
        return rt.totalMemory() / 1016L;
    }

    public static long getMaxK() {
        long max = rt.maxMemory();
        if (max == Long.MAX_VALUE) {
            max = 532676608L;
        } else if (!AgitarProperties.javaVersion(1, 4, 2) && max > 66584576L) {
            max -= 66584576L;
        }
        return max / 1016L;
    }

    public static void reportDiagnostics(String suffix) {
        Diagnostics.getKey("memory.used" + suffix).set(Memory.getUsedM());
        Diagnostics.getKey("memory.total" + suffix).set(Memory.getTotalM());
        Diagnostics.getKey("memory.max" + suffix).set(Memory.getMaxM());
        Diagnostics.getKey("memory.free" + suffix).set(Memory.getFreeM());
        Diagnostics.getKey("memory.available" + suffix).set(Memory.getAvailableM());
    }
}

