/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.AgitarException;
import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;

public final class JarFinder {
    public static String getContainingResource(Class claz) {
        String fullname = claz.getName();
        String cname = fullname.substring(fullname.lastIndexOf(46) + 1);
        URL url = claz.getResource(cname + ".class");
        if (url.getProtocol().startsWith("bundleresource")) {
            try {
                URLConnection conn = url.openConnection();
                url = (URL)conn.getClass().getMethod("getLocalURL", new Class[0]).invoke((Object)conn, new Object[0]);
            }
            catch (Throwable ex) {
                String msg = "Could not parse Eclipse classpath for url " + url.toExternalForm() + ": " + ex.getMessage();
                throw new AgitarException(msg);
            }
        }
        String s = null;
        if (url != null) {
            s = URLDecoder.decode(url.getFile());
            int index = s.indexOf(33);
            if (index > 0) {
                s = s.substring(0, index);
                s = s.replaceAll("^file:", "");
            } else {
                String resource = fullname.replace('.', '/') + ".class";
                index = s.indexOf(resource);
                String string = s = index > 0 ? s.substring(0, index) : null;
            }
            if (s != null) {
                s = new File(s).getAbsolutePath();
            }
        }
        return s;
    }

    public static String getContainingDir(Class claz) {
        String containingResource = JarFinder.getContainingResource(claz);
        if (containingResource == null) {
            return null;
        }
        if (new File(containingResource).isDirectory()) {
            return containingResource;
        }
        return new File(containingResource).getParent();
    }
}

