/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.util.AgitarProperties;
import com.agitar.security.AgPolicy;
import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedAction;

public class InitializationHelper {
    private InitializationHelper() {
    }

    public static void initializeSystemProperties() {
        System.setProperty("log4j.defaultInitOverride", "true");
        System.setProperty("log4j.rootLogger", "OFF");
        System.setProperty("org.apache.commons.logging.LogFactory", "org.agitar.mock.logging.MockLogFactory");
        System.setProperty("org.apache.commons.logging.Log", "org.agitar.mock.logging.MockLog");
        AgitarProperties.setUserProperty("log4j.defaultInitOverride", "true");
        AgitarProperties.setUserProperty("log4j.rootLogger", "OFF");
        AgitarProperties.setUserProperty("org.apache.commons.logging.LogFactory", "org.agitar.mock.logging.MockLogFactory");
        AgitarProperties.setUserProperty("org.apache.commons.logging.Log", "org.agitar.mock.logging.MockLog");
    }

    public static AgPolicy installAgSecurityPolicy() {
        AgPolicy agPolicy = AgPolicy.getAgitarOneSecurityPolicy();
        InitializationHelper.setPolicy(agPolicy);
        return agPolicy;
    }

    public static AgPolicy installJUnitSecurityPolicy() {
        AgPolicy agPolicy = AgPolicy.getJUnitSecurityPolicy();
        InitializationHelper.setPolicy(agPolicy);
        return agPolicy;
    }

    public static AgPolicy installTestGenSecurityPolicy() {
        AgPolicy agPolicy = AgPolicy.getTestGenSecurityPolicy();
        InitializationHelper.setPolicy(agPolicy);
        return agPolicy;
    }

    public static void uninstallSecurityPolicy() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Policy p = Policy.getPolicy();
                if (p instanceof AgPolicy) {
                    Policy.setPolicy(((AgPolicy)p).getPreviousPolicy());
                }
                return null;
            }
        });
    }

    private static void setPolicy(AgPolicy agPolicy) {
        AgPolicy.installPolicy(agPolicy);
    }
}

