/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.logging.AgitarLevel;
import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.util.AgitarProperties;
import com.agitar.common.util.StringUtility;
import com.agitar.common.util.UTF8FileReader;
import com.agitar.security.AgPolicy;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class IOUtility {
    public static final String D_TMP_DIRECTORY = "java.io.tmpdir";
    public static final String CHARSET_STR = "UTF-8";
    public static File[] NO_FILES;
    private static final int DATA_BLOCK_SIZE = 2048;
    public static final FileFilter ACCEPT_ALL_FILTER;
    private static final Logger LOG;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void copy(InputStream input, OutputStream output) throws IOException {
        if (!($assertionsDisabled || input != null && output != null)) {
            throw new AssertionError();
        }
        BufferedInputStream bis = new BufferedInputStream(input);
        BufferedOutputStream bos = new BufferedOutputStream(output);
        byte[] data = new byte[2048];
        int bCnt = bis.read(data, 0, 2048);
        while (bCnt > 0) {
            bos.write(data, 0, bCnt);
            bCnt = bis.read(data, 0, 2048);
        }
        bos.flush();
    }

    public static boolean isParentPath(File parentFile, File childFile) {
        IOUtility.assertNotNull(parentFile, "Parent File");
        IOUtility.assertNotNull(childFile, "Child File");
        String parentPath = IOUtility.getCanonicalPath(parentFile);
        String lowerParentPath = parentPath.toLowerCase();
        String childPath = IOUtility.getCanonicalPath(childFile);
        String lowerChildPath = childPath.toLowerCase();
        if (!AgitarProperties.isWindows()) {
            return childPath.indexOf(parentPath) >= 0;
        }
        return lowerChildPath.indexOf(lowerParentPath) >= 0;
    }

    public static File[] toFiles(String[] paths, boolean exist) {
        if (paths == null || paths.length == 0) {
            return NO_FILES;
        }
        if (!exist) {
            File[] ret = new File[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                ret[i] = new File(paths[i]);
            }
            return ret;
        }
        ArrayList<File> ret = new ArrayList<File>(paths.length);
        for (int i = 0; i < paths.length; ++i) {
            File f = new File(paths[i]);
            if (!f.exists()) continue;
            ret.add(f);
        }
        return ret.toArray(new File[ret.size()]);
    }

    public static String[] getLinesFromFile(File file, boolean ignoreBlankLine, boolean trim) throws IOException {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        return IOUtility.getLinesFromFile(new LineNumberReader(new FileReader(file)), ignoreBlankLine, trim);
    }

    public static String[] getLinesFromFile(LineNumberReader reader, boolean ignoreBlankLine, boolean trim) throws IOException {
        if (!$assertionsDisabled && reader == null) {
            throw new AssertionError();
        }
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            if (!ignoreBlankLine || line.length() > 0) {
                list.add(trim ? line.trim() : line);
            }
            line = reader.readLine();
        }
        IOUtility.close(reader, true);
        return StringUtility.strings(list);
    }

    public static File[] getAllFiles(File dir, FileFilter filter, boolean includingSubDir) {
        final ArrayList files = new ArrayList();
        Callback collectFiles = new Callback(){

            public boolean doAction(File f) {
                if (f.canRead()) {
                    files.add(f);
                }
                return true;
            }
        };
        if (includingSubDir) {
            IOUtility.traverse(dir, filter, collectFiles, false);
        } else {
            IOUtility.nonRecTraverse(dir, filter, collectFiles, false);
        }
        return files.toArray(new File[files.size()]);
    }

    public static boolean recursiveDelete(File dir) {
        if (dir == null) {
            LOG.fine("Recursive delete null?!");
            return false;
        }
        if (dir.isDirectory()) {
            File[] fs = dir.listFiles();
            LOG.fine("Recursive delete dir: " + dir + " (" + (fs == null ? 0 : fs.length) + " files)");
            boolean success = true;
            if (fs != null) {
                for (int i = 0; i < fs.length; ++i) {
                    success &= IOUtility.recursiveDelete(fs[i]);
                }
            }
            return success && (dir.delete() || IOUtility.renameAndDelete(dir));
        }
        if (dir.exists()) {
            return dir.delete() || IOUtility.renameAndDelete(dir);
        }
        return false;
    }

    private static boolean renameAndDelete(File dir) {
        File parent = dir.getParentFile();
        File deletable = new File(parent == null ? new File(".") : parent, "__deletable__");
        if (!dir.renameTo(deletable)) {
            LOG.fine("Rename and delete failed on rename: " + dir + " to " + deletable);
            return false;
        }
        if (!deletable.delete()) {
            LOG.fine("Rename and delete failed on delete: " + deletable);
            return false;
        }
        return true;
    }

    public static File replaceExtension(File file, String extension) {
        return new File(IOUtility.replaceExtension(file.toString(), extension));
    }

    public static String replaceExtension(String name, String extension) {
        int slash;
        int dot = name.lastIndexOf(46);
        String basePath = dot <= (slash = Math.max(name.lastIndexOf(47), name.lastIndexOf(File.separatorChar))) ? name : name.substring(0, dot);
        return StringUtility.cat(basePath, extension);
    }

    public static String getExtension(String name) {
        int dot = name.lastIndexOf(46);
        return dot < 0 ? "" : name.substring(dot);
    }

    public static long findNewest(File dir) {
        return IOUtility.findNewest(dir, ACCEPT_ALL_FILTER);
    }

    public static long findNewest(File dir, FileFilter filter) {
        File[] fs = dir.listFiles(filter);
        long newest = 0L;
        int len = fs == null ? 0 : fs.length;
        for (int i = 0; i < len; ++i) {
            File f = fs[i];
            newest = f.isDirectory() ? Math.max(newest, IOUtility.findNewest(f, filter)) : Math.max(newest, f.lastModified());
        }
        return newest;
    }

    public static void close(InputStream in, boolean ignoreException) {
        block3: {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException x) {
                    if (ignoreException) break block3;
                    throw new RuntimeException(x);
                }
            }
        }
    }

    public static void close(OutputStream out, boolean ignoreException) {
        block3: {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException x) {
                    if (ignoreException) break block3;
                    throw new RuntimeException(x);
                }
            }
        }
    }

    public static void close(Reader in, boolean ignoreException) {
        block3: {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException x) {
                    if (ignoreException) break block3;
                    throw new RuntimeException(x);
                }
            }
        }
    }

    public static void close(Writer out, boolean ignoreException) {
        block3: {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException x) {
                    if (ignoreException) break block3;
                    throw new RuntimeException(x);
                }
            }
        }
    }

    public static void close(Socket sock, boolean ignoreException) {
        block3: {
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (IOException x) {
                    if (ignoreException) break block3;
                    throw new RuntimeException(x);
                }
            }
        }
    }

    public static String createRelativePath(String from, String to) {
        int i;
        if (from == null || to == null) {
            return null;
        }
        File fromFile = new File(from);
        if (!fromFile.isAbsolute()) {
            return from;
        }
        from = IOUtility.getCanonicalPath(fromFile);
        File toFile = new File(to);
        to = IOUtility.getCanonicalPath(toFile);
        if (fromFile.isDirectory() && toFile.isDirectory() && from.equals(to)) {
            return ".";
        }
        if (!toFile.isFile()) {
            to = to + File.separatorChar;
        }
        int fromLength = from.length();
        int toLength = to.length();
        int lastCommonSeparator = 0;
        for (i = 0; i < fromLength && i < toLength && from.charAt(i) == to.charAt(i); ++i) {
            if (from.charAt(i) != File.separatorChar) continue;
            lastCommonSeparator = i == 1 && from.charAt(0) == File.separatorChar ? 0 : i;
        }
        if (i <= (AgitarProperties.isWindows() ? 3 : 1)) {
            return from;
        }
        from = from.substring(lastCommonSeparator + 1);
        to = to.substring(lastCommonSeparator + 1);
        String relPath = "";
        int p = 0;
        while ((p = to.indexOf(File.separatorChar, p)) != -1) {
            ++p;
            relPath = relPath + ".." + File.separatorChar;
        }
        return relPath + from;
    }

    public static String getCommonParent(File[] files) throws IOException {
        if (!($assertionsDisabled || files != null && files.length > 0)) {
            throw new AssertionError();
        }
        String[] names = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            files[i] = IOUtility.getCanonicalFile(file);
            if (file.isFile()) {
                file = IOUtility.getCanonicalFile(file.getParentFile());
            }
            names[i] = file.getAbsolutePath();
            if (names[i].endsWith(File.separator)) continue;
            int n = i;
            names[n] = names[n] + File.separator;
        }
        String commonRoot = names[0];
        for (int x = 1; x < names.length; ++x) {
            String name = names[x];
            commonRoot = IOUtility.getCommonParent(commonRoot, name);
        }
        return commonRoot;
    }

    public static String getCommonParent(String commonRoot, String name) throws IOException {
        int i;
        int fromLength = commonRoot.length();
        int toLength = name.length();
        int lastCommonSeparator = 0;
        for (i = 0; i < fromLength && i < toLength && commonRoot.charAt(i) == name.charAt(i); ++i) {
            if (commonRoot.charAt(i) != File.separatorChar) continue;
            lastCommonSeparator = i == 1 && commonRoot.charAt(0) == File.separatorChar ? 0 : i;
        }
        if (i <= 1) {
            throw new IOException("No common root");
        }
        commonRoot = commonRoot.substring(0, lastCommonSeparator + 1);
        return commonRoot;
    }

    public static File checkDirectory(String str) throws IOException {
        if (!$assertionsDisabled && StringUtility.nullOrEmpty(str)) {
            throw new AssertionError();
        }
        File tmp = new File(str);
        if (!tmp.exists()) {
            throw new IOException(str + " doesn't exist");
        }
        if (!tmp.isDirectory()) {
            throw new IOException(str + " is not a directory");
        }
        tmp = IOUtility.getCanonicalFile(tmp);
        return tmp;
    }

    public static void nonRecTraverse(File dir, FileFilter filter, Callback callback, boolean calldir) {
        File d = IOUtility.getCanonicalFile(dir);
        if (d.isDirectory()) {
            if (calldir) {
                callback.doAction(d);
            }
            List<Object> files = new ArrayList();
            File[] fs = d.listFiles(filter);
            if (fs != null) {
                files = Arrays.asList(fs);
            }
            int n = files.size();
            for (int i = 0; i < n; ++i) {
                File f = (File)files.get(i);
                if (f.isDirectory() && !calldir) continue;
                callback.doAction(f);
            }
        } else if (d.isFile()) {
            callback.doAction(d);
        }
    }

    public static void traverse(File dir, Callback callback) {
        IOUtility.traverse(dir, ACCEPT_ALL_FILTER, callback, false);
    }

    public static void traverse(File dir, FileFilter filter, Callback callback, boolean callDirectory) {
        File d = IOUtility.getCanonicalFile(dir.getAbsoluteFile());
        if (d.isDirectory()) {
            if (callDirectory) {
                callback.doAction(d);
            }
            HashSet<File> v = new HashSet<File>();
            v.add(d);
            IOUtility._traverse2(d, filter, v, callDirectory, callback);
        } else if (d.isFile()) {
            callback.doAction(d);
        }
    }

    private static boolean _traverse2(File dir, FileFilter filter, Set visited, boolean callDirectory, Callback callback) {
        File[] fs = dir.listFiles(filter);
        int len = fs == null ? 0 : fs.length;
        for (int i = 0; i < len; ++i) {
            File f = IOUtility.getCanonicalFile(fs[i].getAbsoluteFile());
            if (!visited.add(f.getPath())) continue;
            if (f.isFile()) {
                if (callback.doAction(f)) continue;
                return false;
            }
            if (!f.isDirectory()) continue;
            if (callDirectory && !callback.doAction(f)) {
                return false;
            }
            if (IOUtility._traverse2(f, filter, visited, callDirectory, callback)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to) throws IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        File dest = to.getParentFile();
        if (dest != null) {
            dest.mkdirs();
        }
        try {
            is = new FileInputStream(from);
            os = new FileOutputStream(to);
            FileChannel outChannel = os.getChannel();
            outChannel.transferFrom(is.getChannel(), 0L, is.getChannel().size());
        }
        catch (Throwable throwable) {
            IOUtility.close(is, true);
            IOUtility.close(os, true);
            throw throwable;
        }
        IOUtility.close(is, true);
        IOUtility.close(os, true);
    }

    public static void copyRecurse(File from, File to) throws IOException {
        if (from.isFile()) {
            IOUtility.copyFile(from, to);
            return;
        }
        to.mkdirs();
        File[] fromChildren = from.listFiles();
        int len = fromChildren == null ? 0 : fromChildren.length;
        for (int i = 0; i < len; ++i) {
            IOUtility.copyRecurse(fromChildren[i], new File(to, fromChildren[i].getName()));
        }
    }

    public static void copyDirectoryNoRecurse(File from, File to) throws IOException {
        to.mkdirs();
        File[] fromChildren = from.listFiles();
        int len = fromChildren == null ? 0 : fromChildren.length;
        for (int i = 0; i < len; ++i) {
            if (!fromChildren[i].isFile()) continue;
            IOUtility.copyFile(fromChildren[i], new File(to, fromChildren[i].getName()));
        }
    }

    private static void assertNotNull(Object o, String desc) {
        if (o == null) {
            throw new IllegalArgumentException(desc + " cannot be null!");
        }
    }

    public static String getCanonicalPath(String path) {
        IOUtility.assertNotNull(path, "Path");
        if (AgitarProperties.isWindows()) {
            try {
                return new File(path).getCanonicalPath();
            }
            catch (IOException x) {
                return new File(path).getAbsolutePath();
            }
        }
        return IOUtility.getCanonicalPathNL(path, File.separatorChar);
    }

    public static boolean isSameFile(File a, File b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return IOUtility.getCanonicalPath(a).equals(IOUtility.getCanonicalPath(b));
    }

    public static String getCanonicalPath(File file) {
        IOUtility.assertNotNull(file, "File");
        if (AgitarProperties.isWindows()) {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException x) {
                return file.getAbsolutePath();
            }
        }
        return IOUtility.getCanonicalPathNL(file.getPath(), File.separatorChar);
    }

    private IOUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyToTextFile(InputStream is, File toFile) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        BufferedWriter writer;
        block7: {
            writer = null;
            BufferedReader reader = null;
            try {
                File p = toFile.getParentFile();
                if (p != null) {
                    p.mkdirs();
                }
                reader = new BufferedReader(new InputStreamReader(is, CHARSET_STR));
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(toFile), CHARSET_STR));
                char[] buf = new char[2048];
                int read = -1;
                while ((read = reader.read(buf)) != -1) {
                    writer.write(buf, 0, read);
                }
                Object var8_7 = null;
                if (reader == null) break block7;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
                throw throwable;
            }
            reader.close();
        }
        if (writer != null) {
            writer.close();
        }
    }

    public static String canonicalizePath(String path, File baseDir) {
        return IOUtility.canonicalizePath(path, baseDir, File.pathSeparatorChar);
    }

    public static String canonicalizePath(String path, File baseDir, char separator) {
        String[] paths = path.split(String.valueOf(separator));
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < paths.length; ++i) {
            String p = paths[i];
            if (StringUtility.nullOrEmpty(p)) continue;
            File f = new File(p);
            if (f.isAbsolute()) {
                sb.append(IOUtility.getCanonicalFile(f)).append(separator);
                continue;
            }
            f = new File(baseDir, f.getPath());
            sb.append(IOUtility.getCanonicalFile(f)).append(separator);
        }
        int n = sb.length();
        return n > 0 ? sb.substring(0, n - 1) : "";
    }

    public static File getCanonicalFile(File f) {
        IOUtility.assertNotNull(f, "File");
        if (AgitarProperties.isWindows()) {
            try {
                return f.getCanonicalFile();
            }
            catch (IOException x) {
                return f.getAbsoluteFile();
            }
        }
        return new File(IOUtility.getCanonicalPathNL(f.getPath(), File.separatorChar));
    }

    public static File getFile(final Class c) {
        return (File)AgPolicy.doPrivilegedAction(new PrivilegedAction(){

            public Object run() {
                String className = c.getName().replace('.', '/') + ".class";
                URL url = c.getClassLoader() == null ? ClassLoader.getSystemResource(className) : c.getClassLoader().getResource(className);
                return IOUtility.getFile(url, className);
            }
        });
    }

    public static File getFile(final URL urltoget, final String resource) {
        return (File)AgPolicy.doPrivilegedAction(new PrivilegedAction(){

            public Object run() {
                String s = null;
                URL url = urltoget;
                if (url != null) {
                    int index;
                    if (url.getProtocol().startsWith("bundleresource")) {
                        try {
                            URLConnection conn = url.openConnection();
                            url = (URL)conn.getClass().getMethod("getLocalURL", new Class[0]).invoke((Object)conn, new Object[0]);
                        }
                        catch (Throwable ex) {
                            LOG.log(AgitarLevel.WARNING, "Could not parse Eclipse classpath for url " + url.toExternalForm() + ": " + ex.getMessage());
                        }
                    }
                    if ((index = (s = url.getFile()).indexOf(33)) > 0) {
                        s = s.substring(0, index);
                        s = s.replaceAll("^file:", "");
                    } else {
                        index = s.indexOf(resource);
                        String string = s = index > 0 ? s.substring(0, index) : null;
                    }
                    if (s != null) {
                        s = URLDecoder.decode(s);
                        s = new File(s).getAbsolutePath();
                    }
                }
                if (s == null) {
                    return null;
                }
                return new File(s);
            }
        });
    }

    static String getCanonicalPathNL(String path, char fileSep) {
        int i;
        if (path == null || path.length() == 0) {
            return path;
        }
        if (path.charAt(0) != fileSep) {
            path = new File(path).getAbsolutePath();
        }
        SStack st = new SStack();
        char[] chars = path.toCharArray();
        int last = 0;
        int n = chars.length;
        for (i = 0; i < n; ++i) {
            char c = chars[i];
            if (c != fileSep) continue;
            if (i > last) {
                int len = i - last;
                char cc = chars[last];
                if (len != 1 || cc != '.') {
                    if (len == 2 && chars[last + 1] == '.') {
                        st.pop();
                    } else {
                        st.push(chars, last, len);
                    }
                }
            }
            last = i + 1;
        }
        if (i > last) {
            int len = i - last;
            char c = chars[last];
            if (len != 1 || c != '.') {
                if (len == 2 && c == '.' && chars[last + 1] == '.') {
                    st.pop();
                } else {
                    st.push(chars, last, len);
                }
            }
        }
        return fileSep + st.getString(fileSep);
    }

    public static File getCanonicalFile(String fname) {
        IOUtility.assertNotNull(fname, "path");
        if (AgitarProperties.isWindows()) {
            File f = new File(fname);
            try {
                return f.getCanonicalFile();
            }
            catch (IOException x) {
                return f.getAbsoluteFile();
            }
        }
        return new File(IOUtility.getCanonicalPathNL(fname, File.separatorChar));
    }

    public static byte[] whole(File file) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        int len = (int)raf.length();
        byte[] ret = new byte[len];
        raf.readFully(ret);
        raf.close();
        return ret;
    }

    public static void writeFile(byte[] bytes, File file) throws IOException {
        IOUtility.writeFile(new ByteArrayInputStream(bytes), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeFile(InputStream inputStream, File file) throws IOException {
        block4: {
            if (inputStream == null) {
                return;
            }
            file.getAbsoluteFile().getParentFile().mkdirs();
            BufferedOutputStream fos = null;
            try {
                fos = new BufferedOutputStream(new FileOutputStream(file));
                IOUtility.copy(inputStream, fos);
                if (fos == null) break block4;
            }
            catch (Throwable throwable) {
                if (fos != null) {
                    IOUtility.close(fos, true);
                }
                throw throwable;
            }
            IOUtility.close(fos, true);
        }
        inputStream.close();
    }

    public static File[] getAllFilesWithExtension(File directory, final String extension, final boolean includeSubDir) {
        if (!$assertionsDisabled && StringUtility.nullOrEmpty(extension)) {
            throw new AssertionError();
        }
        return IOUtility.getAllFiles(directory, new FileFilter(){

            public boolean accept(File pathname) {
                return includeSubDir && pathname.isDirectory() || pathname.getName().endsWith(extension);
            }
        }, includeSubDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadBytesFromURL(URLConnection con) throws IOException {
        InputStream in = null;
        try {
            int count;
            in = con.getInputStream();
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((count = in.read(buf)) > 0) {
                bo.write(buf, 0, count);
            }
            byte[] byArray = bo.toByteArray();
            return byArray;
        }
        finally {
            IOUtility.close(in, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileAsBytes(File f) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileInputStream in = new FileInputStream(f);
        try {
            IOUtility.copy(in, out);
        }
        finally {
            in.close();
            out.close();
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsUTF8(File f) throws IOException {
        UTF8FileReader reader = new UTF8FileReader(f);
        char[] buf = new char[4096];
        int count = 0;
        StringWriter writer = new StringWriter();
        try {
            while ((count = reader.read(buf)) > 0) {
                writer.write(buf, 0, count);
            }
        }
        finally {
            reader.close();
        }
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(InputStream input) throws IOException {
        InputStreamReader reader = new InputStreamReader(input);
        char[] buf = new char[4096];
        int count = 0;
        StringWriter writer = new StringWriter();
        try {
            while ((count = reader.read(buf)) > 0) {
                writer.write(buf, 0, count);
            }
        }
        finally {
            input.close();
        }
        return writer.toString();
    }

    public static String[] toCanonicalPaths(File[] path) {
        String[] canonicalPaths = new String[path.length];
        for (int i = 0; i < canonicalPaths.length; ++i) {
            canonicalPaths[i] = IOUtility.getCanonicalPath(path[i]);
        }
        return canonicalPaths;
    }

    public static String[] toCanonicalPaths(String[] relativePaths) {
        String[] canonicalPaths = new String[relativePaths.length];
        for (int i = 0; i < canonicalPaths.length; ++i) {
            canonicalPaths[i] = IOUtility.getCanonicalPath(relativePaths[i]);
        }
        return canonicalPaths;
    }

    public static void unzipAll(File baseDir, ZipFile zipFile) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File file = new File(baseDir, entry.getName());
            if (entry.isDirectory()) {
                file.mkdirs();
                continue;
            }
            file.getParentFile().mkdirs();
            IOUtility.writeFile(zipFile.getInputStream(entry), file);
        }
    }

    static {
        $assertionsDisabled = !IOUtility.class.desiredAssertionStatus();
        NO_FILES = new File[0];
        ACCEPT_ALL_FILTER = new FileFilter(){

            public boolean accept(File pathname) {
                return true;
            }
        };
        LOG = AgitarLogger.getDiagnosticLogger("ioutility");
    }

    private static class LinkedElement {
        final char[] el;
        LinkedElement nx;
        LinkedElement pv;

        LinkedElement(char[] s, LinkedElement p) {
            this.el = s;
            this.pv = p;
        }
    }

    private static class SStack {
        private LinkedElement head;
        private LinkedElement last;

        private SStack() {
        }

        void push(char[] c, int offset, int len) {
            char[] newc = new char[len];
            System.arraycopy(c, offset, newc, 0, len);
            this.last = this.last != null ? (this.last.nx = new LinkedElement(newc, this.last)) : (this.head = new LinkedElement(newc, null));
        }

        void pop() {
            if (this.last != null) {
                if (this.last.pv != null) {
                    this.last.pv.nx = null;
                } else {
                    this.head = null;
                }
                this.last = this.last.pv;
            }
        }

        String getString(char delimiter) {
            LinkedElement l = this.head;
            StringBuffer sb = new StringBuffer(256);
            while (l != null) {
                sb.append(l.el).append(delimiter);
                l = l.nx;
            }
            int n = sb.length();
            if (n > 0) {
                sb.deleteCharAt(n - 1);
            }
            return sb.toString();
        }
    }

    public static interface Callback {
        public boolean doAction(File var1);
    }

    public static class RegexFileFilter
    implements FileFilter {
        private Pattern pattern;

        public RegexFileFilter(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        public RegexFileFilter(String regex, int pattern) {
            this.pattern = Pattern.compile(regex, pattern);
        }

        public boolean accept(File arg0) {
            if (arg0.isDirectory()) {
                return true;
            }
            return this.pattern.matcher(arg0.getName()).matches();
        }
    }
}

