/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.logging.AgitarLogger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class GUID {
    static final String PREFERENCE_NODE = "com/agitar/agitator/licencekey";
    private String guid;

    public GUID(String id) {
        if (id == null) {
            this.generate();
        } else {
            this.guid = id;
        }
    }

    private void generate() {
        MessageDigest md5;
        StringBuffer sbValueBeforeMD5 = new StringBuffer();
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("could not create GUID", e);
        }
        try {
            long time = System.currentTimeMillis();
            long rand = new Random().nextLong();
            sbValueBeforeMD5.append(":");
            sbValueBeforeMD5.append(Long.toString(time));
            sbValueBeforeMD5.append(":");
            sbValueBeforeMD5.append(Long.toString(rand));
        }
        catch (Exception e) {
            AgitarLogger.getDiagnosticLogger("UID").log(Level.WARNING, "Error generating UID", e);
        }
        String valueBeforeMD5 = sbValueBeforeMD5.toString();
        md5.update(valueBeforeMD5.getBytes());
        byte[] array = md5.digest();
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < array.length; ++j) {
            int b = array[j] & 0xFF;
            if (b < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(b));
        }
        this.guid = sb.toString().toUpperCase();
    }

    public String toString() {
        return this.guid;
    }

    public static GUID fromRegistry(String location) {
        Preferences pref = Preferences.userRoot().node(PREFERENCE_NODE);
        try {
            pref.flush();
        }
        catch (BackingStoreException x) {
            // empty catch block
        }
        String id = pref.get(location, null);
        GUID guid = new GUID(id);
        if (id == null) {
            pref.put(location, guid.toString());
        }
        return guid;
    }

    public static GUID fromString(String id) {
        return new GUID(id);
    }
}

