/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.AgitarException;
import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.util.NoTestFoundException;
import com.agitar.common.util.StringUtility;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.SocketException;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.xml.sax.SAXParseException;

public class ExceptionUtility {
    private static final String CAUSED_BY = "Caused by: ";
    private static final Pattern stackTraceRegex;
    public static String RUNTIME_EXCEPTION_MESSAGE;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ExceptionUtility() {
    }

    public static Throwable createThrowable(String stackTraceStr) {
        if (StringUtility.nullOrEmpty(stackTraceStr)) {
            return new Exception("no trace.");
        }
        int stBegin = stackTraceStr.indexOf("\tat");
        String xStr = stackTraceStr;
        String[] xTrace = null;
        Throwable cause = null;
        if (stBegin != -1) {
            xStr = stackTraceStr.substring(0, stBegin);
            int causeIdx = stackTraceStr.indexOf(CAUSED_BY, stBegin);
            int stEnd = stackTraceStr.length();
            if (causeIdx != -1) {
                stEnd = causeIdx;
                cause = ExceptionUtility.createThrowable(stackTraceStr.substring(causeIdx + CAUSED_BY.length()));
            }
            xTrace = stackTraceStr.substring(stBegin, stEnd).split("\\n");
        }
        Throwable t = ExceptionUtility._guessThrowableInstance(xStr);
        if (cause != null) {
            try {
                t.initCause(cause);
            }
            catch (IllegalStateException e) {
                AgitarLogger.getDiagnosticLogger("exceptionUtil").warning("error re-constructing exception\n" + stackTraceStr);
            }
        }
        ArrayList<StackTraceElement> stList = new ArrayList<StackTraceElement>();
        if (xTrace != null) {
            for (int i = 0; i < xTrace.length; ++i) {
                StackTraceElement el = ExceptionUtility._makeStackTrace((String)xTrace[i]);
                if (el == null) continue;
                stList.add(el);
            }
        }
        int n = stList.size();
        StackTraceElement[] stackTraceElements = stList.toArray(new StackTraceElement[n]);
        t.setStackTrace(stackTraceElements);
        return t;
    }

    static StackTraceElement _makeStackTrace(String stLine) {
        Matcher m;
        if (!StringUtility.nullOrEmpty(stLine) && (m = stackTraceRegex.matcher(stLine)).find()) {
            String declaringClass = m.group(1);
            String method = m.group(2);
            String javaFile = m.group(3);
            boolean isNativeMethod = "Native Method".equals(javaFile);
            int lineNumber = isNativeMethod ? -2 : -1;
            try {
                String ln = m.group(5);
                lineNumber = Integer.parseInt(ln);
            }
            catch (Exception x) {
                // empty catch block
            }
            try {
                Class stClass = StackTraceElement.class;
                Constructor stCons = stClass.getDeclaredConstructor(new Class[0]);
                stCons.setAccessible(true);
                StackTraceElement st = (StackTraceElement)stCons.newInstance(new Object[0]);
                Field classField = stClass.getDeclaredField("declaringClass");
                classField.setAccessible(true);
                classField.set(st, declaringClass);
                Field methodField = stClass.getDeclaredField("methodName");
                methodField.setAccessible(true);
                methodField.set(st, method);
                Field fileField = stClass.getDeclaredField("fileName");
                fileField.setAccessible(true);
                fileField.set(st, javaFile);
                Field lineNumField = stClass.getDeclaredField("lineNumber");
                lineNumField.setAccessible(true);
                lineNumField.setInt(st, lineNumber);
                return st;
            }
            catch (Exception x) {
                return null;
            }
        }
        return null;
    }

    static Throwable _guessThrowableInstance(String string) {
        Throwable t;
        int i;
        string = string.trim();
        char[] chars = string.toCharArray();
        for (i = 0; i < chars.length && (chars[i] == '.' || Character.isJavaIdentifierPart(chars[i])); ++i) {
        }
        String cname = string.substring(0, i);
        try {
            Class<?> claz = Class.forName(cname);
            String message = string.substring(i).trim();
            if (message.length() > 0) {
                message = message.replaceFirst("^: ", "");
                message = message.replaceFirst("^:", "");
                Constructor<?> contructor = claz.getConstructor(String.class);
                t = (Throwable)contructor.newInstance(message);
            } else {
                t = (Throwable)claz.newInstance();
            }
        }
        catch (Exception x) {
            t = new Exception(string);
        }
        return t;
    }

    public static String finiteTrace(Throwable t) {
        return ExceptionUtility.finiteTrace(t, true);
    }

    public static String finiteTrace(Throwable t, boolean keepall) {
        HashSet<Throwable> visited = new HashSet<Throwable>();
        StringBuffer sb = new StringBuffer(512);
        sb.append(t).append('\n');
        StackTraceElement[] trace = t.getStackTrace();
        if (trace == null) {
            return sb.append("\tNo stacktrace").toString();
        }
        for (int i = 0; i < trace.length; ++i) {
            if (!keepall && !StringUtility.keepTrace(trace[i], false)) continue;
            sb.append("\tat ").append(trace[i]).append('\n');
        }
        visited.add(t);
        Throwable cause = t.getCause();
        if (cause != null) {
            ExceptionUtility._causeTrace(sb, visited, trace, cause, keepall);
        }
        return sb.toString();
    }

    private static void _causeTrace(StringBuffer sb, HashSet visited, StackTraceElement[] origTrace, Throwable cause, boolean keepall) {
        Throwable nextCause;
        if (!($assertionsDisabled || cause != null && origTrace != null)) {
            throw new AssertionError();
        }
        sb.append(CAUSED_BY).append(cause).append('\n');
        if (visited.contains(cause)) {
            sb.append("\tTrace cycle back to: ").append(cause).append(" ...");
            return;
        }
        visited.add(cause);
        StackTraceElement[] causeTrace = cause.getStackTrace();
        int m = causeTrace.length - 1;
        for (int n = origTrace.length - 1; m >= 0 && n >= 0 && origTrace[n].equals(causeTrace[m]); --m, --n) {
        }
        int framesInCommon = causeTrace.length - 1 - m;
        for (int i = 0; i <= m; ++i) {
            if (!keepall && !StringUtility.keepTrace(causeTrace[i], false)) continue;
            sb.append("\tat ").append(causeTrace[i]).append('\n');
        }
        if (framesInCommon != 0) {
            sb.append("\t... ").append(framesInCommon).append(" more\n");
        }
        if ((nextCause = cause.getCause()) != null) {
            ExceptionUtility._causeTrace(sb, visited, causeTrace, nextCause, keepall);
        }
    }

    public static void retrieveFactoryStackTrace(ArrayList stackList, Throwable e, boolean cleanStackTrace, int recursionCount) {
        if (recursionCount > 20) {
            stackList.add("--------------------------");
            stackList.add("<trace terminated due to recursion depth>");
            return;
        }
        if (recursionCount > 0) {
            stackList.add(" ");
        }
        stackList.add(recursionCount > 0 ? CAUSED_BY + e.getClass().getName() : "Exception: " + e.getClass().getName() + " " + e.getMessage());
        stackList.add(e.getMessage());
        stackList.add("--------------------------");
        Object[] stack = cleanStackTrace ? StringUtility.cleanStackTraceAsArray(e, true) : e.getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            stackList.add(stack[i].toString());
        }
        if (e.getCause() != null) {
            ExceptionUtility.retrieveFactoryStackTrace(stackList, e.getCause(), cleanStackTrace, recursionCount + 1);
        }
    }

    public static void retrieveStackTrace(ArrayList stackList, Throwable e, boolean cleanStackTrace, int recursionCount) {
        if (recursionCount > 20) {
            stackList.add("--------------------------");
            stackList.add("<trace terminated due to recursion depth>");
            return;
        }
        if (recursionCount > 0) {
            stackList.add(" ");
        }
        stackList.add(recursionCount > 0 ? CAUSED_BY + e.getClass().getName() : "Exception: " + e.getClass().getName() + " " + e.getMessage());
        stackList.add("--------------------------");
        Object[] stack = cleanStackTrace ? StringUtility.split(StringUtility.cleanTrace(e), StringUtility.nl) : e.getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            stackList.add(stack[i].toString());
        }
        if (e.getCause() != null) {
            ExceptionUtility.retrieveStackTrace(stackList, e.getCause(), cleanStackTrace, recursionCount + 1);
        }
    }

    public static void checkDeclaredException(Method method, Throwable e, String msg) throws Throwable {
        Class<?> caught;
        Class<?>[] allowableExceptions = method.getExceptionTypes();
        if (RuntimeException.class.isAssignableFrom(caught = e.getClass()) || Error.class.isAssignableFrom(caught)) {
            throw e;
        }
        for (int i = 0; i < allowableExceptions.length; ++i) {
            Class<?> clz = allowableExceptions[i];
            if (!clz.isAssignableFrom(caught)) continue;
            throw e;
        }
        throw new UndeclaredThrowableException(e, msg);
    }

    public static String getMessageFromThrowable(Throwable t) {
        String message;
        if (t instanceof InvocationTargetException && t.getCause() != null) {
            t = t.getCause();
        }
        if (StringUtility.nullOrEmpty(message = t.getMessage())) {
            message = t.getClass().toString();
        }
        if (t instanceof SAXParseException) {
            SAXParseException s = (SAXParseException)t;
            message = t.getMessage() + "\n\nFile: \"" + s.getSystemId() + "\"  (line " + s.getLineNumber() + ")";
        } else if (t.getClass().getName().endsWith("SemanticException")) {
            message = "Semantic Error: " + message;
        } else if (t.getClass().getName().endsWith("ParseException")) {
            message = "Syntax Error: " + message;
        } else if (t.getClass().getName().endsWith("LicenseException")) {
            message = "Agitator License Error: " + message;
        } else if (t instanceof NumberFormatException) {
            message = "Number Format Error: " + message;
        } else if (t instanceof UnsupportedEncodingException || t instanceof IllegalCharsetNameException || t instanceof UnsupportedCharsetException) {
            message = "Unsupported text encoding: " + message;
        } else if (t instanceof SocketException) {
            message = "Networking Error: " + message;
        } else if (t instanceof IOException) {
            message = "IOException: " + message;
        } else if (t instanceof NoSuchMethodException) {
            message = "No such method: " + message;
        } else if (t instanceof ClassNotFoundException) {
            message = "Class not found: " + message;
        } else if (t instanceof CannotUndoException) {
            message = t.getCause() != null ? "Cannot Undo: " + ExceptionUtility.getMessageFromThrowable(t.getCause()) : "Cannot undo.";
        } else if (t instanceof NoTestFoundException) {
            message = "Error running tests: " + t.getMessage();
        } else if (t instanceof CannotRedoException) {
            message = t.getCause() != null ? "Cannot Redo: " + ExceptionUtility.getMessageFromThrowable(t.getCause()) : "Cannot redo.";
        } else if ((t instanceof RuntimeException || t instanceof AssertionError) && !(t instanceof AgitarException)) {
            boolean isSpecialCase = false;
            if (t instanceof IllegalStateException) {
                StackTraceElement[] elements = t.getStackTrace();
                for (int i = 0; i < elements.length && i < 10; ++i) {
                    if (elements[i].isNativeMethod() && elements[i].getClassName().indexOf("SunClipboard") >= 0) continue;
                    isSpecialCase = true;
                    break;
                }
            }
            if (!isSpecialCase) {
                message = t instanceof NullPointerException ? RUNTIME_EXCEPTION_MESSAGE + "\n(" + "Null pointer exception.)" : RUNTIME_EXCEPTION_MESSAGE + "\n(" + t.getClass().getName() + ": " + message + ")";
            }
        }
        if (t.getCause() != null) {
            if (message.startsWith(RUNTIME_EXCEPTION_MESSAGE)) {
                message = message + "\n(" + t.getCause().toString() + ")";
            } else if (t.getCause().getMessage() != null && !t.getCause().getMessage().equals(t.getMessage())) {
                message = message + "\n(" + t.getCause().getMessage() + ")";
            }
        }
        return message;
    }

    public static String getOneLineMessageFromThrowable(Throwable t) {
        String s = ExceptionUtility.getMessageFromThrowable(t);
        s = s.replace('\n', ' ');
        s = s.replace('\r', ' ');
        return s;
    }

    static {
        $assertionsDisabled = !ExceptionUtility.class.desiredAssertionStatus();
        stackTraceRegex = Pattern.compile("at (.*)\\.([^\\.]+)\\(([^:]+)(:([0-9]+))?\\)");
        RUNTIME_EXCEPTION_MESSAGE = "An internal error has occurred.";
    }
}

