/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.util.AgitarProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class CmdOption {
    public static final int DEFAULT_SETTING = 0;
    public static final int HAS_TAGGED_VALUE = 1;
    public static final int REQUIRED = 2;
    public static final int READ_VALS_FROM_FILE = 4;
    public static final int CONVERT_TO_ABS_FILEPATH = 8;
    public static final int CHECK_INTEGER = 16;
    public static final int ENFORCE_FIXED_VALUES = 32;
    private String name = null;
    private boolean hasTaggedValue = false;
    private boolean required = false;
    private boolean taggedValsFromFile = false;
    private boolean convertToAbsFilePath = false;
    private boolean checkInteger = false;
    private boolean enforceFixedValues = false;
    private String helpStr = null;
    private HashSet enums = null;
    private String errMsg = null;
    private String onMsg = null;
    private String offMsg = null;
    private Object values = null;
    private Object defaultValues = null;
    private int index = -1;
    private static final HelpTextFormatter _htFormatter = new HelpTextFormatter();
    private String taggedValue;
    static /* synthetic */ Class class$com$agitar$common$util$CmdOption;

    public CmdOption(String name, int props) {
        this.name = name;
        this.hasTaggedValue = (1 & props) != 0;
        this.required = (2 & props) != 0;
        this.taggedValsFromFile = (4 & props) != 0;
        this.checkInteger = (0x10 & props) != 0;
        this.convertToAbsFilePath = (8 & props) != 0;
        this.enforceFixedValues = (0x20 & props) != 0;
    }

    public CmdOption(String name, int props, String defaultValue) {
        this(name, props);
        if (this.convertToAbsFilePath) {
            defaultValue = new File(defaultValue).getAbsolutePath();
        }
        this.values = defaultValue;
        this.defaultValues = defaultValue;
        this.offMsg = "[default] " + name + " = " + this.values;
    }

    public void setErrMessage(String errMsg) {
        this.errMsg = errMsg;
    }

    public void setOnMessage(String onMsg) {
        this.onMsg = onMsg;
    }

    public void setOffMessage(String offMsg) {
        this.offMsg = offMsg;
    }

    public void setHelpText(String taggedVal, String desc) {
        this.taggedValue = taggedVal;
        this.helpStr = _htFormatter.format(this.name, taggedVal, desc);
    }

    public void setAcceptableValues(String[] vals) {
        if (vals == null || vals.length == 0) {
            this.enums = null;
            return;
        }
        this.enums = new HashSet<String>(Arrays.asList(vals));
    }

    protected void setValues(Object vals) {
        this.values = vals;
    }

    protected void setPosition(int p) {
        this.index = p;
    }

    public int getPosition() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasTaggedValue() {
        return this.hasTaggedValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isValsFromFile() {
        return this.taggedValsFromFile;
    }

    public boolean convertToAbsFilePath() {
        return this.convertToAbsFilePath;
    }

    public boolean enforceFixedValues() {
        return this.enforceFixedValues;
    }

    public boolean checkInteger() {
        return this.checkInteger;
    }

    public String getErrMessage() {
        return this.errMsg;
    }

    public String getOnMessage() {
        return this.onMsg;
    }

    public String getOffMessage() {
        return this.offMsg;
    }

    public String gethelpText() {
        return this.helpStr;
    }

    protected HashSet getAcceptableValues() {
        return this.enums;
    }

    protected Object getDefaultValues() {
        return this.defaultValues;
    }

    public String getValue() {
        if (this.values != null) {
            return this.values.toString();
        }
        return null;
    }

    public List getValues() {
        if (this.values == null) {
            return null;
        }
        if (this.values instanceof List) {
            return (List)this.values;
        }
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.values.toString());
        return l;
    }

    public boolean isEnabled() {
        boolean enabled = false;
        if (this.values == null) {
            return enabled;
        }
        if (this.hasTaggedValue) {
            String s = this.values.toString().toLowerCase();
            enabled = !"no".equals(s) && !"false".equals(s) && !"off".equals(s);
        } else if (this.values instanceof Boolean) {
            enabled = (Boolean)this.values;
        }
        return enabled;
    }

    public boolean isSet() {
        return this.values != null;
    }

    public void clearValues() {
        this.values = this.defaultValues;
        this.index = -1;
    }

    public void addProperties(int props) {
        if ((props & 1) != 0) {
            this.hasTaggedValue = true;
        }
        if ((props & 2) != 0) {
            this.required = true;
        }
        if ((props & 4) != 0) {
            this.taggedValsFromFile = true;
        }
        if ((props & 8) != 0) {
            this.convertToAbsFilePath = true;
        }
        if ((props & 0x10) != 0) {
            this.checkInteger = true;
        }
        if (this.convertToAbsFilePath && this.values != null && this.index < 0 && this.values instanceof String) {
            this.values = new File((String)this.values).getAbsolutePath();
        }
    }

    public String getTaggedValue() {
        return this.taggedValue;
    }

    static final class HelpTextFormatter {
        private static final int _TOTAL_COL = 70;
        private static final int _NAME_COL = 20;
        private static final String wordbreak = " ,.";
        private int _totCol = 70;
        private int _nameCol = 20;
        private String _namePadStr = "";
        static final /* synthetic */ boolean $assertionsDisabled;

        public HelpTextFormatter() {
            this._initNamePadStr();
        }

        public HelpTextFormatter(int tCol, int nCol) {
            this._totCol = tCol;
            this._nameCol = nCol;
            this._initNamePadStr();
        }

        private void _initNamePadStr() {
            for (int i = 0; i < this._nameCol; ++i) {
                this._namePadStr = this._namePadStr + ' ';
            }
        }

        private String _padName(String name) {
            int nLen = name.length();
            name = nLen < this._nameCol ? name + this._namePadStr.substring(0, this._nameCol - nLen) : name + ' ';
            return name;
        }

        public String format(String name, String tVal, String desc) {
            if (!$assertionsDisabled && name == null) {
                throw new AssertionError();
            }
            StringBuffer fStr = new StringBuffer();
            if (tVal != null) {
                name = name + ' ' + tVal;
            }
            fStr.append(this._padName(name));
            String[] descs = this._breakLines(desc);
            for (int i = 0; i < descs.length; ++i) {
                if (i != 0) {
                    fStr.append(AgitarProperties.LINE_SEPARATOR).append(this._namePadStr);
                }
                fStr.append(descs[i]);
            }
            return fStr.toString();
        }

        private String[] _breakLines(String str) {
            int _maxCols = this._totCol - this._nameCol;
            ArrayList<String> ret = new ArrayList<String>();
            int n = str.length();
            int lastBreak = -1;
            int lineCount = 0;
            int start = 0;
            for (int i = 0; i < n; ++i) {
                char ch;
                if (i != 0 && i - start == _maxCols) {
                    if (lastBreak > start) {
                        ret.add(str.substring(start, lastBreak + 1));
                        start = lastBreak + 1;
                    } else {
                        int end = start + _maxCols;
                        end = end >= n ? n : end;
                        ret.add(str.substring(start, end));
                        start = end;
                    }
                    ++lineCount;
                }
                if ((ch = str.charAt(i)) == '\n' && start != i) {
                    ret.add(str.substring(start, i));
                    start = i + 1;
                    ++lineCount;
                    continue;
                }
                if (wordbreak.indexOf(ch) < 0) continue;
                lastBreak = i;
            }
            if (start < n) {
                String lastStr = str.substring(start);
                ret.add(lastStr);
                ++lineCount;
            }
            String[] sa = new String[lineCount];
            ret.toArray(sa);
            return sa;
        }

        static {
            $assertionsDisabled = !(class$com$agitar$common$util$CmdOption == null ? (class$com$agitar$common$util$CmdOption = CmdOption.class$("com.agitar.common.util.CmdOption")) : class$com$agitar$common$util$CmdOption).desiredAssertionStatus();
        }
    }
}

