/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

public class CmdLineParseException
extends Exception {
    static final String ERROR_TAG = "[Error]   ";
    static final String INVALID_OPTION = "Invalid Command Option: ";
    static final String INVALID_VALUE = "Invalid Value for ";
    static final String REQUIRED_OPTION_NOT_FOUND = "Command Option required: ";
    static final String FILE_ERROR = "File error occurs for ";
    static final String INVALID_NUMBER_TOO_MANY = "Invalid number of unswitched arguments. Expected at most ";
    static final String INVALID_NUMBER_TOO_FEW = "Invalid number of unswitched arguments. Expected at least ";
    static final String WRONG_TYPE0 = "Wrong type: value must be an Integer for ";

    public CmdLineParseException(String msg) {
        super(msg);
    }

    public static CmdLineParseException getInvalidOptionExc(String sw, String extraMsg) {
        StringBuffer sb = new StringBuffer(ERROR_TAG);
        sb.append(INVALID_OPTION).append(sw);
        if (extraMsg != null) {
            sb.append('\n').append(extraMsg);
        }
        return new CmdLineParseException(sb.toString());
    }

    public static CmdLineParseException getInvalidValueExc(String sw, String val, String extraMsg) {
        StringBuffer sb = new StringBuffer(ERROR_TAG);
        sb.append(INVALID_VALUE).append(sw).append(": ").append(val);
        if (extraMsg != null) {
            sb.append('\n').append(extraMsg);
        }
        return new CmdLineParseException(sb.toString());
    }

    public static CmdLineParseException getReqOptionNotFoundExc(String sw, String extraMsg) {
        StringBuffer sb = new StringBuffer(ERROR_TAG);
        sb.append(REQUIRED_OPTION_NOT_FOUND).append(sw);
        if (extraMsg != null) {
            sb.append('\n').append(extraMsg);
        }
        return new CmdLineParseException(sb.toString());
    }

    public static CmdLineParseException getFileRelatedExc(String sw, String val, Exception x) {
        StringBuffer sb = new StringBuffer(ERROR_TAG);
        sb.append(FILE_ERROR).append(sw).append(' ').append(val).append(':').append(x);
        return new CmdLineParseException(sb.toString());
    }

    public static CmdLineParseException getInvalidNumExc(int min, int max, int actual, String arguments) {
        StringBuffer sb = new StringBuffer(ERROR_TAG);
        if (actual < min) {
            sb.append(INVALID_NUMBER_TOO_FEW).append(min).append(" argument");
            if (min > 1) {
                sb.append('s');
            }
        } else {
            sb.append(INVALID_NUMBER_TOO_MANY).append(max).append(" argument");
            if (max > 1) {
                sb.append('s');
            }
        }
        sb.append('.');
        if (actual > 0) {
            if (actual > 1) {
                sb.append(" Got arguments: ");
            } else {
                sb.append(" Got argument: ");
            }
            sb.append(arguments);
        }
        return new CmdLineParseException(sb.toString());
    }

    public static CmdLineParseException getWrongTypeIntExc(String sw, String extraMsg) {
        StringBuffer sb = new StringBuffer(ERROR_TAG);
        sb.append(WRONG_TYPE0).append(sw);
        if (extraMsg != null) {
            sb.append('\n').append(extraMsg);
        }
        return new CmdLineParseException(sb.toString());
    }
}

