/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.util.CmdLineParseException;
import com.agitar.common.util.CmdOption;
import com.agitar.common.util.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class CmdLineArgs {
    private String[] preParsedArgs = null;
    private HashMap map = null;
    private List rest = null;
    private String usageStr = "";
    private boolean ignoreUnregisteredOption = false;
    private boolean exitOnFailure = false;
    private int minRestLength = 0;
    private int maxRestLength = 255;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CmdLineArgs() {
        this.map = new HashMap();
        this.rest = new ArrayList();
    }

    public CmdLineArgs(String[] args) {
        this.setPreParsedArgs(args);
        this.map = new HashMap();
        this.rest = new ArrayList();
    }

    public void setRestLength(int min, int max) {
        this.minRestLength = min;
        this.maxRestLength = max;
    }

    public void setRestLength(int exact) {
        this.minRestLength = this.maxRestLength = exact;
    }

    public void setUsageString(String str) {
        this.usageStr = str;
    }

    public void setIgnoreUnregisteredOption(boolean b) {
        this.ignoreUnregisteredOption = b;
    }

    public void registerOption(CmdOption opt) {
        if (!$assertionsDisabled && opt == null) {
            throw new AssertionError();
        }
        opt.clearValues();
        this.map.put(opt.getName(), opt);
    }

    public void registerOptions(CmdOption[] opts) {
        if (!$assertionsDisabled && opts == null) {
            throw new AssertionError();
        }
        for (int i = 0; i < opts.length; ++i) {
            if (opts[i] == null) continue;
            opts[i].clearValues();
            this.map.put(opts[i].getName(), opts[i]);
        }
    }

    public void unregisterOption(String optionName) {
        this.map.remove(optionName);
    }

    public void parse() throws CmdLineParseException {
        try {
            if (this.preParsedArgs == null) {
                throw new IllegalStateException("preParsedArgs must be set before calling parse()");
            }
            this._parse();
        }
        catch (CmdLineParseException x) {
            if (this.exitOnFailure) {
                this.informOfCmdLineParseException(x);
                System.exit(-1);
            }
            throw x;
        }
    }

    public void informOfCmdLineParseException(CmdLineParseException x) {
        System.err.println(x.getMessage());
        System.err.println("\n" + this.getUsageString());
    }

    private void _parse() throws CmdLineParseException {
        CmdOption opt = null;
        this.rest = new ArrayList();
        for (int i = 0; i < this.preParsedArgs.length; ++i) {
            String m;
            String s = this.preParsedArgs[i];
            if (s.length() == 0) continue;
            if (s.charAt(0) == '-') {
                if ("-help".equals(s)) {
                    System.err.println(this.getUsageString());
                    System.exit(0);
                }
                if ("-version".equals(s)) {
                    System.err.println(Version.getInstance().getFullNumber());
                    System.exit(0);
                }
                if (opt != null) {
                    if (opt.hasTaggedValue()) {
                        throw CmdLineParseException.getInvalidValueExc(opt.getName(), s, null);
                    }
                    opt.setValues(new Boolean(true));
                    m = opt.getOnMessage();
                    if (m != null) {
                        System.err.println(m);
                    }
                }
                if (!this.ignoreUnregisteredOption && !this.map.keySet().contains(s)) {
                    throw CmdLineParseException.getInvalidOptionExc(s, null);
                }
                opt = (CmdOption)this.map.get(s);
                if (opt == null) continue;
                opt.setPosition(i);
                continue;
            }
            if (opt != null) {
                if (opt.hasTaggedValue()) {
                    this.checkInteger(opt, s);
                    if (opt.convertToAbsFilePath()) {
                        s = new File(s).getAbsolutePath();
                    }
                    this.validateValue(opt, s);
                    if (opt.isValsFromFile()) {
                        opt.setValues(this.getFromFile(opt.getName(), s));
                    } else {
                        opt.setValues(s);
                    }
                    opt = null;
                    continue;
                }
                opt.setValues(new Boolean(true));
                m = opt.getOnMessage();
                if (m != null) {
                    System.err.println(m);
                }
            }
            this.rest.add(s);
            opt = null;
        }
        if (opt != null) {
            if (opt.hasTaggedValue()) {
                throw CmdLineParseException.getInvalidValueExc(opt.getName(), "", null);
            }
            opt.setValues(new Boolean(true));
        }
        Iterator i = this.map.values().iterator();
        while (i.hasNext()) {
            CmdOption o = (CmdOption)i.next();
            if (!o.isSet() && o.isRequired()) {
                throw CmdLineParseException.getReqOptionNotFoundExc(o.getName(), null);
            }
            if (o.getPosition() != -1 || o.getOffMessage() == null) continue;
            System.err.println(o.getOffMessage());
        }
        int l = this.rest.size();
        if (l < this.minRestLength || l > this.maxRestLength) {
            if (this.maxRestLength == 0) {
                throw CmdLineParseException.getInvalidOptionExc(this.concatList(this.rest), null);
            }
            throw CmdLineParseException.getInvalidNumExc(this.minRestLength, this.maxRestLength, l, this.concatList(this.rest));
        }
    }

    private String concatList(List list) {
        StringBuffer buf = new StringBuffer();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            buf.append(' ').append(element);
        }
        return buf.toString();
    }

    private void validateValue(CmdOption opt, String s) throws CmdLineParseException {
        boolean match;
        HashSet acceptable = opt.getAcceptableValues();
        if (acceptable != null && acceptable.size() > 0 && !(match = acceptable.contains(s))) {
            if (opt.enforceFixedValues()) {
                throw CmdLineParseException.getInvalidValueExc(opt.getName(), s, "Acceptable values are " + new ArrayList(acceptable));
            }
            Object def = opt.getDefaultValues();
            System.err.println("Invalid value for " + opt.getName() + ", use default: " + (def == null ? "no value" : def));
            opt.setValues(def);
        }
    }

    private void checkInteger(CmdOption opt, String s) throws CmdLineParseException {
        if (opt.checkInteger()) {
            try {
                Integer.parseInt(s);
            }
            catch (NumberFormatException nfx) {
                throw CmdLineParseException.getWrongTypeIntExc(opt.getName(), opt.getErrMessage());
            }
        }
    }

    public void parse(String[] args) throws CmdLineParseException {
        this.setPreParsedArgs(args);
        this.parse();
    }

    private void setPreParsedArgs(String[] args) {
        if (args == null) {
            throw new IllegalArgumentException("args can't be null");
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != null) continue;
            throw new IllegalArgumentException("args can't contain null");
        }
        this.preParsedArgs = args;
    }

    public String getUsageString() {
        StringBuffer sb = new StringBuffer(this.usageStr);
        sb.append('\n');
        CmdOption o = null;
        String help = null;
        TreeSet set = new TreeSet(this.map.keySet());
        Iterator i = set.iterator();
        while (i.hasNext()) {
            o = (CmdOption)this.map.get(i.next());
            help = o.gethelpText();
            if (help == null || "".equals(help)) continue;
            sb.append('\n').append(help);
        }
        sb.append('\n');
        return sb.toString();
    }

    private List getFromFile(String sw, String fname) throws CmdLineParseException {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(fname)));
            String line = null;
            ArrayList<String> l = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                int idx = line.indexOf(35);
                if (idx >= 0) {
                    if ((line = line.substring(0, idx).trim()).length() <= 0) continue;
                    l.add(line);
                    continue;
                }
                l.add(line);
            }
            return l;
        }
        catch (IOException iox) {
            throw CmdLineParseException.getFileRelatedExc(sw, fname, iox);
        }
    }

    public int getPosition(String optName) {
        CmdOption opt = (CmdOption)this.map.get(optName);
        if (opt != null) {
            return opt.getPosition();
        }
        return -1;
    }

    public CmdOption getCmdOption(String optName) {
        return (CmdOption)this.map.get(optName);
    }

    public String get(String optName) {
        CmdOption opt = (CmdOption)this.map.get(optName);
        if (opt != null) {
            return opt.getValue();
        }
        return null;
    }

    public List getList(String optName) {
        CmdOption opt = (CmdOption)this.map.get(optName);
        if (opt != null) {
            return opt.getValues();
        }
        return null;
    }

    public List getRest() {
        return this.rest;
    }

    public boolean isSet(String optName) {
        CmdOption opt = (CmdOption)this.map.get(optName);
        return opt != null && opt.isSet();
    }

    public boolean isEnabled(String optName) {
        CmdOption opt = (CmdOption)this.map.get(optName);
        return opt != null && opt.isEnabled();
    }

    public void clearValues() {
        this.rest.clear();
        Iterator i = this.map.values().iterator();
        while (i.hasNext()) {
            CmdOption opt = (CmdOption)i.next();
            opt.clearValues();
        }
    }

    public static CmdLineArgs getStandardBasicCmdLineArgs(String[] args) {
        CmdLineArgs parser = new CmdLineArgs(args);
        CmdOption p = new CmdOption("-p", 11);
        CmdOption uout = new CmdOption("-uout", 9);
        CmdOption out = new CmdOption("-out", 9);
        CmdOption uerr = new CmdOption("-uerr", 9);
        CmdOption cl = new CmdOption("-cl", 5);
        CmdOption loglevel = new CmdOption("-loglevel", 33);
        CmdOption d = new CmdOption("-d", 9);
        CmdOption dloglevel = new CmdOption("-dloglevel", 33);
        p.setHelpText("project", "The project file, this option is required.");
        uout.setHelpText("uofile", "Redirect standard out from user code to uofile");
        uerr.setHelpText("uefile", "Redirect standard err from user code to uofile");
        out.setHelpText("ofile", "Redirect standard out to ofile");
        cl.setHelpText("classlist", "A file containing a list of classes to process (regular expressions are allowed)");
        loglevel.setHelpText("level", "Set the user log level (defaults to INFO).Valid values are:FINE, CONFIG, INFO, STATUS, WARNING, SEVERE");
        String[] loglevels = new String[]{"ALL", "FINEST", "FINER", "FINE", "CONFIG", "INFO", "STATUS", "WARNING", "SEVERE"};
        loglevel.setAcceptableValues(loglevels);
        dloglevel.setAcceptableValues(loglevels);
        parser.registerOptions(new CmdOption[]{p, uout, out, uerr, cl, loglevel, d, dloglevel});
        return parser;
    }

    public String[] convertArgsToAbsFilePath(String[] args, String[] optNames) throws CmdLineParseException {
        int n = optNames.length;
        CmdOption[] opts = new CmdOption[n];
        for (int i = 0; i < optNames.length; ++i) {
            opts[i] = (CmdOption)this.map.get(optNames[i]);
            if (opts[i] != null) continue;
            opts[i] = new CmdOption(optNames[i], 0);
        }
        return this.convertArgsToAbsFilePath(args, opts);
    }

    public String[] convertArgsToAbsFilePath(String[] args, CmdOption[] opts) throws CmdLineParseException {
        int n = args.length;
        String[] newArgs = new String[n];
        System.arraycopy(args, 0, newArgs, 0, n);
        int props = 8;
        boolean savedIgnore = this.ignoreUnregisteredOption;
        this.ignoreUnregisteredOption = true;
        for (int i = 0; i < opts.length; ++i) {
            if (!opts[i].hasTaggedValue()) {
                throw new IllegalArgumentException("Options to convert must have tagged value.");
            }
            opts[i].addProperties(props);
            this.registerOption(opts[i]);
        }
        this.parse(newArgs);
        ArrayList<String> extras = new ArrayList<String>();
        for (int j = 0; j < opts.length; ++j) {
            int idx = opts[j].getPosition();
            if (idx >= 0) {
                if (opts[j].isValsFromFile()) {
                    newArgs[idx + 1] = new File(newArgs[idx + 1]).getAbsolutePath();
                    continue;
                }
                newArgs[idx + 1] = opts[j].getValue();
                continue;
            }
            if (!opts[j].isSet()) continue;
            extras.add(opts[j].getName());
            extras.add(opts[j].getValue());
        }
        int m = extras.size();
        if (m > 0) {
            String[] tmp = new String[n + m];
            System.arraycopy(newArgs, 0, tmp, 0, n);
            System.arraycopy(extras.toArray(), 0, tmp, n, m);
            newArgs = tmp;
        }
        this.ignoreUnregisteredOption = savedIgnore;
        return newArgs;
    }

    public void setExitOnFailure(boolean exitOnFailure) {
        this.exitOnFailure = exitOnFailure;
    }

    public String getParsed() {
        StringBuffer sb = new StringBuffer("---").append(this).append(":\n");
        Iterator it = this.map.keySet().iterator();
        while (it.hasNext()) {
            String opt = (String)it.next();
            CmdOption optObj = (CmdOption)this.map.get(opt);
            if (!optObj.isSet()) continue;
            sb.append(optObj.getName()).append(" = ").append(optObj.getValue()).append('\n');
        }
        return sb.toString();
    }

    static {
        $assertionsDisabled = !CmdLineArgs.class.desiredAssertionStatus();
    }
}

