/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.common.util;

import com.agitar.common.util.AssertionFailedException;

public class Assertions {
    public static void assertNotNull(String message, Object param) {
        Assertions.assertTrue(message, param != null);
    }

    public static void assertNull(String message, Object param) {
        Assertions.assertTrue(message, param == null);
    }

    public static void willNotHappen(String message) {
        Assertions.fail(message);
    }

    public static void willNotHappen(String message, Exception e) {
        throw new AssertionFailedException(message, e);
    }

    public static void assertNotEquals(String message, Object a, Object b) {
        Assertions.assertFalse(message, a.equals(b));
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        Assertions.assertTrue(message, expected.equals(actual));
    }

    public static void assertEquals(String message, int expected, int actual) {
        Assertions.assertTrue(message, expected == actual);
    }

    public static void assertMatchesRegex(String message, String regex, String actual) {
        Assertions.assertTrue(message, actual.matches(regex));
    }

    public static void assertBetween(String message, int min, int max, int value) {
        Assertions.assertTrue(message, value >= min && value <= max);
    }

    public static void assertTrue(String message, boolean condition) {
        if (!condition) {
            Assertions.fail(message);
        }
    }

    public static void fail(String message) {
        throw new AssertionFailedException(message);
    }

    public static void assertNotNullOrEmpty(String message, String param) {
        Assertions.assertNotNull(message, param);
        Assertions.assertTrue(message, param.trim().length() > 0);
    }

    public static void assertFalse(String message, boolean condition) {
        Assertions.assertTrue(message, !condition);
    }

    public static void notImplementedYet(String feature) {
        Assertions.fail(feature + " is not implemented yet");
    }
}

